/*
 * Decompiled with CFR 0.152.
 */
package com.autsia.bracer;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class BracerParser {
    private final String PLAIN_OPERATORS = "<>=+-*/&|!";
    private final Set<String> OPERATORS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final String SEPARATOR = ",";
    private Stack<String> stackOperations = new Stack();
    private Stack<String> stackRPN = new Stack();
    private Stack<String> stackAnswer = new Stack();

    public BracerParser() {
        this.OPERATORS.add("add");
        this.OPERATORS.add("or");
    }

    public void parse(String expression) throws ParseException {
        this.stackOperations.clear();
        this.stackRPN.clear();
        expression = expression.replace(" ", "").replace("(-", "(0-").replace(",-", ",0-").replace("(+", "(0+").replace(",+", ",0+").replace("true", "1").replace("false", "0").replace("or", "|").replace("and", "&");
        if (expression.charAt(0) == '-' || expression.charAt(0) == '+') {
            expression = "0" + expression;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(expression, "<>=+-*/&|!,()", true);
        String pendingToken = null;
        while (pendingToken != null || stringTokenizer.hasMoreTokens()) {
            String token;
            if (pendingToken != null) {
                token = pendingToken;
                pendingToken = null;
            } else {
                token = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                pendingToken = stringTokenizer.nextToken();
            }
            if (this.isSeparator(token)) {
                while (!this.stackOperations.empty() && !this.isOpenBracket((String)this.stackOperations.lastElement())) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                continue;
            }
            if (this.isOpenBracket(token)) {
                this.stackOperations.push(token);
                continue;
            }
            if (this.isCloseBracket(token)) {
                while (!this.stackOperations.empty() && !this.isOpenBracket((String)this.stackOperations.lastElement())) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                this.stackOperations.pop();
                if (this.stackOperations.empty() || !this.isFunction((String)this.stackOperations.lastElement())) continue;
                this.stackRPN.push(this.stackOperations.pop());
                continue;
            }
            if (this.isNumber(token)) {
                this.stackRPN.push(token);
                continue;
            }
            if (this.isOperator(token)) {
                if ((token.equals("<") || token.equals(">")) && "=".equals(pendingToken)) {
                    token = token + pendingToken;
                    pendingToken = null;
                }
                while (!this.stackOperations.empty() && this.isOperator((String)this.stackOperations.lastElement()) && this.getPrecedence(token) <= this.getPrecedence((String)this.stackOperations.lastElement())) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                this.stackOperations.push(token);
                continue;
            }
            if (this.isFunction(token)) {
                this.stackRPN.push(token);
                continue;
            }
            throw new ParseException("Unrecognized token: " + token, 0);
        }
        while (!this.stackOperations.empty()) {
            this.stackRPN.push(this.stackOperations.pop());
        }
        Collections.reverse(this.stackRPN);
    }

    public String evaluate() throws ParseException {
        if (this.stackRPN.empty()) {
            return "";
        }
        this.stackAnswer.clear();
        Stack stackRPN = (Stack)this.stackRPN.clone();
        block32: while (!stackRPN.empty()) {
            Double a;
            String token = (String)stackRPN.pop();
            if (this.isNumber(token)) {
                this.stackAnswer.push(token);
                continue;
            }
            if (this.isOperator(token)) {
                a = Double.valueOf(this.stackAnswer.pop());
                Double b = Double.valueOf(this.stackAnswer.pop());
                boolean aBoolean = a == 1.0;
                boolean bBoolean = b == 1.0;
                switch (token) {
                    case "+": {
                        this.stackAnswer.push(Double.toString(b + a));
                        break;
                    }
                    case "-": {
                        this.stackAnswer.push(Double.toString(b - a));
                        break;
                    }
                    case "*": {
                        this.stackAnswer.push(Double.toString(b * a));
                        break;
                    }
                    case "/": {
                        this.stackAnswer.push(Double.toString(b / a));
                        break;
                    }
                    case ">": {
                        this.stackAnswer.push(Integer.toString(b > a ? 1 : 0));
                        break;
                    }
                    case "|": {
                        this.stackAnswer.push(String.valueOf(aBoolean || bBoolean ? "1" : "0"));
                        break;
                    }
                    case "&": {
                        this.stackAnswer.push(String.valueOf(aBoolean && bBoolean ? "1" : "0"));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Do not know " + token);
                    }
                }
                continue;
            }
            if (!this.isFunction(token)) continue;
            a = Double.valueOf(this.stackAnswer.pop());
            boolean aBoolean = a == 1.0;
            switch (token) {
                case "cos": {
                    this.stackAnswer.push(Double.toString(Math.cos(a)));
                    continue block32;
                }
                case "exp": {
                    this.stackAnswer.push(Double.toString(Math.exp(a)));
                    continue block32;
                }
                case "sin": {
                    this.stackAnswer.push(Double.toString(Math.sin(a)));
                    continue block32;
                }
                case "pow": {
                    Double b = Double.valueOf(this.stackAnswer.pop());
                    this.stackAnswer.push(Double.toString(Math.pow(a, b)));
                    continue block32;
                }
                case "not": {
                    this.stackAnswer.push(String.valueOf(!aBoolean ? "1" : "0"));
                    continue block32;
                }
            }
            throw new IllegalStateException("Unexpected: " + token);
        }
        if (this.stackAnswer.size() > 1) {
            throw new ParseException("Some operator is missing", 0);
        }
        return this.stackAnswer.pop();
    }

    public Collection<String> getStackRPN() {
        return Collections.unmodifiableCollection(this.stackRPN);
    }

    private boolean isNumber(String token) {
        try {
            Double.parseDouble(token);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean isFunction(String token) {
        return Character.isAlphabetic(token.charAt(0));
    }

    private boolean isSeparator(String token) {
        return token.equals(",");
    }

    private boolean isOpenBracket(String token) {
        return token.equals("(");
    }

    private boolean isCloseBracket(String token) {
        return token.equals(")");
    }

    private boolean isOperator(String token) {
        return "<>=+-*/&|!".contains(token) || this.OPERATORS.contains(token);
    }

    private byte getPrecedence(String token) {
        if (token.equals("+") || token.equals("-")) {
            return 1;
        }
        return 2;
    }

    public String getRusEfi() {
        ArrayList<String> list = new ArrayList<String>(this.getStackRPN());
        ListIterator li = list.listIterator(list.size());
        ArrayList reverse = new ArrayList();
        StringBuilder sb = new StringBuilder();
        while (li.hasPrevious()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append((String)li.previous());
        }
        String result = ((Object)reverse).toString();
        return sb.toString();
    }
}

