/*
 * Decompiled with CFR 0.152.
 */
package com.autsia.bracer.test;

import com.autsia.bracer.BracerParser;
import java.text.ParseException;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class BracerParserTest {
    private BracerParser bracerParser;

    @Before
    public void setUp() throws Exception {
        this.bracerParser = new BracerParser();
    }

    @Test
    public void testSimpleBoolean() throws Exception {
        this.bracerParser.parse("true or false");
        Assert.assertEquals((Object)"1", (Object)this.bracerParser.evaluate());
        Assert.assertEquals((Object)"1 0 |", (Object)this.bracerParser.getRusEfi());
        this.bracerParser.parse("true > false");
        Assert.assertEquals((Object)"1", (Object)this.bracerParser.evaluate());
        Assert.assertEquals((Object)"1 0 >", (Object)this.bracerParser.getRusEfi());
        this.bracerParser.parse("(true > false)");
        Assert.assertEquals((Object)"1", (Object)this.bracerParser.evaluate());
        Assert.assertEquals((Object)"1 0 >", (Object)this.bracerParser.getRusEfi());
    }

    @Test
    public void testBooleanConversion() throws ParseException {
        this.bracerParser.parse("rpm > false");
        Assert.assertEquals((Object)"rpm 0 >", (Object)this.bracerParser.getRusEfi());
        this.bracerParser.parse("(rpm > false)");
        Assert.assertEquals((Object)"rpm 0 >", (Object)this.bracerParser.getRusEfi());
        this.bracerParser.parse("(rpm > user0) or (clt > user2) or (vbatt > user1)");
        Assert.assertEquals((Object)"rpm user0 > clt user2 > | vbatt user1 > |", (Object)this.bracerParser.getRusEfi());
    }

    @Test
    public void testBoolean() throws Exception {
        this.bracerParser.parse("( ( true and ( false or ( true and ( ( true ) or ( false ) ) ) ) ) and ( ( false ) ) )");
        Assert.assertEquals((Object)"0", (Object)this.bracerParser.evaluate());
        Collection<String> stackRPN = this.bracerParser.getStackRPN();
        Assert.assertEquals((Object)"[&, 0, &, |, &, |, 0, 1, 1, 0, 1]", (Object)stackRPN.toString());
    }

    @Test
    @Ignore
    public void testBooleanNot1() throws Exception {
        this.bracerParser.parse("not( ( true and ( false or ( true and ( not( true ) or ( false ) ) ) ) ) and ( ( false ) ) )");
        Assert.assertEquals((Object)"1", (Object)this.bracerParser.evaluate());
    }

    @Test
    public void testRusEfi() throws ParseException {
        this.bracerParser.parse("(time_since_boot < 4) | (rpm > 0)");
        Assert.assertEquals((Object)"time_since_boot 4 < rpm 0 > |", (Object)this.bracerParser.getRusEfi());
        this.bracerParser.parse("(fan and (coolant > fan_off_setting)) OR (coolant > fan_on_setting)");
        Assert.assertEquals((Object)"fan coolant fan_off_setting > & coolant fan_on_setting > OR", (Object)this.bracerParser.getRusEfi());
        this.bracerParser.parse("(time_since_boot <= 4) | (rpm > 0)");
        Assert.assertEquals((Object)"time_since_boot 4 <= rpm 0 > |", (Object)this.bracerParser.getRusEfi());
        this.bracerParser.parse("(time_since_boot <= 4) | (rpm > 0)");
        Assert.assertEquals((Object)"time_since_boot 4 <= rpm 0 > |", (Object)this.bracerParser.getRusEfi());
        this.bracerParser.parse("(time_since_boot <= 4) OR (rpm > 0)");
        Assert.assertEquals((Object)"time_since_boot 4 <= rpm 0 > OR", (Object)this.bracerParser.getRusEfi());
        this.bracerParser.parse("(self and (rpm > 4800)) OR (rpm > 5000)");
        Assert.assertEquals((Object)"self rpm 4800 > & rpm 5000 > OR", (Object)this.bracerParser.getRusEfi());
    }

    @Test
    public void testBooleanNot2() throws Exception {
        this.bracerParser.parse("1 & not(false)");
        Assert.assertEquals((Object)"0", (Object)this.bracerParser.evaluate());
        Assert.assertEquals((Object)"1 not 0 &", (Object)this.bracerParser.getRusEfi());
        this.bracerParser.parse("(((true | false) & not(false)) | (true | false))");
        Assert.assertEquals((Object)"1", (Object)this.bracerParser.evaluate());
        Assert.assertEquals((Object)"1 0 | not 0 & 1 0 | |", (Object)this.bracerParser.getRusEfi());
    }
}

