/*
 * Decompiled with CFR 0.152.
 */
package com.romraider;

import com.romraider.editor.ecu.ECUEditor;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.swing.LookAndFeelManager;
import com.romraider.util.JREChecker;
import com.romraider.util.LogManager;
import java.io.File;
import java.text.DateFormat;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ECUExec {
    private static final Logger LOGGER = Logger.getLogger(ECUExec.class);
    private static final String START_LOGGER_ARG = "-logger";
    private static final String START_LOGGER_FULLSCREEN_ARG = "-logger.fullscreen";

    private ECUExec() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        LogManager.initDebugLogging();
        LOGGER.info("RomRaider 0.5.8 RC 1 for rusEfi Build: 635");
        LOGGER.info("When requesting assistance at http://www.rusefi.com please include the System Properties information below:");
        LOGGER.info(DateFormat.getDateTimeInstance(0, 1).format(System.currentTimeMillis()));
        LOGGER.info("System Properties: \n\t" + System.getProperties().toString().replace(",", "\n\t"));
        if (!JREChecker.is32bit() && !ECUExec.containsLoggerArg(args)) {
            JOptionPane.showMessageDialog(null, "Incompatible JRE detected.\nRomRaider requires a 32-bit JRE for some operations.\nSome features may be unavailable.", "JRE Incompatibility Warning", 2);
        }
        LookAndFeelManager.initLookAndFeel();
        ECUExec.openEditor(args);
    }

    private static void showAlreadyRunningMessage() {
        JOptionPane.showMessageDialog(null, "RomRaider is already running.", "RomRaider", 1);
    }

    private static boolean containsLoggerArg(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase(START_LOGGER_ARG) && !arg.equalsIgnoreCase(START_LOGGER_FULLSCREEN_ARG)) continue;
            return true;
        }
        return false;
    }

    public static void openRom(final ECUEditor editor, final String rom) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(rom);
                    editor.openImage(file);
                }
                catch (Exception ex) {
                    LOGGER.error("Error opening rom", ex);
                }
            }
        });
    }

    private static void openEditor(String[] args) {
        ECUEditor editor = ECUEditorManager.getECUEditor();
        editor.initializeEditorUI();
        editor.checkDefinitions();
        if (args.length > 0) {
            ECUExec.openRom(editor, args[0]);
        }
    }
}

