/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.editor.ecu;

import com.romraider.editor.ecu.ECUEditor;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.maps.Rom;
import com.romraider.swing.RomTreeRootNode;
import com.rusefi.Launcher;
import javax.swing.SwingWorker;

class CloseImageWorker
extends SwingWorker<Void, Void> {
    Rom rom;

    public CloseImageWorker(Rom romToRemove) {
        this.rom = romToRemove;
    }

    @Override
    protected Void doInBackground() throws Exception {
        ECUEditor editor = ECUEditorManager.getECUEditor();
        RomTreeRootNode imageRoot = editor.getImageRoot();
        this.rom.clearData();
        this.rom.removeFromParent();
        this.rom = null;
        if (imageRoot.getChildCount() > 0) {
            editor.setLastSelectedRom((Rom)imageRoot.getChildAt(0));
        } else {
            editor.setLastSelectedRom(null);
        }
        editor.refreshTableCompareMenus();
        return null;
    }

    @Override
    public void done() {
        ECUEditor editor = ECUEditorManager.getECUEditor();
        editor.getStatusPanel().setStatus("Ready...");
        this.setProgress(0);
        Launcher.getFrame().setCursor(null);
        editor.refreshUI();
        System.gc();
    }
}

