/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.editor.ecu;

import com.romraider.Settings;
import com.romraider.editor.ecu.CloseImageWorker;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.editor.ecu.LaunchLoggerWorker;
import com.romraider.editor.ecu.OpenImageWorker;
import com.romraider.editor.ecu.SetUserLevelWorker;
import com.romraider.maps.Rom;
import com.romraider.swing.CustomToolbarLayout;
import com.romraider.swing.ECUEditorMenuBar;
import com.romraider.swing.ECUEditorToolBar;
import com.romraider.swing.JProgressPane;
import com.romraider.swing.MDIDesktopPane;
import com.romraider.swing.RomTree;
import com.romraider.swing.RomTreeRootNode;
import com.romraider.swing.TableFrame;
import com.romraider.swing.TableToolBar;
import com.romraider.util.SettingsManager;
import com.romraider.xml.DOMRomUnmarshaller;
import com.romraider.xml.RomNotFoundException;
import com.rusefi.Launcher;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.management.modelmbean.XMLParseException;
import javax.naming.NameNotFoundException;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ECUEditor {
    private final String titleText = "RomRaider v0.5.8 RC 1 for rusEfi | ECU Editor";
    private final RomTreeRootNode imageRoot = new RomTreeRootNode("Open Images");
    private final RomTree imageList = new RomTree(this.imageRoot);
    public MDIDesktopPane rightPanel = new MDIDesktopPane();
    public JProgressPane statusPanel = new JProgressPane();
    private JSplitPane splitPane = new JSplitPane();
    private Rom lastSelectedRom = null;
    private ECUEditorToolBar toolBar;
    private ECUEditorMenuBar menuBar;
    private TableToolBar tableToolBar;
    private final JPanel toolBarPanel = new JPanel();
    private OpenImageWorker openImageWorker;
    private CloseImageWorker closeImageWorker;
    private SetUserLevelWorker setUserLevelWorker;
    private LaunchLoggerWorker launchLoggerWorker;
    private final ImageIcon editorIcon = new ImageIcon(this.getClass().getResource("/graphics/romraider-ico.gif"), "RomRaider ECU Editor");
    WindowListener wListenr = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            ECUEditor.this.handleExit();
        }
    };
    JPanel content = new JPanel(new BorderLayout());

    public ECUEditor() {
        Settings settings = SettingsManager.getSettings();
        if (!settings.getRecentVersion().equalsIgnoreCase("0.5.8 RC 1 for rusEfi")) {
            this.showReleaseNotes();
        }
        JScrollPane rightScrollPane = new JScrollPane(this.rightPanel, 20, 30);
        JScrollPane leftScrollPane = new JScrollPane(this.imageList, 20, 30);
        this.splitPane = new JSplitPane(1, leftScrollPane, rightScrollPane);
        this.splitPane.setDividerSize(3);
        this.splitPane.setDividerLocation(settings.getSplitPaneLocation());
        this.splitPane.setContinuousLayout(true);
        this.content.add((Component)this.splitPane, "Center");
        this.rightPanel.setBackground(Color.BLACK);
        this.imageList.setScrollsOnExpand(true);
        Launcher.getFrame().addWindowListener(this.wListenr);
    }

    public static void openImage(byte[] fileContent) throws IOException, SAXException, RomNotFoundException, XMLParseException, NameNotFoundException {
        ECUEditor.openImage(fileContent, SettingsManager.getSettings().getEcuDefinitionFiles().elementAt(0), "rusEfi");
    }

    public JPanel getContent() {
        return this.content;
    }

    public static void openImage(byte[] input, File definitionFile, String fileName) throws IOException, SAXException, RomNotFoundException, XMLParseException, NameNotFoundException {
        ECUEditor editor = ECUEditorManager.getECUEditor();
        Rom rom = ECUEditor.readRom(input, definitionFile, editor);
        editor.getStatusPanel().setStatus("Populating tables...");
        rom.setFullFileName(fileName);
        rom.populateTables(input, editor.getStatusPanel());
        editor.getStatusPanel().setStatus("Finalizing...");
        editor.addRom(rom);
        editor.refreshTableCompareMenus();
        editor.getStatusPanel().setStatus("Done loading image...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rom readRom(byte[] romContent, File romDefinitionFile, ECUEditor editor) throws SAXException, IOException, RomNotFoundException, XMLParseException, NameNotFoundException {
        Rom rom;
        DOMParser parser = new DOMParser();
        FileInputStream fileStream = new FileInputStream(romDefinitionFile);
        InputSource src = new InputSource(fileStream);
        parser.parse(src);
        Document doc = parser.getDocument();
        try {
            rom = new DOMRomUnmarshaller().unmarshallXMLDefinition(doc.getDocumentElement(), romContent, editor.getStatusPanel());
        }
        finally {
            parser.reset();
            doc.removeChild(doc.getDocumentElement());
            fileStream.close();
            System.gc();
        }
        return rom;
    }

    public void initializeEditorUI() {
        this.menuBar = new ECUEditorMenuBar();
        this.toolBar = new ECUEditorToolBar("Editor Tools");
        this.tableToolBar = new TableToolBar();
        this.tableToolBar.updateTableToolBar();
        CustomToolbarLayout toolBarLayout = new CustomToolbarLayout(0, 0, 0);
        this.toolBarPanel.setLayout(toolBarLayout);
        this.toolBarPanel.add(this.toolBar);
        this.toolBarPanel.add(this.tableToolBar);
        this.toolBarPanel.setVisible(true);
        this.content.add((Component)this.toolBarPanel, "North");
        this.content.validate();
    }

    public void checkDefinitions() {
        Object[] options;
        int answer;
        if (SettingsManager.getSettings().getEcuDefinitionFiles().size() <= 0 && (answer = JOptionPane.showOptionDialog(null, "ECU definitions not configured.\nGo online to download the latest definition files?", "Editor Configuration", -1, 2, null, options = new Object[]{"Yes", "No"}, options[0])) != 0) {
            JOptionPane.showMessageDialog(Launcher.getFrame(), "ECU definition files need to be configured before ROM images can be opened.\nMenu: ECU Definitions > ECU Definition Manager...", "Editor Configuration", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showReleaseNotes() {
        try (BufferedReader br = new BufferedReader(new FileReader(SettingsManager.getSettings().getReleaseNotes()));){
            JTextArea releaseNotes = new JTextArea();
            releaseNotes.setEditable(false);
            releaseNotes.setWrapStyleWord(true);
            releaseNotes.setLineWrap(true);
            releaseNotes.setFont(new Font("Tahoma", 0, 12));
            StringBuffer sb = new StringBuffer();
            while (br.ready()) {
                sb.append(br.readLine()).append(Settings.NEW_LINE);
            }
            releaseNotes.setText(sb.toString());
            releaseNotes.setCaretPosition(0);
            JScrollPane scroller = new JScrollPane(releaseNotes, 22, 31);
            scroller.setPreferredSize(new Dimension(600, 500));
            JOptionPane.showMessageDialog(Launcher.getFrame(), scroller, "RomRaider0.5.8 RC 1 for rusEfi Release Notes", 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleExit() {
        Settings settings = SettingsManager.getSettings();
        settings.setSplitPaneLocation(this.splitPane.getDividerLocation());
        SettingsManager.save(settings, this.statusPanel);
        this.statusPanel.update("Ready...", 0);
        this.content.repaint();
    }

    public String getVersion() {
        return "0.5.8 RC 1 for rusEfi";
    }

    public void addRom(Rom input) {
        Settings settings = SettingsManager.getSettings();
        input.refreshDisplayedTables();
        this.getImageRoot().add(input);
        this.getImageList().setVisible(true);
        this.getImageList().expandPath(new TreePath(this.getImageRoot()));
        this.getImageList().expandPath(new TreePath(input.getPath()));
        if (!settings.isOpenExpanded()) {
            this.imageList.collapsePath(new TreePath(input.getPath()));
        }
        this.getImageList().setRootVisible(false);
        this.getImageList().repaint();
        if (null == this.getLastSelectedRom()) {
            this.setLastSelectedRom(input);
        }
        if (input.getRomID().isObsolete() && settings.isObsoleteWarning()) {
            JPanel infoPanel = new JPanel();
            infoPanel.setLayout(new GridLayout(3, 1));
            infoPanel.add(new JLabel("A newer version of this ECU revision exists. Please visit the following link to download the latest revision:"));
            JCheckBox check = new JCheckBox("Always display this message", true);
            check.setHorizontalAlignment(4);
            check.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SettingsManager.getSettings().setObsoleteWarning(((JCheckBox)e.getSource()).isSelected());
                }
            });
            infoPanel.add(check);
            JOptionPane.showMessageDialog(Launcher.getFrame(), infoPanel, "ECU Revision is Obsolete", 1);
        }
    }

    public void displayTable(TableFrame frame) {
        try {
            for (JInternalFrame curFrame : this.getRightPanel().getAllFrames()) {
                if (!curFrame.equals(frame)) continue;
                if (1 == SettingsManager.getSettings().getTableClickBehavior()) {
                    boolean selected = true;
                    frame.toFront();
                    try {
                        frame.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        frame.toBack();
                        selected = false;
                    }
                    if (selected) {
                        frame.requestFocusInWindow();
                    }
                } else {
                    this.rightPanel.remove(frame);
                    frame.setVisible(false);
                    try {
                        frame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    frame.dispose();
                }
                frame.pack();
                this.rightPanel.repaint();
                return;
            }
            frame.getTable().drawTable();
            this.rightPanel.add(frame);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        frame.pack();
        this.rightPanel.repaint();
    }

    public void removeDisplayTable(TableFrame frame) {
        frame.setVisible(false);
        this.getTableToolBar().updateTableToolBar();
        this.rightPanel.remove(frame);
        this.rightPanel.validate();
        this.refreshUI();
    }

    public void closeImage() {
        Launcher.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.closeImageWorker = new CloseImageWorker(this.getLastSelectedRom());
        this.closeImageWorker.addPropertyChangeListener(this.getStatusPanel());
        this.closeImageWorker.execute();
    }

    public void closeAllImages() {
        while (this.imageRoot.getChildCount() > 0) {
            this.closeImage();
        }
    }

    public Rom getLastSelectedRom() {
        return this.lastSelectedRom;
    }

    public String getLastSelectedRomFileName() {
        Rom lastSelRom = this.getLastSelectedRom();
        return lastSelRom == null ? "" : lastSelRom.getFileName() + " ";
    }

    public void setLastSelectedRom(Rom lastSelectedRom) {
        this.lastSelectedRom = lastSelectedRom;
    }

    public ECUEditorToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(ECUEditorToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public ECUEditorMenuBar getEditorMenuBar() {
        return this.menuBar;
    }

    public TableToolBar getTableToolBar() {
        return this.tableToolBar;
    }

    public void redrawVisableTables(Settings settings) {
    }

    public void setUserLevel(int userLevel) {
        this.content.setCursor(Cursor.getPredefinedCursor(3));
        SettingsManager.getSettings().setUserLevel(userLevel);
        this.setUserLevelWorker = new SetUserLevelWorker();
        this.setUserLevelWorker.addPropertyChangeListener(this.getStatusPanel());
        this.setUserLevelWorker.execute();
    }

    public Vector<Rom> getImages() {
        Vector<Rom> images = new Vector<Rom>();
        for (int i = 0; i < this.imageRoot.getChildCount(); ++i) {
            Rom rom;
            if (!(this.imageRoot.getChildAt(i) instanceof Rom) || null == (rom = (Rom)this.imageRoot.getChildAt(i))) continue;
            images.add(rom);
        }
        return images;
    }

    public void refreshUI() {
        this.getToolBar().updateButtons();
        this.getEditorMenuBar().updateMenu();
        this.getTableToolBar().updateTableToolBar();
        this.imageList.updateUI();
        this.imageList.repaint();
        this.rightPanel.updateUI();
        this.rightPanel.repaint();
    }

    public void refreshTableCompareMenus() {
        for (int i = 0; i < this.imageRoot.getChildCount(); ++i) {
            Rom rom;
            if (!(this.imageRoot.getChildAt(i) instanceof Rom) || null == (rom = (Rom)this.imageRoot.getChildAt(i))) continue;
            rom.refreshTableCompareMenus();
        }
    }

    public void openImage(File inputFile) throws Exception {
        Launcher.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.openImageWorker = new OpenImageWorker(inputFile);
        this.openImageWorker.addPropertyChangeListener(this.getStatusPanel());
        this.openImageWorker.execute();
    }

    public static byte[] readFile(File inputFile) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FileInputStream fis = new FileInputStream(inputFile);){
            int bytesRead;
            byte[] buf = new byte[8192];
            while ((bytesRead = fis.read(buf)) != -1) {
                baos.write(buf, 0, bytesRead);
            }
        }
        return baos.toByteArray();
    }

    public void launchLogger() {
        Launcher.getFrame().setCursor(Cursor.getPredefinedCursor(3));
    }

    public RomTreeRootNode getImageRoot() {
        return this.imageRoot;
    }

    public RomTree getImageList() {
        return this.imageList;
    }

    public JProgressPane getStatusPanel() {
        return this.statusPanel;
    }

    public MDIDesktopPane getRightPanel() {
        return this.rightPanel;
    }
}

