/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.editor.ecu;

import com.romraider.Settings;
import com.romraider.editor.ecu.ECUEditor;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.util.SettingsManager;
import com.romraider.xml.RomNotFoundException;
import com.rusefi.Launcher;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.xml.sax.SAXParseException;

class OpenImageWorker
extends SwingWorker<Void, Void> {
    private final File inputFile;

    public OpenImageWorker(File inputFile) {
        this.inputFile = inputFile;
    }

    @Override
    protected Void doInBackground() throws Exception {
        ECUEditor editor = ECUEditorManager.getECUEditor();
        Settings settings = SettingsManager.getSettings();
        try {
            editor.getStatusPanel().setStatus("Parsing ECU definitions...");
            this.setProgress(0);
            byte[] input = ECUEditor.readFile(this.inputFile);
            editor.getStatusPanel().setStatus("Finding ECU definition...");
            this.setProgress(10);
            for (int i = 0; i < settings.getEcuDefinitionFiles().size(); ++i) {
                File definitionFile = settings.getEcuDefinitionFiles().get(i);
                try {
                    ECUEditor.openImage(input, definitionFile, this.inputFile.getName());
                    this.setProgress(100);
                    return null;
                }
                catch (RomNotFoundException romNotFoundException) {
                    continue;
                }
            }
            JOptionPane.showMessageDialog(Launcher.getFrame(), "ECU Definition Not Found", "Error Loading " + this.inputFile.getName(), 0);
        }
        catch (SAXParseException spe) {
            JOptionPane.showMessageDialog(Launcher.getFrame(), "Unable to read XML definitions.  Please make sure the definition file is correct.  If it is in a ZIP archive, unzip the file and try again.", "Error Loading " + this.inputFile.getName(), 0);
        }
        catch (StackOverflowError ex) {
            JOptionPane.showMessageDialog(Launcher.getFrame(), "Looped \"base\" attribute in XML definitions.", "Error Loading " + this.inputFile.getName(), 0);
        }
        catch (OutOfMemoryError ome) {
            JOptionPane.showMessageDialog(Launcher.getFrame(), "Error loading Image. Out of memeory.", "Error Loading " + this.inputFile.getName(), 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(Launcher.getFrame(), "Error Loading.  Unknown Exception.", "Error Loading " + this.inputFile.getName(), 0);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evnt) {
        SwingWorker source = (SwingWorker)evnt.getSource();
        if (null != source && "state".equals(evnt.getPropertyName()) && (source.isDone() || source.isCancelled())) {
            source.removePropertyChangeListener(ECUEditorManager.getECUEditor().getStatusPanel());
        }
    }

    @Override
    public void done() {
        ECUEditor editor = ECUEditorManager.getECUEditor();
        editor.getStatusPanel().setStatus("Ready...");
        this.setProgress(0);
        Launcher.getFrame().setCursor(null);
        editor.refreshUI();
        System.gc();
    }
}

