/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.comms.query;

import com.romraider.logger.ecu.comms.query.EcuQuery;
import com.romraider.logger.ecu.definition.EcuData;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;

public final class EcuQueryImpl
implements EcuQuery {
    private final EcuData ecuData;
    private final byte[] bytes;
    private final String hex;
    private double response;

    public EcuQueryImpl(EcuData ecuData) {
        ParamChecker.checkNotNull(ecuData);
        this.ecuData = ecuData;
        this.bytes = ecuData.getAddress().getBytes();
        this.hex = HexUtil.asHex(this.bytes);
    }

    @Override
    public LoggerData getLoggerData() {
        return this.ecuData;
    }

    @Override
    public String[] getAddresses() {
        return this.ecuData.getAddress().getAddresses();
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String getHex() {
        return this.hex;
    }

    @Override
    public double getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(byte[] bytes) {
        this.response = this.ecuData.getSelectedConvertor().convert(bytes);
    }

    public boolean equals(Object object) {
        return object instanceof EcuQueryImpl && this.getHex().equals(((EcuQueryImpl)object).getHex());
    }

    public int hashCode() {
        return this.getHex().hashCode();
    }

    public String toString() {
        return "0x" + this.getHex();
    }
}

