/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.comms.query;

import com.romraider.logger.ecu.comms.query.EcuInit;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;

public final class SSMEcuInit
implements EcuInit {
    private byte[] ecuInitBytes;
    private String ecuId;

    public SSMEcuInit(byte[] ecuInitBytes) {
        ParamChecker.checkNotNullOrEmpty(ecuInitBytes, "ecuInitBytes");
        this.ecuInitBytes = ecuInitBytes;
        byte[] ecuIdBytes = new byte[5];
        System.arraycopy(ecuInitBytes, 3, ecuIdBytes, 0, 5);
        this.ecuId = HexUtil.asHex(ecuIdBytes);
    }

    @Override
    public String getEcuId() {
        return this.ecuId;
    }

    @Override
    public byte[] getEcuInitBytes() {
        return this.ecuInitBytes;
    }
}

