/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition;

import com.romraider.logger.ecu.definition.EcuAddress;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;
import java.util.LinkedList;

public final class EcuAddressImpl
implements EcuAddress {
    private final String[] addresses;
    private final byte[] bytes;
    private final int bit;

    public EcuAddressImpl(String address, int length, int bit) {
        ParamChecker.checkNotNullOrEmpty(address, "address");
        ParamChecker.checkGreaterThanZero(length, "length");
        String[] addrSting = new String[]{address};
        this.addresses = this.buildAddresses(addrSting, length);
        this.bytes = this.getAddressBytes(this.addresses);
        this.bit = bit;
    }

    public EcuAddressImpl(String[] address, int length, int bit) {
        ParamChecker.checkNotNullOrEmpty(address, "address");
        ParamChecker.checkGreaterThanZero(length, "length");
        this.addresses = this.buildAddresses(address, length);
        this.bytes = this.getAddressBytes(this.addresses);
        this.bit = bit;
    }

    public EcuAddressImpl(String[] addresses) {
        ParamChecker.checkNotNullOrEmpty(addresses, "addresses");
        this.addresses = addresses;
        this.bytes = this.getAddressBytes(addresses);
        this.bit = -1;
    }

    @Override
    public String[] getAddresses() {
        return this.addresses;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public int getBit() {
        return this.bit;
    }

    @Override
    public int getLength() {
        return this.addresses.length;
    }

    private String[] buildAddresses(String[] startAddress, int addressLength) {
        LinkedList<String> addresses = new LinkedList<String>();
        if (startAddress.length > addressLength) {
            for (int i = 0; i < startAddress.length; ++i) {
                int address = HexUtil.hexToInt(startAddress[i]);
                addresses.add(this.padAddress(HexUtil.intToHexString(address), startAddress[i].length()));
            }
        } else {
            int start = HexUtil.hexToInt(startAddress[0]);
            for (int i = 0; i < addressLength; ++i) {
                addresses.add(this.padAddress(HexUtil.intToHexString(start + i), startAddress[0].length()));
            }
        }
        return addresses.toArray(new String[addresses.size()]);
    }

    private String padAddress(String address, int length) {
        if (address.length() == length) {
            return address;
        }
        StringBuilder builder = new StringBuilder(length);
        builder.append("0x");
        String s = address.substring(2);
        for (int i = 0; i < length - s.length() - 2; ++i) {
            builder.append('0');
        }
        builder.append(s);
        return builder.toString();
    }

    private byte[] getAddressBytes(String[] addresses) {
        byte[] bytes = new byte[]{};
        for (String address : addresses) {
            byte[] tmp1 = HexUtil.asBytes(address);
            byte[] tmp2 = new byte[bytes.length + tmp1.length];
            System.arraycopy(bytes, 0, tmp2, 0, bytes.length);
            System.arraycopy(tmp1, 0, tmp2, bytes.length, tmp1.length);
            bytes = tmp2;
        }
        return bytes;
    }
}

