/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition.xml;

import com.romraider.logger.ecu.definition.EcuDefinition;
import com.romraider.logger.ecu.definition.EcuDefinitionImpl;
import com.romraider.util.ParamChecker;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class EcuDefinitionHandler
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(EcuDefinitionHandler.class);
    private static final String TAG_ROM = "rom";
    private static final String TAG_ROMID = "romid";
    private static final String TAG_CALID = "internalidstring";
    private static final String TAG_ECUID = "ecuid";
    private static final String TAG_CASEID = "caseid";
    private static final String TAG_ADDRESS = "internalidaddress";
    private static final String TAG_YEAR = "year";
    private static final String TAG_MARKET = "market";
    private static final String TAG_MAKE = "make";
    private static final String TAG_MODEL = "model";
    private static final String TAG_SUBMODEL = "submodel";
    private static final String TAG_TRANS = "transmission";
    private static final String TAG_MEMMODEL = "memmodel";
    private static final String TAG_FLASH = "flashmethod";
    private static final String TAG_SIZE = "filesize";
    private static final String TAG_OBSOLETE = "obsolete";
    private static final String ATTR_BASE = "base";
    private Map<String, EcuDefinition> ecuDefinitionMap = new HashMap<String, EcuDefinition>();
    private String calId;
    private String ecuId;
    private String caseId;
    private String address;
    private String year;
    private String market;
    private String make;
    private String model;
    private String submodel;
    private String transmission;
    private String memmodel;
    private String flashmethod;
    private String filesize;
    private String obsolete;
    private String inherit;
    private String carString;
    private StringBuilder charBuffer;
    private File ecuDefsFile;

    public EcuDefinitionHandler(File ecuDefsFile) {
        this.ecuDefsFile = ecuDefsFile;
    }

    @Override
    public void startDocument() {
        this.ecuDefinitionMap = new HashMap<String, EcuDefinition>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (TAG_ROM.equals(qName)) {
            this.inherit = attributes.getValue(ATTR_BASE);
        } else if (TAG_ROMID.equals(qName)) {
            this.calId = "";
            this.ecuId = "";
            this.caseId = "";
            this.address = "";
            this.year = "";
            this.market = "";
            this.make = "";
            this.model = "";
            this.submodel = "";
            this.transmission = "";
            this.memmodel = "";
            this.flashmethod = "";
            this.filesize = "";
            this.obsolete = "0";
            this.carString = "";
        }
        this.charBuffer = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.charBuffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        block38: {
            if (TAG_ROM.equals(qName)) {
                this.inherit = null;
            } else if (TAG_ROMID.equals(qName)) {
                if (!(ParamChecker.isNullOrEmpty(this.ecuId) || ParamChecker.isNullOrEmpty(this.calId) || ParamChecker.isNullOrEmpty(this.year) || ParamChecker.isNullOrEmpty(this.market) || ParamChecker.isNullOrEmpty(this.make) || ParamChecker.isNullOrEmpty(this.model) || ParamChecker.isNullOrEmpty(this.submodel) || ParamChecker.isNullOrEmpty(this.transmission))) {
                    this.carString = String.format("%s %s %s %s %s %s", this.year, this.market, this.make, this.model, this.submodel, this.transmission);
                    this.ecuDefinitionMap.put(this.ecuId, new EcuDefinitionImpl(this.ecuId, this.calId, this.carString, this.inherit, this.ecuDefsFile));
                }
                if (!(ParamChecker.isNullOrEmpty(this.ecuId) || ParamChecker.isNullOrEmpty(this.calId) || ParamChecker.isNullOrEmpty(this.address) || ParamChecker.isNullOrEmpty(this.year) || ParamChecker.isNullOrEmpty(this.market) || ParamChecker.isNullOrEmpty(this.make) || ParamChecker.isNullOrEmpty(this.model) || ParamChecker.isNullOrEmpty(this.submodel) || ParamChecker.isNullOrEmpty(this.transmission) || ParamChecker.isNullOrEmpty(this.memmodel) || ParamChecker.isNullOrEmpty(this.flashmethod) || ParamChecker.isNullOrEmpty(this.obsolete))) {
                    LOGGER.debug(this.romDetail());
                }
            } else if (TAG_CALID.equals(qName)) {
                this.calId = this.charBuffer.toString();
            } else if (TAG_ECUID.equals(qName)) {
                this.ecuId = this.charBuffer.toString();
            } else if (TAG_CASEID.equals(qName)) {
                this.caseId = this.charBuffer.toString();
            } else if (TAG_ADDRESS.equals(qName)) {
                this.address = this.charBuffer.toString();
            } else if (TAG_YEAR.equals(qName)) {
                this.year = this.charBuffer.toString();
                if (!this.year.isEmpty()) {
                    try {
                        if (Integer.parseInt(this.year) < 90) {
                            this.year = "20" + this.year;
                        }
                        break block38;
                    }
                    catch (NumberFormatException e) {
                        if ((this.year.contains("/") || this.year.contains("-")) && this.year.length() < 6) {
                            this.year = "20" + this.year;
                        }
                        break block38;
                    }
                }
                this.year = "20xx";
            } else if (TAG_MARKET.equals(qName)) {
                this.market = this.charBuffer.toString();
            } else if (TAG_MAKE.equals(qName)) {
                this.make = this.charBuffer.toString();
            } else if (TAG_MODEL.equals(qName)) {
                this.model = this.charBuffer.toString();
            } else if (TAG_SUBMODEL.equals(qName)) {
                this.submodel = this.charBuffer.toString();
            } else if (TAG_TRANS.equals(qName)) {
                this.transmission = this.charBuffer.toString();
            } else if (TAG_MEMMODEL.equals(qName)) {
                this.memmodel = this.charBuffer.toString();
            } else if (TAG_FLASH.equals(qName)) {
                this.flashmethod = this.charBuffer.toString();
            } else if (TAG_SIZE.equals(qName)) {
                this.filesize = this.charBuffer.toString();
            } else if (TAG_OBSOLETE.equals(qName)) {
                this.obsolete = this.charBuffer.toString();
            }
        }
    }

    public Map<String, EcuDefinition> getEcuDefinitionMap() {
        return this.ecuDefinitionMap;
    }

    public String romDetail() {
        return String.format("calid='%s',address='%s',string='%s',caseid='%s',year='%s',market='%s',make='%s',model='%s',submodel='%s',transmission='%s',memmodel='%s',flash='%s',filesize='%s',obsolete='%s',inherit='%s'file='%s'", this.calId, this.address, this.calId, this.caseId, this.year, this.market, this.make, this.model, this.submodel, this.transmission, this.memmodel, this.flashmethod, this.filesize, this.obsolete, this.inherit, this.ecuDefsFile.getName());
    }
}

