/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition.xml;

import com.romraider.logger.ecu.definition.EcuDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EcuDefinitionInheritanceList {
    private EcuDefinitionInheritanceList() {
    }

    public static final List<Node> getInheritanceList(Document document, EcuDefinition ecuDef) {
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        ArrayList<String> inheritance = new ArrayList<String>();
        inheritance.add(ecuDef.getCalId());
        inheritance.add(ecuDef.getInherits());
        String base = ecuDef.getInherits();
        while (!base.contains("BASE")) {
            base = EcuDefinitionInheritanceList.getBaseRomId(xpath, document, base);
            inheritance.add(base);
        }
        ArrayList<Node> inheritanceNodes = new ArrayList<Node>();
        for (String inheritId : inheritance) {
            Node baseNode = EcuDefinitionInheritanceList.getBaseRomIdNode(xpath, document, inheritId);
            inheritanceNodes.add(baseNode);
        }
        return inheritanceNodes;
    }

    private static final String getBaseRomId(XPath xpath, Document document, String calId) {
        String romBase = null;
        try {
            Node calidNode = (Node)xpath.evaluate("/roms/rom/romid[xmlid='" + calId + "']", document, XPathConstants.NODE);
            romBase = calidNode.getParentNode().getAttributes().item(0).getNodeValue();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return romBase;
    }

    private static final Node getBaseRomIdNode(XPath xpath, Document document, String calId) {
        Node romIdNode = null;
        try {
            romIdNode = (Node)xpath.evaluate("/roms/rom/romid[xmlid='" + calId + "']", document, XPathConstants.NODE);
            romIdNode = romIdNode.getParentNode();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return romIdNode;
    }
}

