/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class EcuTableDefinitionHandler {
    private EcuTableDefinitionHandler() {
    }

    public static final Map<String, String> getTableDefinition(Document document, List<Node> inheritanceNodeList, String tableName) {
        HashMap<String, String> table = new HashMap<String, String>();
        for (Node inheritIdNode : inheritanceNodeList) {
            EcuTableDefinitionHandler.get2dTableMap(inheritIdNode, tableName, table);
        }
        return table;
    }

    private static final void get2dTableMap(Node node, String tableName, Map<String, String> tableMap2d) {
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        try {
            Node tableNode = (Node)xpath.evaluate("table[@name='" + tableName + "']", node, XPathConstants.NODE);
            EcuTableDefinitionHandler.addAttributesAsMap(tableNode, tableMap2d);
            Node scalingNode = (Node)xpath.evaluate("scaling", tableNode, XPathConstants.NODE);
            EcuTableDefinitionHandler.addAttributesAsMap(scalingNode, tableMap2d);
        }
        catch (NullPointerException tableNode) {
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private static final void addAttributesAsMap(Node node, Map<String, String> tableMap) {
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            tableMap.put(attrs.item(i).getNodeName(), attrs.item(i).getNodeValue());
        }
    }
}

