/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.profile;

import com.romraider.Settings;
import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.EcuParameter;
import com.romraider.logger.ecu.definition.EcuSwitch;
import com.romraider.logger.ecu.definition.ExternalData;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.exception.ConfigurationException;
import com.romraider.logger.ecu.profile.UserProfile;
import com.romraider.logger.ecu.profile.UserProfileItem;
import com.romraider.util.ParamChecker;
import com.romraider.util.SettingsManager;
import java.util.Map;

public final class UserProfileImpl
implements UserProfile {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final Map<String, UserProfileItem> params;
    private final Map<String, UserProfileItem> switches;
    private final Map<String, UserProfileItem> external;
    private final String protocol;

    public UserProfileImpl(Map<String, UserProfileItem> params, Map<String, UserProfileItem> switches, Map<String, UserProfileItem> external, String protocol) {
        ParamChecker.checkNotNull(params, "params");
        ParamChecker.checkNotNull(switches, "switches");
        ParamChecker.checkNotNull(external, "external");
        this.params = params;
        this.switches = switches;
        this.external = external;
        this.protocol = protocol;
    }

    @Override
    public boolean contains(LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        return this.getMap(loggerData).keySet().contains(loggerData.getId());
    }

    @Override
    public boolean isSelectedOnLiveDataTab(LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        return this.contains(loggerData) && this.getUserProfileItem(loggerData).isLiveDataSelected();
    }

    @Override
    public boolean isSelectedOnGraphTab(LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        return this.contains(loggerData) && this.getUserProfileItem(loggerData).isGraphSelected();
    }

    @Override
    public boolean isSelectedOnDashTab(LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        return this.contains(loggerData) && this.getUserProfileItem(loggerData).isDashSelected();
    }

    @Override
    public EcuDataConvertor getSelectedConvertor(LoggerData loggerData) {
        String defaultUnits;
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        if (this.contains(loggerData) && (defaultUnits = this.getUserProfileItem(loggerData).getUnits()) != null && loggerData.getConvertors().length > 1) {
            for (EcuDataConvertor convertor : loggerData.getConvertors()) {
                if (!defaultUnits.equals(convertor.getUnits())) continue;
                return convertor;
            }
            throw new ConfigurationException("Unknown default units, '" + defaultUnits + "', specified for [" + loggerData.getId() + "] " + loggerData.getName());
        }
        return loggerData.getSelectedConvertor();
    }

    @Override
    public byte[] getBytes() {
        return this.buildXml().getBytes();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    private String buildXml() {
        Settings settings = SettingsManager.getSettings();
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>").append(NEW_LINE);
        builder.append("<!DOCTYPE profile SYSTEM \"profile.dtd\">").append(NEW_LINE).append(NEW_LINE);
        builder.append("<profile protocol=\"").append(settings.getLoggerProtocol().toUpperCase()).append("\">").append(NEW_LINE);
        if (!this.params.isEmpty()) {
            builder.append("    <parameters>").append(NEW_LINE);
            this.appendLoggerDataElements(builder, "parameter", this.params, true);
            builder.append("    </parameters>").append(NEW_LINE);
        }
        if (!this.switches.isEmpty()) {
            builder.append("    <switches>").append(NEW_LINE);
            this.appendLoggerDataElements(builder, "switch", this.switches, false);
            builder.append("    </switches>").append(NEW_LINE);
        }
        if (!this.external.isEmpty()) {
            builder.append("    <externals>").append(NEW_LINE);
            this.appendLoggerDataElements(builder, "external", this.external, true);
            builder.append("    </externals>").append(NEW_LINE);
        }
        builder.append("</profile>").append(NEW_LINE);
        return builder.toString();
    }

    private void appendLoggerDataElements(StringBuilder builder, String dataType, Map<String, UserProfileItem> dataMap, boolean showUnits) {
        for (String id : dataMap.keySet()) {
            UserProfileItem item = dataMap.get(id);
            builder.append("        <").append(dataType).append(" id=\"").append(id).append("\"");
            if (item.isLiveDataSelected()) {
                builder.append(" livedata=\"selected\"");
            }
            if (item.isGraphSelected()) {
                builder.append(" graph=\"selected\"");
            }
            if (item.isDashSelected()) {
                builder.append(" dash=\"selected\"");
            }
            if (showUnits && !ParamChecker.isNullOrEmpty(item.getUnits())) {
                builder.append(" units=\"").append(item.getUnits()).append("\"");
            }
            builder.append("/>").append(NEW_LINE);
        }
    }

    private UserProfileItem getUserProfileItem(LoggerData loggerData) {
        return this.getMap(loggerData).get(loggerData.getId());
    }

    private Map<String, UserProfileItem> getMap(LoggerData loggerData) {
        if (loggerData instanceof EcuParameter) {
            return this.params;
        }
        if (loggerData instanceof EcuSwitch) {
            return this.switches;
        }
        if (loggerData instanceof ExternalData) {
            return this.external;
        }
        throw new UnsupportedOperationException("Unknown LoggerData type: " + loggerData.getClass());
    }
}

