/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.profile;

import com.romraider.logger.ecu.profile.UserProfile;
import com.romraider.logger.ecu.profile.UserProfileLoader;
import com.romraider.logger.ecu.profile.xml.UserProfileHandler;
import com.romraider.util.ParamChecker;
import com.romraider.util.SaxParserFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class UserProfileLoaderImpl
implements UserProfileLoader {
    private static final Logger LOGGER = Logger.getLogger(UserProfileLoaderImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile loadProfile(String userProfileFilePath) {
        UserProfile userProfile;
        ParamChecker.checkNotNullOrEmpty(userProfileFilePath, "userProfileFilePath");
        LOGGER.info("Loading profile: " + userProfileFilePath);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(new File(userProfileFilePath)));
        try {
            UserProfileHandler handler = new UserProfileHandler();
            SaxParserFactory.getSaxParser().parse((InputStream)inputStream, (DefaultHandler)handler);
            userProfile = handler.getUserProfile();
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (SAXParseException spe) {
                LOGGER.error("Error loading user profile file: " + userProfileFilePath + ".  Please make sure the definition file is correct.  If it is in a ZIP archive, unzip the file and try again.");
                return null;
            }
            catch (Exception e) {
                LOGGER.error("Error loading user profile file: " + userProfileFilePath, e);
                return null;
            }
        }
        ((InputStream)inputStream).close();
        return userProfile;
    }
}

