/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.profile.xml;

import com.romraider.logger.ecu.profile.UserProfile;
import com.romraider.logger.ecu.profile.UserProfileImpl;
import com.romraider.logger.ecu.profile.UserProfileItem;
import com.romraider.logger.ecu.profile.UserProfileItemImpl;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class UserProfileHandler
extends DefaultHandler {
    private static final String SELECTED = "selected";
    private static final String TAG_PROFILE = "profile";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_SWITCH = "switch";
    private static final String TAG_EXTERNAL = "external";
    private static final String ATTR_PROTOCOL = "protocol";
    private static final String ATTR_ID = "id";
    private static final String ATTR_UNITS = "units";
    private static final String ATTR_LIVE_DATA = "livedata";
    private static final String ATTR_GRAPH = "graph";
    private static final String ATTR_DASH = "dash";
    private Map<String, UserProfileItem> params;
    private Map<String, UserProfileItem> switches;
    private Map<String, UserProfileItem> external;
    private String protocol;

    @Override
    public void startDocument() {
        this.params = new HashMap<String, UserProfileItem>();
        this.switches = new HashMap<String, UserProfileItem>();
        this.external = new HashMap<String, UserProfileItem>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (TAG_PROFILE.equals(qName)) {
            this.protocol = attributes.getValue(ATTR_PROTOCOL);
        } else if (TAG_PARAMETER.equals(qName)) {
            this.params.put(attributes.getValue(ATTR_ID), this.getUserProfileItem(attributes));
        } else if (TAG_SWITCH.equals(qName)) {
            this.switches.put(attributes.getValue(ATTR_ID), this.getUserProfileItem(attributes));
        } else if (TAG_EXTERNAL.equals(qName)) {
            this.external.put(attributes.getValue(ATTR_ID), this.getUserProfileItem(attributes));
        }
    }

    public UserProfile getUserProfile() {
        return new UserProfileImpl(this.params, this.switches, this.external, this.protocol);
    }

    private UserProfileItem getUserProfileItem(Attributes attributes) {
        return new UserProfileItemImpl(attributes.getValue(ATTR_UNITS), SELECTED.equalsIgnoreCase(attributes.getValue(ATTR_LIVE_DATA)), SELECTED.equalsIgnoreCase(attributes.getValue(ATTR_GRAPH)), SELECTED.equalsIgnoreCase(attributes.getValue(ATTR_DASH)));
    }
}

