/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.table;

import com.romraider.logger.ecu.comms.query.Response;
import com.romraider.logger.ecu.comms.query.ResponseImpl;
import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.maps.Table;
import com.romraider.maps.Table2D;
import com.romraider.maps.Table3D;
import com.romraider.util.ParamChecker;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class TableUpdateHandler {
    private static final TableUpdateHandler INSTANCE = new TableUpdateHandler();
    private final Map<String, List<Table>> tableMap = Collections.synchronizedMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));

    private TableUpdateHandler() {
        this.tableMap.clear();
    }

    public void registerData(LoggerData loggerData) {
    }

    public void handleDataUpdate(Response response) {
        for (LoggerData loggerData : response.getData()) {
            List<Table> tables = this.tableMap.get(loggerData.getId());
            if (tables == null || tables.isEmpty()) continue;
            String formattedValue = loggerData.getSelectedConvertor().format(response.getDataValue(loggerData));
            for (Table table : tables) {
                table.clearLiveDataTrace();
                table.highlightLiveData(formattedValue);
            }
        }
    }

    public void deregisterData(LoggerData loggerData) {
    }

    public void cleanUp() {
    }

    public void reset() {
    }

    public void registerTable(Table table) {
        String logParam = table.getLogParam();
        if (!ParamChecker.isNullOrEmpty(logParam)) {
            if (!this.tableMap.containsKey(logParam)) {
                this.tableMap.put(logParam, new ArrayList());
            }
            this.tableMap.get(logParam).add(table);
        }
        this.registerAxes(table);
    }

    public void deregisterTable(Table table) {
        String logParam = table.getLogParam();
        if (this.tableMap.containsKey(logParam)) {
            List<Table> tables = this.tableMap.get(logParam);
            tables.remove(table);
            if (tables.isEmpty()) {
                this.tableMap.remove(logParam);
            }
        }
        this.deregisterAxes(table);
    }

    public static TableUpdateHandler getInstance() {
        return INSTANCE;
    }

    private void registerAxes(Table table) {
        if (table instanceof Table2D) {
            this.registerTable(((Table2D)table).getAxis());
        }
        if (table instanceof Table3D) {
            this.registerTable(((Table3D)table).getXAxis());
            this.registerTable(((Table3D)table).getYAxis());
        }
    }

    private void deregisterAxes(Table table) {
        if (table instanceof Table2D) {
            this.deregisterTable(((Table2D)table).getAxis());
        }
        if (table instanceof Table3D) {
            this.deregisterTable(((Table3D)table).getXAxis());
            this.deregisterTable(((Table3D)table).getYAxis());
        }
    }

    static {
        final EcuDataConvertor convertor = new EcuDataConvertor(){

            @Override
            public double convert(byte[] bytes) {
                return 0.0;
            }

            @Override
            public String format(double value) {
                return Double.toString(value);
            }

            @Override
            public String getUnits() {
                return null;
            }

            @Override
            public String getFormat() {
                return null;
            }

            @Override
            public String getExpression() {
                return null;
            }

            @Override
            public String getDataType() {
                return null;
            }
        };
        SensorCentral.getInstance().anySensorListener = new SensorCentral.SensorListener2(){

            @Override
            public void onSensorUpdate(final Sensor sensor, double value) {
                ResponseImpl r = new ResponseImpl();
                LoggerData d = new LoggerData(){

                    public String toString() {
                        return this.getName();
                    }

                    @Override
                    public String getId() {
                        return sensor.name();
                    }

                    @Override
                    public String getName() {
                        return sensor.getName();
                    }

                    @Override
                    public String getDescription() {
                        return sensor.getName();
                    }

                    @Override
                    public EcuDataConvertor getSelectedConvertor() {
                        return convertor;
                    }

                    @Override
                    public EcuDataConvertor[] getConvertors() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void selectConvertor(EcuDataConvertor convertor) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean isSelected() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void setSelected(boolean selected) {
                        throw new UnsupportedOperationException();
                    }
                };
                r.setDataValue(d, value);
                TableUpdateHandler.getInstance().handleDataUpdate(r);
            }
        };
    }
}

