/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.paramlist;

import com.romraider.logger.ecu.definition.EcuData;
import com.romraider.logger.ecu.definition.ExternalData;
import com.romraider.logger.ecu.ui.paramlist.ParameterListTableModel;
import com.romraider.logger.ecu.ui.paramlist.ParameterRow;
import com.romraider.logger.ecu.ui.paramlist.UnitsComboBoxEditor;
import com.romraider.logger.ecu.ui.paramlist.UnitsComboBoxRenderer;
import com.romraider.util.ParamChecker;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public final class ParameterListTable
extends JTable {
    private static final long serialVersionUID = -8489190548281346227L;
    private UnitsComboBoxEditor comboBoxEditor = new UnitsComboBoxEditor();
    private UnitsComboBoxRenderer comboBoxRenderer = new UnitsComboBoxRenderer();
    private final ParameterListTableModel tableModel;

    public ParameterListTable(ParameterListTableModel tableModel) {
        super(tableModel);
        this.tableModel = tableModel;
        this.getTableHeader().setReorderingAllowed(false);
        for (int column = 0; column < tableModel.getColumnCount(); ++column) {
            if (tableModel.getColumnName(2).equalsIgnoreCase("units")) {
                this.setColumnSortable(column, false);
                continue;
            }
            this.setColumnSortable(column, true);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        return this.displayComboBox(row, col) ? this.comboBoxRenderer : super.getCellRenderer(row, col);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        return this.displayComboBox(row, col) ? this.comboBoxEditor : super.getCellEditor(row, col);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String description;
        ParameterRow parameterRow;
        List<ParameterRow> parameterRows = this.tableModel.getParameterRows();
        if (!ParamChecker.isNullOrEmpty(parameterRows) && (parameterRow = parameterRows.get(this.rowAtPoint(mouseEvent.getPoint()))) != null && !ParamChecker.isNullOrEmpty(description = parameterRow.getLoggerData().getDescription())) {
            return description;
        }
        return super.getToolTipText(mouseEvent);
    }

    private boolean displayComboBox(int row, int col) {
        ExternalData externalData;
        EcuData ecuData;
        Object value = this.getValueAt(row, col);
        if (EcuData.class.isAssignableFrom(value.getClass()) && (ecuData = (EcuData)value).getConvertors().length > 1) {
            return true;
        }
        return ExternalData.class.isAssignableFrom(value.getClass()) && (externalData = (ExternalData)value).getConvertors().length > 1;
    }

    private void setColumnSortable(int column, boolean state) {
        TableRowSorter<ParameterListTableModel> sorter = new TableRowSorter<ParameterListTableModel>(this.tableModel);
        sorter.setSortable(column, state);
        this.setRowSorter(sorter);
    }
}

