/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.paramlist;

import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.DataRegistrationBroker;
import com.romraider.logger.ecu.ui.paramlist.ParameterRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public final class ParameterListTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -2556400867696538881L;
    private final String[] columnNames;
    private final List<LoggerData> registeredLoggerData = Collections.synchronizedList(new LinkedList());
    private final Map<LoggerData, ParameterRow> paramRowMap = Collections.synchronizedMap(new LinkedHashMap());
    private final DataRegistrationBroker broker;

    public ParameterListTableModel(DataRegistrationBroker broker, String dataType) {
        this.broker = broker;
        this.columnNames = new String[]{"Selected?", dataType, "Units"};
    }

    @Override
    public synchronized int getRowCount() {
        return this.paramRowMap.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 2;
    }

    @Override
    public synchronized Object getValueAt(int row, int col) {
        ParameterRow paramRow = this.paramRowMap.get(this.registeredLoggerData.get(row));
        switch (col) {
            case 0: {
                return paramRow.isSelected();
            }
            case 1: {
                return paramRow.getLoggerData().getName();
            }
            case 2: {
                LoggerData loggerData = paramRow.getLoggerData();
                return loggerData.getConvertors().length > 1 ? loggerData : loggerData.getSelectedConvertor().getUnits();
            }
        }
        return "Error!";
    }

    @Override
    public synchronized void setValueAt(Object value, int row, int col) {
        ParameterRow paramRow = this.paramRowMap.get(this.registeredLoggerData.get(row));
        if (col == 0 && paramRow != null) {
            Boolean selected = (Boolean)value;
            this.setSelected(paramRow, selected);
            this.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    public synchronized void addParam(LoggerData loggerData, boolean selected) {
        if (!this.registeredLoggerData.contains(loggerData)) {
            ParameterRow paramRow = new ParameterRow(loggerData);
            this.paramRowMap.put(loggerData, paramRow);
            this.registeredLoggerData.add(loggerData);
            this.setSelected(paramRow, selected);
            this.fireTableDataChanged();
        }
    }

    public synchronized void selectParam(LoggerData loggerData, boolean selected) {
        if (this.registeredLoggerData.contains(loggerData)) {
            this.setSelected(this.paramRowMap.get(loggerData), selected);
            this.fireTableDataChanged();
        }
    }

    public synchronized void clear() {
        this.broker.clear();
        this.paramRowMap.clear();
        this.registeredLoggerData.clear();
        try {
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<ParameterRow> getParameterRows() {
        return new ArrayList<ParameterRow>(this.paramRowMap.values());
    }

    private void setSelected(ParameterRow paramRow, boolean selected) {
        paramRow.setSelected(selected);
        if (selected) {
            this.broker.registerLoggerDataForLogging(paramRow.getLoggerData());
        } else {
            this.broker.deregisterLoggerDataFromLogging(paramRow.getLoggerData());
        }
    }
}

