/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.paramlist;

import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.LoggerData;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public final class UnitsComboBoxEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final long serialVersionUID = -3472910399604360821L;
    private static final String EDIT_COMMAND = "EDIT";
    private LoggerData currentEcuData;

    @Override
    public Object getCellEditorValue() {
        return this.currentEcuData.getSelectedConvertor();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object ecuData, boolean isSelected, int row, int column) {
        this.currentEcuData = (LoggerData)ecuData;
        EcuDataConvertor[] convertors = this.currentEcuData.getConvertors();
        JComboBox<EcuDataConvertor> comboBox = new JComboBox<EcuDataConvertor>();
        for (EcuDataConvertor convertor : convertors) {
            comboBox.addItem(convertor);
        }
        comboBox.setSelectedItem(this.currentEcuData.getSelectedConvertor());
        comboBox.setEditable(false);
        comboBox.setEnabled(true);
        comboBox.setActionCommand(EDIT_COMMAND);
        comboBox.addActionListener(this);
        return comboBox;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source;
        if (EDIT_COMMAND.equals(actionEvent.getActionCommand()) && (source = actionEvent.getSource()) != null && JComboBox.class.isAssignableFrom(source.getClass())) {
            JComboBox comboBox = (JComboBox)source;
            this.currentEcuData.selectConvertor((EcuDataConvertor)comboBox.getSelectedItem());
            this.fireEditingStopped();
        }
    }
}

