/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public final class BetterFlowLayout
extends FlowLayout {
    private static final long serialVersionUID = -6784712723817241270L;

    public BetterFlowLayout() {
    }

    public BetterFlowLayout(int align) {
        super(align);
    }

    public BetterFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.betterPreferredSize(target);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.betterPreferredSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension betterPreferredSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + this.getVgap();
            int rowh = 0;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += this.getHgap();
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                x = d.width;
                y += this.getVgap() + rowh;
                rowh = d.height;
            }
            return new Dimension(maxwidth, y + rowh + this.getVgap());
        }
    }
}

