/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.menubar.util;

import com.romraider.logger.ecu.profile.UserProfile;
import com.romraider.swing.GenericFileFilter;
import com.romraider.util.ParamChecker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;

public final class FileHelper {
    private static final String USER_HOME_DIR = System.getProperty("user.home");

    private FileHelper() {
        throw new UnsupportedOperationException();
    }

    public static File getFile(String filePath) {
        return ParamChecker.isNullOrEmpty(filePath) ? new File(USER_HOME_DIR) : new File(filePath);
    }

    public static JFileChooser getProfileFileChooser(File lastProfileFile) {
        return FileHelper.getFileChooser(lastProfileFile, "ECU Logger User Profiles", "xml");
    }

    public static JFileChooser getDefinitionFileChooser(File lastDefFile) {
        return FileHelper.getFileChooser(lastDefFile, "ECU Logger Definitions", "xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveProfileToFile(UserProfile profile, File destinationFile) throws IOException {
        String profileFilePath = destinationFile.getAbsolutePath();
        if (!profileFilePath.endsWith(".xml")) {
            profileFilePath = profileFilePath + ".xml";
            destinationFile = new File(profileFilePath);
        }
        try (FileOutputStream fos = new FileOutputStream(destinationFile);){
            fos.write(profile.getBytes());
        }
        return profileFilePath;
    }

    public static JFileChooser getLoggerOutputDirFileChooser(File lastLoggerOutputDir) {
        JFileChooser fc = lastLoggerOutputDir.exists() && lastLoggerOutputDir.isDirectory() ? new JFileChooser(lastLoggerOutputDir.getAbsolutePath()) : new JFileChooser();
        fc.setFileSelectionMode(1);
        return fc;
    }

    private static JFileChooser getFileChooser(File file, String description, String ... extensions) {
        JFileChooser fc = FileHelper.getFileChooser(file);
        fc.setFileFilter(new GenericFileFilter(description, extensions));
        return fc;
    }

    private static JFileChooser getFileChooser(File file) {
        if (file.exists() && file.isFile() && file.getParentFile() != null) {
            String dir = file.getParentFile().getAbsolutePath();
            JFileChooser fc = new JFileChooser(dir);
            fc.setSelectedFile(file);
            return fc;
        }
        return new JFileChooser();
    }
}

