/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.vertical;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public final class VerticalLabelUI
extends BasicLabelUI {
    private static Rectangle PAINT_ICON_R = new Rectangle();
    private static Rectangle PAINT_TEXT_R = new Rectangle();
    private static Rectangle PAINT_VIEW_R = new Rectangle();
    private static Insets PAINT_VIEW_INSETS = new Insets(0, 0, 0, 0);
    protected boolean clockwise;

    public VerticalLabelUI(boolean clockwise) {
        this.clockwise = clockwise;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        return new Dimension(dim.height, dim.width);
    }

    @Override
    public void paint(Graphics graphics, JComponent component) {
        Icon icon;
        JLabel label = (JLabel)component;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = graphics.getFontMetrics();
        PAINT_VIEW_INSETS = component.getInsets(PAINT_VIEW_INSETS);
        VerticalLabelUI.PAINT_VIEW_R.x = VerticalLabelUI.PAINT_VIEW_INSETS.left;
        VerticalLabelUI.PAINT_VIEW_R.y = VerticalLabelUI.PAINT_VIEW_INSETS.top;
        VerticalLabelUI.PAINT_VIEW_R.height = component.getWidth() - (VerticalLabelUI.PAINT_VIEW_INSETS.left + VerticalLabelUI.PAINT_VIEW_INSETS.right);
        VerticalLabelUI.PAINT_VIEW_R.width = component.getHeight() - (VerticalLabelUI.PAINT_VIEW_INSETS.top + VerticalLabelUI.PAINT_VIEW_INSETS.bottom);
        VerticalLabelUI.PAINT_ICON_R.height = 0;
        VerticalLabelUI.PAINT_ICON_R.width = 0;
        VerticalLabelUI.PAINT_ICON_R.y = 0;
        VerticalLabelUI.PAINT_ICON_R.x = 0;
        VerticalLabelUI.PAINT_TEXT_R.height = 0;
        VerticalLabelUI.PAINT_TEXT_R.width = 0;
        VerticalLabelUI.PAINT_TEXT_R.y = 0;
        VerticalLabelUI.PAINT_TEXT_R.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, PAINT_VIEW_R, PAINT_ICON_R, PAINT_TEXT_R);
        int textWidth = fm.stringWidth(clippedText);
        Graphics2D g2 = (Graphics2D)graphics;
        AffineTransform tr = g2.getTransform();
        if (this.clockwise) {
            g2.rotate(1.5707963267948966);
            g2.translate(component.getHeight() / 2 - textWidth / 2, -component.getWidth());
        } else {
            g2.rotate(-1.5707963267948966);
            g2.translate(-component.getHeight() / 2 - textWidth / 2, 0);
        }
        if (icon != null) {
            icon.paintIcon(component, graphics, VerticalLabelUI.PAINT_ICON_R.x, VerticalLabelUI.PAINT_ICON_R.y);
        }
        if (text != null) {
            int textX = VerticalLabelUI.PAINT_TEXT_R.x;
            int textY = VerticalLabelUI.PAINT_TEXT_R.y + fm.getAscent();
            if (label.isEnabled()) {
                this.paintEnabledText(label, graphics, clippedText, textX, textY);
            } else {
                this.paintDisabledText(label, graphics, clippedText, textX, textY);
            }
        }
        g2.setTransform(tr);
    }

    static {
        labelUI = new VerticalLabelUI(false);
    }
}

