/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.maps.Table3D;
import com.rusefi.Launcher;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

class CopySelection3DWorker
extends SwingWorker<Void, Void> {
    Table3D table;

    public CopySelection3DWorker(Table3D table) {
        this.table = table;
    }

    @Override
    protected Void doInBackground() throws Exception {
        boolean copy = false;
        int[] coords = new int[4];
        coords[0] = this.table.getSizeX();
        coords[1] = this.table.getSizeY();
        for (int x = 0; x < this.table.getSizeX(); ++x) {
            for (int y = 0; y < this.table.getSizeY(); ++y) {
                if (!this.table.get3dData()[x][y].isSelected().booleanValue()) continue;
                if (x < coords[0]) {
                    coords[0] = x;
                    copy = true;
                }
                if (x > coords[2]) {
                    coords[2] = x;
                    copy = true;
                }
                if (y < coords[1]) {
                    coords[1] = y;
                    copy = true;
                }
                if (y <= coords[3]) continue;
                coords[3] = y;
                copy = true;
            }
        }
        if (copy) {
            String newline = System.getProperty("line.separator");
            StringBuffer output = new StringBuffer("[Selection3D]" + newline);
            for (int y = coords[1]; y <= coords[3]; ++y) {
                for (int x = coords[0]; x <= coords[2]; ++x) {
                    if (this.table.get3dData()[x][y].isSelected().booleanValue()) {
                        output.append(this.table.get3dData()[x][y].getText());
                    } else {
                        output.append("x");
                    }
                    if (x >= coords[2]) continue;
                    output.append("\t");
                }
                if (y < coords[3]) {
                    output.append(newline);
                }
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(String.valueOf(output)), null);
            }
        } else {
            this.table.getXAxis().copySelection();
            this.table.getYAxis().copySelection();
        }
        return null;
    }

    @Override
    public void done() {
        Window ancestorWindow = SwingUtilities.getWindowAncestor(this.table);
        if (null != ancestorWindow) {
            ancestorWindow.setCursor(null);
        }
        this.table.setCursor(null);
        Launcher.getFrame().setCursor(null);
    }
}

