/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.maps.Table;
import com.rusefi.Launcher;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

class CopySelectionWorker
extends SwingWorker<Void, Void> {
    Table table;

    public CopySelectionWorker(Table table) {
        this.table = table;
    }

    @Override
    protected Void doInBackground() throws Exception {
        int i;
        String newline = System.getProperty("line.separator");
        String output = "[Selection1D]" + newline;
        boolean copy = false;
        int[] coords = new int[2];
        coords[0] = this.table.getDataSize();
        for (i = 0; i < this.table.getDataSize(); ++i) {
            if (!this.table.getData()[i].isSelected().booleanValue()) continue;
            if (i < coords[0]) {
                coords[0] = i;
                copy = true;
            }
            if (i <= coords[1]) continue;
            coords[1] = i;
            copy = true;
        }
        for (i = coords[0]; i <= coords[1]; ++i) {
            output = this.table.getData()[i].isSelected() != false ? output + this.table.getData()[i].getText() : output + "x";
            if (i >= coords[1]) continue;
            output = output + "\t";
        }
        if (copy) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(output), null);
        }
        return null;
    }

    @Override
    public void done() {
        Window ancestorWindow = SwingUtilities.getWindowAncestor(this.table);
        if (null != ancestorWindow) {
            ancestorWindow.setCursor(null);
        }
        this.table.setCursor(null);
        Launcher.getFrame().setCursor(null);
    }
}

