/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.Settings;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.maps.Table;
import com.romraider.maps.Table1D;
import com.romraider.util.ColorScaler;
import com.romraider.util.JEPUtil;
import com.romraider.util.ParamChecker;
import com.romraider.util.SettingsManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class DataCell
extends JLabel
implements MouseListener,
Serializable {
    private static final long serialVersionUID = -2904293227148940937L;
    private static final Logger LOGGER = Logger.getLogger(DataCell.class);
    private final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#,##0.0%");
    private final Font defaultFont = new Font("Arial", 1, 12);
    private static final int unSelectMask1 = 1664;
    private static final int unSelectMask2 = 4736;
    private final Table table;
    private Boolean selected = false;
    private Boolean highlighted = false;
    private Boolean traced = false;
    private int x = 0;
    private int y = 0;
    private double binValue = 0.0;
    private double originalValue = 0.0;
    private double compareToValue = 0.0;
    private String liveValue = "";
    private final Color defaultBorderColor = new Color(0, 0, 0);
    private final Color increaseBorderColor = this.getSettings().getIncreaseBorder();
    private final Color decreaseBorderColor = this.getSettings().getDecreaseBorder();
    private String staticText = null;

    public DataCell(Table table) {
        this.table = table;
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setFont(this.defaultFont);
        this.setOpaque(true);
        this.setVisible(true);
        this.addMouseListener(this);
    }

    public DataCell(Table table, String staticText) {
        this(table);
        this.staticText = staticText;
        table.setStaticDataTable(true);
    }

    public DataCell(Table table, double originalValue, int x, int y) {
        this(table);
        this.originalValue = originalValue;
        this.binValue = originalValue;
        this.x = x;
        this.y = y;
        this.setPreferredSize(this.getSettings().getCellSize());
    }

    public double getBinValue() {
        return this.binValue;
    }

    public double getRealValue() {
        return JEPUtil.evaluate(this.table.getCurrentScale().getExpression(), this.binValue);
    }

    public void setRealValue(String input) {
        try {
            double result = 0.0;
            if (!"x".equalsIgnoreCase(input)) {
                result = JEPUtil.evaluate(this.table.getCurrentScale().getByteExpression(), Double.parseDouble(input));
                if (this.table.getStorageType() != 99) {
                    result = (int)Math.round(result);
                }
                if (this.binValue != result) {
                    this.setBinValue(result);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public double getCompareValue() {
        return this.binValue - this.compareToValue;
    }

    public double getRealCompareValue() {
        return JEPUtil.evaluate(this.table.getCurrentScale().getExpression(), this.binValue) - JEPUtil.evaluate(this.table.getCurrentScale().getExpression(), this.compareToValue);
    }

    public double getRealCompareChangeValue() {
        double realBinValue = JEPUtil.evaluate(this.table.getCurrentScale().getExpression(), this.binValue);
        double realCompareValue = JEPUtil.evaluate(this.table.getCurrentScale().getExpression(), this.compareToValue);
        if (realCompareValue != 0.0) {
            return (realBinValue - realCompareValue) / Math.abs(realCompareValue);
        }
        return realBinValue - realCompareValue;
    }

    public Color getCompareColor() {
        Table1D checkTable;
        if (this.table instanceof Table1D && (checkTable = (Table1D)this.table).isAxis() && !this.getSettings().isColorAxis()) {
            return this.getSettings().getAxisColor();
        }
        if (0.0 == this.getCompareValue()) {
            return Settings.UNCHANGED_VALUE_COLOR;
        }
        if (this.table.getMinCompare() == this.table.getMaxCompare()) {
            return this.getSettings().getMaxColor();
        }
        double compareScale = (this.getCompareValue() - this.table.getMinCompare()) / (this.table.getMaxCompare() - this.table.getMinCompare());
        return ColorScaler.getScaledColor(compareScale);
    }

    public Color getBinColor() {
        Table1D checkTable;
        if (this.table instanceof Table1D && (checkTable = (Table1D)this.table).isAxis() && !this.getSettings().isColorAxis()) {
            return this.getSettings().getAxisColor();
        }
        if (this.table.getMaxAllowedBin() < this.getBinValue()) {
            return this.getSettings().getWarningColor();
        }
        if (this.table.getMinAllowedBin() > this.getBinValue()) {
            return this.getSettings().getWarningColor();
        }
        double colorScale = this.table.getMaxBin() - this.table.getMinBin() == 0.0 ? 0.5 : (this.getBinValue() - this.table.getMinBin()) / (this.table.getMaxBin() - this.table.getMinBin());
        return ColorScaler.getScaledColor(colorScale);
    }

    public void drawCell() {
        if (this.table == null) {
            return;
        }
        this.invalidate();
        this.setFont(this.getSettings().getTableFont());
        this.setText(this.getCellText());
        this.setToolTipText(this.getCellToolTip());
        this.setBackground(this.getCellBackgroundColor());
        this.setForeground(this.getCellTextColor());
        this.setBorder(this.getCellBorder());
        this.validate();
        this.table.validate();
        this.table.repaint();
    }

    private Color getCellBackgroundColor() {
        Settings settings = this.getSettings();
        Color backgroundColor = this.highlighted != false ? settings.getHighlightColor() : (this.selected != false ? settings.getSelectColor() : (null == this.table.getCompareTable() ? this.getBinColor() : this.getCompareColor()));
        return backgroundColor;
    }

    private Color getCellTextColor() {
        Color textColor = this.traced.booleanValue() ? (!this.getLiveValue().isEmpty() ? (this.table instanceof Table1D ? Settings.scaleTextColor : Settings.liveDataTraceTextColor) : Settings.scaleTextColor) : (this.highlighted != false ? Settings.highlightTextColor : (this.selected != false ? Settings.selectTextColor : Settings.scaleTextColor));
        return textColor;
    }

    private Border getCellBorder() {
        double checkValue;
        Border border = this.traced != false ? BorderFactory.createLineBorder(this.getSettings().getliveValueColor(), 2) : ((checkValue = null == this.table.getCompareTable() ? this.originalValue : this.compareToValue) < this.binValue ? BorderFactory.createLineBorder(this.increaseBorderColor, 2) : (checkValue > this.binValue ? BorderFactory.createLineBorder(this.decreaseBorderColor, 2) : BorderFactory.createLineBorder(this.defaultBorderColor, 1)));
        return border;
    }

    private String getCellText() {
        if (this.table.isStaticDataTable()) {
            return this.getStaticText();
        }
        DecimalFormat formatter = new DecimalFormat(this.table.getCurrentScale().getFormat());
        String displayString = "";
        if (null == this.table.getCompareTable()) {
            displayString = formatter.format(this.getRealValue());
        } else if (this.table.getCompareDisplay() == 2) {
            displayString = formatter.format(this.getRealCompareValue());
        } else if (this.table.getCompareDisplay() == 1) {
            displayString = this.getCompareValue() == 0.0 ? this.PERCENT_FORMAT.format(0.0) : this.PERCENT_FORMAT.format(this.getRealCompareChangeValue());
        }
        if (this.traced.booleanValue() && !(this.table instanceof Table1D)) {
            displayString = this.getLiveValueString(displayString);
        }
        return displayString;
    }

    private String getCellToolTip() {
        if (this.table.isStaticDataTable()) {
            return this.getStaticText();
        }
        return Double.toString(this.getRealValue());
    }

    private String getLiveValue() {
        return this.liveValue;
    }

    private String getLiveValueString(String currentValue) {
        return currentValue + (ParamChecker.isNullOrEmpty(this.getLiveValue()) ? "" : ':' + this.getLiveValue());
    }

    public void setBinValue(double newBinValue) {
        if (this.binValue == newBinValue) {
            return;
        }
        double checkedValue = newBinValue;
        if (checkedValue < this.table.getMinAllowedBin()) {
            checkedValue = this.table.getMinAllowedBin();
        }
        if (checkedValue > this.table.getMaxAllowedBin()) {
            checkedValue = this.table.getMaxAllowedBin();
        }
        if (this.binValue == checkedValue) {
            return;
        }
        this.binValue = checkedValue;
        this.drawCell();
    }

    @Override
    public String toString() {
        return this.getCellText();
    }

    public Boolean isSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        if (!this.table.isStaticDataTable() && this.selected != selected) {
            this.selected = selected;
            this.drawCell();
        }
    }

    public void setHighlighted(Boolean highlighted) {
        if (!this.table.isStaticDataTable() && this.highlighted != highlighted) {
            this.highlighted = highlighted;
            this.drawCell();
        }
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (1664 == (e.getModifiersEx() & 0x680)) {
            this.clearCell();
        } else if (4736 == (e.getModifiersEx() & 0x1280)) {
            this.clearCell();
        } else {
            this.table.highlight(this.x, this.y);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.isControlDown()) {
            this.table.clearSelection();
        }
        if (e.isControlDown() && e.isAltDown()) {
            this.clearCell();
        } else {
            this.table.startHighlight(this.x, this.y);
        }
        this.requestFocus();
        ECUEditorManager.getECUEditor().getTableToolBar().updateTableToolBar(this.table);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.table.stopHighlight();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void clearCell() {
        if (this.isHighlighted()) {
            this.setHighlighted(false);
        }
        if (this.isSelected().booleanValue()) {
            this.setSelected(false);
        }
    }

    public void increment(double increment) {
        double oldValue = this.getRealValue();
        if (this.table.getCurrentScale().getCoarseIncrement() < 0.0) {
            increment = 0.0 - increment;
        }
        double incResult = JEPUtil.evaluate(this.table.getCurrentScale().getByteExpression(), oldValue + increment);
        if (this.table.getStorageType() == 99) {
            if (this.binValue != incResult) {
                this.setBinValue(incResult);
            }
        } else {
            int roundResult = (int)Math.round(incResult);
            if (this.binValue != (double)roundResult) {
                this.setBinValue(roundResult);
            }
        }
        int maxValue = (int)Math.pow(8.0, this.table.getStorageType());
        if (this.table.getStorageType() != 99 && oldValue == this.getRealValue() && this.binValue > 0.0 && this.binValue < (double)maxValue) {
            LOGGER.debug(maxValue + " " + this.binValue);
            this.increment(increment * 2.0);
        }
    }

    public void undo() {
        this.setBinValue(this.originalValue);
    }

    public void setRevertPoint() {
        this.setOriginalValue(this.binValue);
        this.drawCell();
    }

    public void setOriginalValue(double originalValue) {
        this.originalValue = originalValue;
    }

    public void setCompareValue(DataCell compareCell) {
        if (1 == this.table.getCompareValueType()) {
            if (this.compareToValue == compareCell.binValue) {
                return;
            }
            this.compareToValue = compareCell.binValue;
        } else {
            if (this.compareToValue == compareCell.originalValue) {
                return;
            }
            this.compareToValue = compareCell.originalValue;
        }
    }

    public void multiply(double factor) {
        this.setBinValue(this.binValue * factor);
    }

    public void setLiveDataTrace(boolean trace) {
        if (this.traced != trace) {
            this.traced = trace;
            this.drawCell();
        }
    }

    public void setLiveDataTraceValue(String liveValue) {
        if (this.liveValue != liveValue) {
            this.liveValue = liveValue;
            this.drawCell();
        }
    }

    private Settings getSettings() {
        return SettingsManager.getSettings();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof DataCell)) {
            return false;
        }
        DataCell otherCell = (DataCell)other;
        if (this.table.isStaticDataTable() != otherCell.table.isStaticDataTable()) {
            return false;
        }
        return this.binValue == otherCell.binValue;
    }

    public String getStaticText() {
        String displayString = null;
        try {
            DecimalFormat formatter = new DecimalFormat(this.table.getCurrentScale().getFormat());
            double staticDouble = Double.parseDouble(this.staticText);
            displayString = formatter.format(JEPUtil.evaluate(this.table.getCurrentScale().getExpression(), staticDouble));
        }
        catch (Exception ex) {
            displayString = this.staticText;
        }
        return displayString;
    }

    public void setY(int y) {
        this.y = y;
    }
}

