/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.Settings;
import com.romraider.logger.ecu.ui.handler.table.TableUpdateHandler;
import com.romraider.maps.RomID;
import com.romraider.maps.Table;
import com.romraider.swing.CategoryTreeNode;
import com.romraider.swing.JProgressPane;
import com.romraider.swing.TableFrame;
import com.romraider.swing.TableTreeNode;
import com.romraider.util.HexUtil;
import com.romraider.util.SettingsManager;
import com.romraider.xml.InvalidTableNameException;
import com.romraider.xml.TableNotFoundException;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class Rom
extends DefaultMutableTreeNode
implements Serializable {
    private static final long serialVersionUID = 7865405179738828128L;
    private static final Logger LOGGER = Logger.getLogger(Rom.class);
    private RomID romID = new RomID();
    private String fileName = "";
    private final Vector<TableTreeNode> tableNodes = new Vector();
    private byte[] binData;
    private boolean isAbstract = false;

    public Rom() {
        this.tableNodes.clear();
    }

    public void refreshDisplayedTables() {
        super.removeAllChildren();
        Settings settings = SettingsManager.getSettings();
        for (TableTreeNode tableTreeNode : this.tableNodes) {
            TableFrame tableFrame = tableTreeNode.getFrame();
            Table table = tableFrame.getTable();
            if (!settings.isDisplayHighTables() && settings.getUserLevel() < table.getUserLevel()) continue;
            boolean categoryExists = false;
            for (int j = 0; j < this.getChildCount(); ++j) {
                if (!this.getChildAt(j).toString().equals(table.getCategory())) continue;
                this.getChildAt(j).add(tableTreeNode);
                categoryExists = true;
                break;
            }
            if (categoryExists) continue;
            CategoryTreeNode categoryNode = new CategoryTreeNode(table.getCategory());
            categoryNode.add(tableTreeNode);
            this.add(categoryNode);
        }
    }

    public void addTable(Table table) {
        boolean found = false;
        String frameTitle = this.getFileName() + " - " + table.getName();
        for (int i = 0; i < this.tableNodes.size(); ++i) {
            if (!this.tableNodes.get(i).getTable().equals(table)) continue;
            this.tableNodes.remove(i);
            this.tableNodes.add(i, new TableTreeNode(new TableFrame(frameTitle, table)));
            found = true;
            break;
        }
        if (!found) {
            this.tableNodes.add(new TableTreeNode(new TableFrame(frameTitle, table)));
        }
    }

    public void removeTable(Table table) {
        for (int i = 0; i < this.tableNodes.size(); ++i) {
            if (!this.tableNodes.get(i).getTable().equals(table)) continue;
            this.tableNodes.remove(i);
            return;
        }
    }

    public Table getTableByName(String tableName) throws TableNotFoundException, InvalidTableNameException {
        if (null == tableName || tableName.isEmpty()) {
            throw new InvalidTableNameException();
        }
        for (TableTreeNode tableNode : this.tableNodes) {
            if (!tableNode.getTable().getName().equalsIgnoreCase(tableName)) continue;
            return tableNode.getTable();
        }
        throw new TableNotFoundException();
    }

    public List<Table> findTables(String regex) {
        ArrayList<Table> result = new ArrayList<Table>();
        for (TableTreeNode tableNode : this.tableNodes) {
            String name = tableNode.getTable().getName();
            if (!name.matches(regex)) continue;
            result.add(tableNode.getTable());
        }
        return result;
    }

    public void populateTables(byte[] binData, JProgressPane progress) {
        this.binData = binData;
        for (int i = 0; i < this.tableNodes.size(); ++i) {
            int currProgress = (int)((double)i / (double)this.tableNodes.size() * 40.0);
            progress.update("Populating tables...", 50 + currProgress);
            Table table = this.tableNodes.get(i).getTable();
            if (table.getStorageAddress() != 0) {
                table.populateTable(binData, this.getRomID().getRamOffset());
                TableUpdateHandler.getInstance().registerTable(table);
                if (null == table.getName() || !table.getName().equalsIgnoreCase("Checksum Fix")) continue;
                this.setEditStamp(binData, table.getStorageAddress());
                continue;
            }
            this.tableNodes.removeElementAt(i);
            --i;
        }
    }

    private void setEditStamp(byte[] binData, int address) {
        byte[] stampData = new byte[4];
        System.arraycopy(binData, address + 204, stampData, 0, stampData.length);
        String stamp = HexUtil.asHex(stampData);
        if (stamp.equalsIgnoreCase("FFFFFFFF")) {
            this.romID.setEditStamp("");
        } else {
            StringBuilder niceStamp = new StringBuilder(stamp);
            niceStamp.replace(6, 9, String.valueOf(0xFF & stampData[3]));
            niceStamp.insert(6, " v");
            niceStamp.insert(4, "-");
            niceStamp.insert(2, "-");
            niceStamp.insert(0, "20");
            this.romID.setEditStamp(niceStamp.toString());
        }
    }

    public void setRomID(RomID romID) {
        this.romID = romID;
    }

    public RomID getRomID() {
        return this.romID;
    }

    public String getRomIDString() {
        return this.romID.getXmlid();
    }

    @Override
    public String toString() {
        String output = "";
        output = output + "\n---- Rom ----" + this.romID.toString();
        for (TableTreeNode tableNode : this.tableNodes) {
            output = output + tableNode.getTable();
        }
        output = output + "\n---- End Rom ----";
        return output;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Vector<Table> getTables() {
        Vector<Table> tables = new Vector<Table>();
        for (TableTreeNode tableNode : this.tableNodes) {
            tables.add(tableNode.getTable());
        }
        return tables;
    }

    public Vector<TableTreeNode> getTableNodes() {
        return this.tableNodes;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] saveFile() {
        for (TableTreeNode tableNode : this.tableNodes) {
            tableNode.getTable().saveFile(this.binData);
        }
        return this.binData;
    }

    public void clearData() {
        super.removeAllChildren();
        for (TableTreeNode tableTreeNode : this.tableNodes) {
            TableFrame frame = tableTreeNode.getFrame();
            frame.setVisible(false);
            try {
                frame.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            frame.dispose();
        }
        this.tableNodes.clear();
        this.binData = null;
    }

    public int getRealFileSize() {
        return this.binData.length;
    }

    public void setFullFileName(String fileName) {
        this.setFileName(fileName);
        for (TableTreeNode tableNode : this.tableNodes) {
            String frameTitle = this.getFileName() + " - " + tableNode.getTable().getName();
            tableNode.getFrame().setTitle(frameTitle);
        }
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void refreshTableCompareMenus() {
        for (TableTreeNode tableNode : this.getTableNodes()) {
            tableNode.getFrame().refreshSimilarOpenTables();
        }
    }

    @Override
    public DefaultMutableTreeNode getChildAt(int i) {
        return (DefaultMutableTreeNode)super.getChildAt(i);
    }

    @Override
    public DefaultMutableTreeNode getLastChild() {
        return (DefaultMutableTreeNode)super.getLastChild();
    }
}

