/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.xml.RomAttributeParser;

public class RomChecksum {
    public static void calculateRomChecksum(byte[] input, int storageAddress, int dataSize) {
        for (int i = storageAddress; i < storageAddress + dataSize; i += 12) {
            byte[] newSum = RomChecksum.calculateChecksum(input, (int)RomAttributeParser.parseByteValue(input, 0, i, 4, true), (int)RomAttributeParser.parseByteValue(input, 0, i + 4, 4, true));
            System.arraycopy(newSum, 0, input, i + 8, 4);
        }
    }

    public static int validateRomChecksum(byte[] input, int storageAddress, int dataSize) {
        int result = 0;
        int[] results = new int[dataSize / 12];
        int j = 0;
        for (int i = storageAddress; i < storageAddress + dataSize; i += 12) {
            int startAddr = (int)RomAttributeParser.parseByteValue(input, 0, i, 4, true);
            int endAddr = (int)RomAttributeParser.parseByteValue(input, 0, i + 4, 4, true);
            int diff = (int)RomAttributeParser.parseByteValue(input, 0, i + 8, 4, true);
            if (j == 0 && startAddr == 0 && endAddr == 0 && diff == 0x5AA5A55A) {
                result = -1;
                return -1;
            }
            results[j] = RomChecksum.validateChecksum(input, startAddr, endAddr, diff);
            ++j;
        }
        for (j = 0; j < dataSize / 12; ++j) {
            if (results[j] == 0) continue;
            return j + 1;
        }
        return result;
    }

    private static int validateChecksum(byte[] input, int startAddr, int endAddr, int diff) {
        int byteSum = 0;
        for (int i = startAddr; i < endAddr; i += 4) {
            byteSum += (int)RomAttributeParser.parseByteValue(input, 0, i, 4, true);
        }
        int result = 0x5AA5A55A - diff - byteSum;
        return result;
    }

    private static byte[] calculateChecksum(byte[] input, int startAddr, int endAddr) {
        int byteSum = 0;
        for (int i = startAddr; i < endAddr; i += 4) {
            byteSum += (int)RomAttributeParser.parseByteValue(input, 0, i, 4, true);
        }
        return RomAttributeParser.parseIntegerValue(0x5AA5A55A - byteSum, 0, 4);
    }
}

