/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import java.io.Serializable;

public class Scale
implements Serializable {
    private static final long serialVersionUID = 5836610685159474795L;
    private String name = "Raw Value";
    private String unit = "0x";
    private String expression = "x";
    private String byteExpression = "x";
    private String format = "#.##";
    private double coarseIncrement = 2.0;
    private double fineIncrement = 1.0;
    private double min = 0.0;
    private double max = 0.0;

    public String toString() {
        return "\n      ---- Scale ----\n      Name: " + this.getName() + "\n      Expression: " + this.getExpression() + "\n      Byte Expression: " + this.getByteExpression() + "\n      Unit: " + this.getUnit() + "\n      Format: " + this.getFormat() + "\n      Coarse Increment: " + this.getCoarseIncrement() + "\n      Fine Increment: " + this.getFineIncrement() + "\n      Min: " + this.getMin() + "\n      Max: " + this.getMax() + "\n      ---- End Scale ----\n";
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public double getCoarseIncrement() {
        return this.coarseIncrement;
    }

    public void setCoarseIncrement(double increment) {
        this.coarseIncrement = increment;
    }

    public boolean isReady() {
        if (this.unit == null) {
            return false;
        }
        if (this.expression == null) {
            return false;
        }
        if (this.format == null) {
            return false;
        }
        return !(this.coarseIncrement < 1.0);
    }

    public String getByteExpression() {
        return this.byteExpression;
    }

    public void setByteExpression(String byteExpression) {
        this.byteExpression = byteExpression;
    }

    public double getFineIncrement() {
        return this.fineIncrement;
    }

    public void setFineIncrement(double fineIncrement) {
        this.fineIncrement = fineIncrement;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public boolean equals(Object other) {
        try {
            if (null == other) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof Scale)) {
                return false;
            }
            Scale otherScale = (Scale)other;
            if (!(null == this.getName() && null == otherScale.getName() || this.getName().isEmpty() && otherScale.getName().isEmpty() || this.getName().equalsIgnoreCase(otherScale.getName()))) {
                return false;
            }
            if (!this.getUnit().equals(otherScale.getUnit())) {
                return false;
            }
            if (!this.getExpression().equals(otherScale.getExpression())) {
                return false;
            }
            if (!this.getByteExpression().equals(otherScale.getByteExpression())) {
                return false;
            }
            if (!this.getFormat().equals(otherScale.getFormat())) {
                return false;
            }
            if (this.getCoarseIncrement() != otherScale.getCoarseIncrement()) {
                return false;
            }
            if (this.getFineIncrement() != otherScale.getFineIncrement()) {
                return false;
            }
            if (this.getMin() != otherScale.getMin()) {
                return false;
            }
            return this.getMax() == otherScale.getMax();
        }
        catch (Exception ex) {
            return false;
        }
    }
}

