/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.Settings;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.maps.CopySelectionWorker;
import com.romraider.maps.CopyTableWorker;
import com.romraider.maps.DataCell;
import com.romraider.maps.Scale;
import com.romraider.swing.TableToolBar;
import com.romraider.util.JEPUtil;
import com.romraider.util.SettingsManager;
import com.rusefi.Launcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class Table
extends JPanel
implements Serializable {
    private static final long serialVersionUID = 6559256489995552645L;
    protected String name;
    protected int type;
    protected String category = "Other";
    protected String description = "";
    protected Vector<Scale> scales = new Vector();
    protected Scale curScale;
    protected int storageAddress;
    protected int storageType;
    protected boolean signed;
    protected int endian;
    protected boolean flip;
    protected DataCell[] data = new DataCell[0];
    protected boolean beforeRam = false;
    protected int ramOffset = 0;
    protected BorderLayout borderLayout = new BorderLayout();
    protected GridLayout centerLayout = new GridLayout(1, 1, 0, 0);
    protected JPanel centerPanel = new JPanel(this.centerLayout);
    protected JLabel tableLabel;
    protected int verticalOverhead = 103;
    protected int horizontalOverhead = 2;
    protected int cellHeight = (int)this.getSettings().getCellSize().getHeight();
    protected int cellWidth = (int)this.getSettings().getCellSize().getWidth();
    protected int minHeight = 100;
    protected int minWidthNoOverlay = 465;
    protected int minWidthOverlay = 700;
    protected int highlightX;
    protected int highlightY;
    protected boolean highlight = false;
    protected int userLevel = 0;
    protected boolean locked = false;
    protected String logParam = "";
    protected boolean overlayLog = true;
    protected CopyTableWorker copyTableWorker;
    protected CopySelectionWorker copySelectionWorker;
    protected double minAllowedBin = 0.0;
    protected double maxAllowedBin = 0.0;
    protected double maxBin;
    protected double minBin;
    protected double maxCompare = 0.0;
    protected double minCompare = 0.0;
    protected int compareDisplay = 2;
    protected int compareValueType = 1;
    protected boolean staticDataTable = false;
    protected String liveAxisValue = "";
    protected int liveDataIndex = 0;
    private Table compareTable = null;

    protected Table() {
        this.scales.clear();
        this.scales.add(new Scale());
        this.setLayout(this.borderLayout);
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.setVisible(true);
        AbstractAction rightAction = new AbstractAction(){
            private static final long serialVersionUID = 1042884198300385041L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.cursorRight();
            }
        };
        AbstractAction leftAction = new AbstractAction(){
            private static final long serialVersionUID = -4970441255677214171L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.cursorLeft();
            }
        };
        AbstractAction downAction = new AbstractAction(){
            private static final long serialVersionUID = -7898502951121825984L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.cursorDown();
            }
        };
        AbstractAction upAction = new AbstractAction(){
            private static final long serialVersionUID = 6937621541727666631L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.cursorUp();
            }
        };
        AbstractAction incCoarseAction = new AbstractAction(){
            private static final long serialVersionUID = -8308522736529183148L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().incrementCoarse();
            }
        };
        AbstractAction decCoarseAction = new AbstractAction(){
            private static final long serialVersionUID = -7407628920997400915L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().decrementCoarse();
            }
        };
        AbstractAction incFineAction = new AbstractAction(){
            private static final long serialVersionUID = 7261463425941761433L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().incrementFine();
            }
        };
        AbstractAction decFineAction = new AbstractAction(){
            private static final long serialVersionUID = 8929400237520608035L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().decrementFine();
            }
        };
        AbstractAction num0Action = new AbstractAction(){
            private static final long serialVersionUID = -6310984176739090034L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('0');
            }
        };
        AbstractAction num1Action = new AbstractAction(){
            private static final long serialVersionUID = -6187220355403883499L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('1');
            }
        };
        AbstractAction num2Action = new AbstractAction(){
            private static final long serialVersionUID = -8745505977907325720L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('2');
            }
        };
        AbstractAction num3Action = new AbstractAction(){
            private static final long serialVersionUID = 4694872385823448942L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('3');
            }
        };
        AbstractAction num4Action = new AbstractAction(){
            private static final long serialVersionUID = 4005741329254221678L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('4');
            }
        };
        AbstractAction num5Action = new AbstractAction(){
            private static final long serialVersionUID = -5846094949106279884L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('5');
            }
        };
        AbstractAction num6Action = new AbstractAction(){
            private static final long serialVersionUID = -5338656374925334150L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('6');
            }
        };
        AbstractAction num7Action = new AbstractAction(){
            private static final long serialVersionUID = 1959983381590509303L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('7');
            }
        };
        AbstractAction num8Action = new AbstractAction(){
            private static final long serialVersionUID = 7442763278699460648L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('8');
            }
        };
        AbstractAction num9Action = new AbstractAction(){
            private static final long serialVersionUID = 7475171864584215094L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('9');
            }
        };
        AbstractAction numPointAction = new AbstractAction(){
            private static final long serialVersionUID = -4729135055857591830L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('.');
            }
        };
        AbstractAction copyAction = new AbstractAction(){
            private static final long serialVersionUID = -6978981449261938672L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.copySelection();
            }
        };
        AbstractAction pasteAction = new AbstractAction(){
            private static final long serialVersionUID = 2026817603236490899L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.paste();
            }
        };
        AbstractAction interpolate = new AbstractAction(){
            private static final long serialVersionUID = -2350912575392447149L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.interpolate();
            }
        };
        AbstractAction verticalInterpolate = new AbstractAction(){
            private static final long serialVersionUID = -2350912575392447149L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.verticalInterpolate();
            }
        };
        AbstractAction horizontalInterpolate = new AbstractAction(){
            private static final long serialVersionUID = -6346750245035640773L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.horizontalInterpolate();
            }
        };
        AbstractAction multiplyAction = new AbstractAction(){
            private static final long serialVersionUID = -2350912575392447149L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().multiply();
            }
        };
        AbstractAction numNegAction = new AbstractAction(){
            private static final long serialVersionUID = -6346750245035640773L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.getToolbar().focusSetValue('-');
            }
        };
        InputMap im = this.getInputMap(2);
        KeyStroke right = KeyStroke.getKeyStroke(39, 0);
        KeyStroke left = KeyStroke.getKeyStroke(37, 0);
        KeyStroke up = KeyStroke.getKeyStroke(38, 0);
        KeyStroke down = KeyStroke.getKeyStroke(40, 0);
        KeyStroke decrement = KeyStroke.getKeyStroke('-');
        KeyStroke increment = KeyStroke.getKeyStroke('+');
        KeyStroke decrement2 = KeyStroke.getKeyStroke("control DOWN");
        KeyStroke increment2 = KeyStroke.getKeyStroke("control UP");
        KeyStroke decrement3 = KeyStroke.getKeyStroke(45, 128);
        KeyStroke increment3 = KeyStroke.getKeyStroke(521, 128);
        KeyStroke decrement4 = KeyStroke.getKeyStroke("control shift DOWN");
        KeyStroke increment4 = KeyStroke.getKeyStroke("control shift UP");
        KeyStroke num0 = KeyStroke.getKeyStroke('0');
        KeyStroke num1 = KeyStroke.getKeyStroke('1');
        KeyStroke num2 = KeyStroke.getKeyStroke('2');
        KeyStroke num3 = KeyStroke.getKeyStroke('3');
        KeyStroke num4 = KeyStroke.getKeyStroke('4');
        KeyStroke num5 = KeyStroke.getKeyStroke('5');
        KeyStroke num6 = KeyStroke.getKeyStroke('6');
        KeyStroke num7 = KeyStroke.getKeyStroke('7');
        KeyStroke num8 = KeyStroke.getKeyStroke('8');
        KeyStroke num9 = KeyStroke.getKeyStroke('9');
        KeyStroke mulKey = KeyStroke.getKeyStroke('*');
        KeyStroke mulKeys = KeyStroke.getKeyStroke(10, 128);
        KeyStroke numPoint = KeyStroke.getKeyStroke('.');
        KeyStroke copy = KeyStroke.getKeyStroke("control C");
        KeyStroke paste = KeyStroke.getKeyStroke("control V");
        KeyStroke interp = KeyStroke.getKeyStroke("shift I");
        KeyStroke vinterp = KeyStroke.getKeyStroke("shift V");
        KeyStroke hinterp = KeyStroke.getKeyStroke("shift H");
        KeyStroke numNeg = KeyStroke.getKeyStroke('-');
        im.put(right, "right");
        im.put(left, "left");
        im.put(up, "up");
        im.put(down, "down");
        im.put(increment, "incCoarseAction");
        im.put(decrement, "decCoarseAction");
        im.put(increment2, "incCoarseAction");
        im.put(decrement2, "decCoarseAction");
        im.put(increment3, "incFineAction");
        im.put(decrement3, "decFineAction");
        im.put(increment4, "incFineAction");
        im.put(decrement4, "decFineAction");
        im.put(num0, "num0Action");
        im.put(num1, "num1Action");
        im.put(num2, "num2Action");
        im.put(num3, "num3Action");
        im.put(num4, "num4Action");
        im.put(num5, "num5Action");
        im.put(num6, "num6Action");
        im.put(num7, "num7Action");
        im.put(num8, "num8Action");
        im.put(num9, "num9Action");
        im.put(numPoint, "numPointAction");
        im.put(copy, "copyAction");
        im.put(paste, "pasteAction");
        im.put(interp, "interpolate");
        im.put(vinterp, "verticalInterpolate");
        im.put(hinterp, "horizontalInterpolate");
        im.put(mulKey, "mulAction");
        im.put(mulKeys, "mulAction");
        im.put(numNeg, "numNeg");
        this.getActionMap().put(im.get(right), rightAction);
        this.getActionMap().put(im.get(left), leftAction);
        this.getActionMap().put(im.get(up), upAction);
        this.getActionMap().put(im.get(down), downAction);
        this.getActionMap().put(im.get(increment), incCoarseAction);
        this.getActionMap().put(im.get(decrement), decCoarseAction);
        this.getActionMap().put(im.get(increment2), incCoarseAction);
        this.getActionMap().put(im.get(decrement2), decCoarseAction);
        this.getActionMap().put(im.get(increment3), incFineAction);
        this.getActionMap().put(im.get(decrement3), decFineAction);
        this.getActionMap().put(im.get(increment4), incFineAction);
        this.getActionMap().put(im.get(decrement4), decFineAction);
        this.getActionMap().put(im.get(num0), num0Action);
        this.getActionMap().put(im.get(num1), num1Action);
        this.getActionMap().put(im.get(num2), num2Action);
        this.getActionMap().put(im.get(num3), num3Action);
        this.getActionMap().put(im.get(num4), num4Action);
        this.getActionMap().put(im.get(num5), num5Action);
        this.getActionMap().put(im.get(num6), num6Action);
        this.getActionMap().put(im.get(num7), num7Action);
        this.getActionMap().put(im.get(num8), num8Action);
        this.getActionMap().put(im.get(num9), num9Action);
        this.getActionMap().put(im.get(numPoint), numPointAction);
        this.getActionMap().put(im.get(mulKey), multiplyAction);
        this.getActionMap().put(im.get(mulKeys), multiplyAction);
        this.getActionMap().put(im.get(copy), copyAction);
        this.getActionMap().put(im.get(paste), pasteAction);
        this.getActionMap().put(im.get(interp), interpolate);
        this.getActionMap().put(im.get(vinterp), verticalInterpolate);
        this.getActionMap().put(im.get(hinterp), horizontalInterpolate);
        this.getActionMap().put(im.get(numNeg), numNegAction);
        this.setInputMap(0, im);
    }

    public void reset() {
        this.centerPanel.removeAll();
    }

    public DataCell[] getData() {
        return this.data;
    }

    public abstract void drawTable();

    public abstract void populateTable(byte[] var1, int var2);

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public String getName() {
        if (null == this.name || this.name.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unknown");
            if (0 != this.getStorageAddress()) {
                sb.append(" (" + this.getStorageAddress() + ")");
            }
            if (null != this.getLogParam() && !this.getLogParam().isEmpty()) {
                sb.append(" - " + this.getLogParam());
            }
            return sb.toString();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (null != name && !name.isEmpty()) {
            this.name = name;
        }
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Scale getCurrentScale() {
        return this.curScale;
    }

    public Scale getScale(String scaleName) throws NameNotFoundException {
        for (Scale scale : this.scales) {
            if (!scale.getName().equalsIgnoreCase(scaleName)) continue;
            return scale;
        }
        return new Scale();
    }

    public Vector<Scale> getScales() {
        return this.scales;
    }

    public void addScale(Scale scale) {
        for (int i = 0; i < this.scales.size(); ++i) {
            if (!this.scales.get(i).getName().equalsIgnoreCase(scale.getName())) continue;
            this.scales.remove(i);
            break;
        }
        this.scales.add(scale);
        if (null == this.curScale) {
            this.curScale = scale;
        }
        if (SettingsManager.getSettings().getDefaultScale().equalsIgnoreCase(scale.getName())) {
            this.curScale = scale;
        }
        this.validateScaling();
    }

    public int getStorageAddress() {
        return this.storageAddress;
    }

    public void setStorageAddress(int storageAddress) {
        this.storageAddress = storageAddress;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int storageType) {
        this.storageType = storageType;
        this.calcValueRange();
    }

    public boolean isSignedData() {
        return this.signed;
    }

    public void setSignedData(boolean signed) {
        this.signed = signed;
    }

    public int getEndian() {
        return this.endian;
    }

    public void setEndian(int endian) {
        this.endian = endian;
    }

    public void setDataSize(int size) {
        this.data = new DataCell[size];
    }

    public int getDataSize() {
        return this.data.length;
    }

    public boolean getFlip() {
        return this.flip;
    }

    public void setFlip(boolean flip) {
        this.flip = flip;
    }

    public void setLogParam(String logParam) {
        this.logParam = logParam;
    }

    public String getLogParam() {
        return this.logParam;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean equals(Object other) {
        try {
            if (null == other) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof Table)) {
                return false;
            }
            Table otherTable = (Table)other;
            if (!(null == this.getName() && null == otherTable.getName() || this.getName().isEmpty() && otherTable.getName().isEmpty() || this.getName().equalsIgnoreCase(otherTable.getName()))) {
                return false;
            }
            if (this.data.length != otherTable.data.length) {
                return false;
            }
            if (this.data.equals(otherTable.data)) {
                return true;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i].equals(otherTable.data[i])) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public double getMaxAllowedBin() {
        return this.maxAllowedBin;
    }

    public double getMinAllowedBin() {
        return this.minAllowedBin;
    }

    public double getMaxAllowedReal() {
        return JEPUtil.evaluate(this.getCurrentScale().getExpression(), this.getMaxAllowedBin());
    }

    public double getMinAllowedReal() {
        return JEPUtil.evaluate(this.getCurrentScale().getExpression(), this.getMinAllowedBin());
    }

    private void calcValueRange() {
        if (this.getStorageType() != 99) {
            if (this.isSignedData()) {
                switch (this.getStorageType()) {
                    case 1: {
                        this.minAllowedBin = -128.0;
                        this.maxAllowedBin = 127.0;
                        break;
                    }
                    case 2: {
                        this.minAllowedBin = -32768.0;
                        this.maxAllowedBin = 32767.0;
                        break;
                    }
                    case 4: {
                        this.minAllowedBin = -2.147483648E9;
                        this.maxAllowedBin = 2.147483647E9;
                    }
                }
            } else {
                this.maxAllowedBin = Math.pow(256.0, this.getStorageType()) - 1.0;
                this.minAllowedBin = 0.0;
            }
        } else {
            this.maxAllowedBin = 3.4028234663852886E38;
            this.minAllowedBin = this.isSignedData() ? 0.0 : -3.4028234663852886E38;
        }
    }

    public void calcCellRanges() {
        double binMax = this.data[0].getBinValue();
        double binMin = this.data[0].getBinValue();
        double compareMax = this.data[0].getCompareValue();
        double compareMin = this.data[0].getCompareValue();
        for (DataCell cell : this.data) {
            double compareValue;
            if (binMax < cell.getBinValue()) {
                binMax = cell.getBinValue();
            }
            if (binMin > cell.getBinValue()) {
                binMin = cell.getBinValue();
            }
            if (compareMax < (compareValue = cell.getCompareValue())) {
                compareMax = compareValue;
            }
            if (!(compareMin > compareValue)) continue;
            compareMin = compareValue;
        }
        this.setMaxBin(binMax);
        this.setMinBin(binMin);
        this.setMaxCompare(compareMax);
        this.setMinCompare(compareMin);
    }

    public double getMaxBin() {
        return this.maxBin;
    }

    public double getMinBin() {
        return this.minBin;
    }

    public double getMaxReal() {
        return JEPUtil.evaluate(this.getCurrentScale().getExpression(), this.getMaxBin());
    }

    public double getMinReal() {
        return JEPUtil.evaluate(this.getCurrentScale().getExpression(), this.getMinBin());
    }

    public void setMaxBin(double maxBin) {
        this.maxBin = maxBin;
    }

    public void setMinBin(double minBin) {
        this.minBin = minBin;
    }

    public double getMaxCompare() {
        return this.maxCompare;
    }

    public void setMaxCompare(double maxCompare) {
        this.maxCompare = maxCompare;
    }

    public double getMinCompare() {
        return this.minCompare;
    }

    public void setMinCompare(double minCompare) {
        this.minCompare = minCompare;
    }

    public abstract void increment(double var1);

    public abstract void multiply(double var1);

    public void setRealValue(String realValue) {
        if (!this.locked && this.userLevel <= this.getSettings().getUserLevel()) {
            for (DataCell cell : this.data) {
                if (!cell.isSelected().booleanValue()) continue;
                cell.setRealValue(realValue);
            }
        } else if (this.userLevel > this.getSettings().getUserLevel()) {
            JOptionPane.showMessageDialog(this, "This table can only be modified by users with a userlevel of \n" + this.userLevel + " or greater. Click View->User Level to change your userlevel.", "Table cannot be modified", 1);
        }
    }

    public void clearSelection() {
        this.clearSelectedData();
    }

    public void clearSelectedData() {
        for (DataCell cell : this.data) {
            if (!cell.isSelected().booleanValue()) continue;
            cell.setSelected(false);
        }
    }

    public void startHighlight(int x, int y) {
        this.highlightY = y;
        this.highlightX = x;
        this.highlight = true;
        this.highlight(x, y);
    }

    public void highlight(int x, int y) {
        if (this.highlight) {
            for (int i = 0; i < this.data.length; ++i) {
                if (i >= this.highlightY && i <= y || i <= this.highlightY && i >= y) {
                    this.data[i].setHighlighted(true);
                    continue;
                }
                this.data[i].setHighlighted(false);
            }
        }
    }

    public void stopHighlight() {
        this.highlight = false;
        for (DataCell cell : this.data) {
            if (!cell.isHighlighted()) continue;
            cell.setHighlighted(false);
            if (cell.isSelected().booleanValue()) continue;
            cell.setSelected(true);
        }
    }

    public abstract void cursorUp();

    public abstract void cursorDown();

    public abstract void cursorLeft();

    public abstract void cursorRight();

    public void setRevertPoint() {
        for (DataCell cell : this.data) {
            cell.setRevertPoint();
        }
    }

    public void undoAll() {
        this.clearLiveDataTrace();
        for (DataCell cell : this.data) {
            cell.undo();
        }
    }

    public void undoSelected() {
        this.clearLiveDataTrace();
        for (DataCell cell : this.data) {
            if (!cell.isSelected().booleanValue()) continue;
            cell.undo();
        }
    }

    public abstract byte[] saveFile(byte[] var1);

    public void setBeforeRam(boolean beforeRam) {
        this.beforeRam = beforeRam;
    }

    public void copySelection() {
        Window ancestorWindow = SwingUtilities.getWindowAncestor(this);
        if (null != ancestorWindow) {
            ancestorWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        Launcher.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.copySelectionWorker = new CopySelectionWorker(this);
        this.copySelectionWorker.execute();
    }

    public StringBuffer getTableAsString() {
        StringBuffer output = new StringBuffer("");
        for (int i = 0; i < this.data.length; ++i) {
            output.append(this.data[i].getRealValue());
            if (i >= this.data.length - 1) continue;
            output.append("\t");
        }
        return output;
    }

    public void copyTable() {
        Window ancestorWindow = SwingUtilities.getWindowAncestor(this);
        if (null != ancestorWindow) {
            ancestorWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        Launcher.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.copyTableWorker = new CopyTableWorker(this);
        this.copyTableWorker.execute();
    }

    public String getCellAsString(int index) {
        return this.data[index].getText();
    }

    public void pasteValues(String[] input) {
        for (int i = 0; i < input.length; ++i) {
            try {
                Double.parseDouble(input[i]);
                this.data[i].setRealValue(input[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void paste() {
        block11: {
            String pasteType;
            StringTokenizer st;
            block10: {
                st = new StringTokenizer("");
                try {
                    String input = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
                    st = new StringTokenizer(input);
                }
                catch (UnsupportedFlavorException input) {
                }
                catch (IOException input) {
                    // empty catch block
                }
                pasteType = st.nextToken();
                if (!"[Table1D]".equalsIgnoreCase(pasteType)) break block10;
                int i = 0;
                while (st.hasMoreTokens()) {
                    String currentToken = st.nextToken();
                    try {
                        if (!this.data[i].getText().equalsIgnoreCase(currentToken)) {
                            this.data[i].setRealValue(currentToken);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    ++i;
                }
                break block11;
            }
            if (!"[Selection1D]".equalsIgnoreCase(pasteType) || !this.data[this.highlightY].isSelected().booleanValue()) break block11;
            int i = 0;
            while (st.hasMoreTokens()) {
                try {
                    this.data[this.highlightY + i].setRealValue(st.nextToken());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public void verticalInterpolate() {
        this.horizontalInterpolate();
    }

    public abstract void horizontalInterpolate();

    public void interpolate() {
        this.horizontalInterpolate();
    }

    public void validateScaling() {
        if (this.type != 6) {
            if (this.scales.isEmpty()) {
                this.scales.add(new Scale());
            }
            for (Scale scale : this.scales) {
                double startValue = 5.0;
                double toReal = JEPUtil.evaluate(scale.getExpression(), startValue);
                double endValue = JEPUtil.evaluate(scale.getByteExpression(), toReal);
                if (!(Math.abs(endValue - startValue) > 0.001)) continue;
                JPanel panel = new JPanel();
                panel.setLayout(new GridLayout(4, 1));
                panel.add(new JLabel("The real value and byte value conversion expressions for table " + this.getName() + " are invalid."));
                panel.add(new JLabel("To real value: " + scale.getExpression()));
                panel.add(new JLabel("To byte: " + scale.getByteExpression()));
                JCheckBox check = new JCheckBox("Always display this message", true);
                check.setHorizontalAlignment(4);
                panel.add(check);
                check.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Table.this.getSettings().setCalcConflictWarning(((JCheckBox)e.getSource()).isSelected());
                    }
                });
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), panel, "Warning", 0);
            }
        }
    }

    public void populateCompareValues(Table otherTable) {
        if (null == otherTable) {
            return;
        }
        DataCell[] compareData = otherTable.getData();
        if (this.data.length != compareData.length) {
            return;
        }
        this.clearLiveDataTrace();
        int i = 0;
        for (DataCell cell : this.data) {
            cell.setCompareValue(compareData[i]);
            ++i;
        }
        this.calcCellRanges();
        this.drawTable();
    }

    public void setCompareDisplay(int compareDisplay) {
        this.compareDisplay = compareDisplay;
        this.drawTable();
    }

    public int getCompareDisplay() {
        return this.compareDisplay;
    }

    public void setCompareValueType(int compareValueType) {
        this.compareValueType = compareValueType;
        this.drawTable();
    }

    public int getCompareValueType() {
        return this.compareValueType;
    }

    public int getUserLevel() {
        return this.userLevel;
    }

    public void setUserLevel(int userLevel) {
        this.userLevel = userLevel;
        if (userLevel > 5) {
            userLevel = 5;
        } else if (userLevel < 1) {
            userLevel = 1;
        }
    }

    public void setScaleByName(String scaleName) throws NameNotFoundException {
        for (Scale scale : this.scales) {
            if (!scale.getName().equalsIgnoreCase(scaleName)) continue;
            Scale currentScale = this.getCurrentScale();
            if (currentScale == null || !currentScale.equals(scale)) {
                this.setCurrentScale(scale);
            }
            return;
        }
        throw new NameNotFoundException();
    }

    public void setCurrentScale(Scale curScale) {
        this.curScale = curScale;
        this.updateTableLabel();
        this.drawTable();
    }

    public Settings getSettings() {
        return SettingsManager.getSettings();
    }

    public TableToolBar getToolbar() {
        return ECUEditorManager.getECUEditor().getTableToolBar();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setOverlayLog(boolean overlayLog) {
        this.overlayLog = overlayLog;
        if (overlayLog) {
            this.clearLiveDataTrace();
        }
    }

    public boolean getOverlayLog() {
        return this.overlayLog;
    }

    public double getLiveAxisValue() {
        try {
            return Double.parseDouble(this.liveAxisValue);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public abstract boolean isLiveDataSupported();

    public abstract boolean isButtonSelected();

    public void highlightLiveData(String liveVal) {
        if (this.getOverlayLog()) {
            double liveValue = 0.0;
            try {
                liveValue = Double.parseDouble(liveVal);
            }
            catch (NumberFormatException nex) {
                return;
            }
            int startIdx = this.data.length;
            for (int i = 0; i < this.data.length; ++i) {
                double currentValue = this.data[i].getRealValue();
                if (liveValue == currentValue) {
                    startIdx = i;
                    break;
                }
                if (!(liveValue < currentValue)) continue;
                startIdx = i - 1;
                break;
            }
            this.setLiveDataIndex(startIdx);
            DataCell cell = this.data[this.getLiveDataIndex()];
            cell.setLiveDataTrace(true);
            cell.setLiveDataTraceValue(liveVal);
            this.getToolbar().setLiveDataValue(liveVal);
        }
    }

    public void updateLiveDataHighlight() {
        if (this.getOverlayLog()) {
            this.data[this.getLiveDataIndex()].setLiveDataTrace(true);
        }
    }

    public int getLiveDataIndex() {
        return this.liveDataIndex;
    }

    public void setLiveDataIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index >= this.data.length) {
            index = this.data.length - 1;
        }
        this.liveDataIndex = index;
    }

    public void clearLiveDataTrace() {
        for (DataCell cell : this.data) {
            cell.setLiveDataTrace(false);
        }
    }

    public String getLogParamString() {
        return this.getName() + ":" + this.getLogParam();
    }

    public Table getCompareTable() {
        return this.compareTable;
    }

    public void setCompareTable(Table compareTable) {
        this.compareTable = compareTable;
    }

    public void updateTableLabel() {
        if (null != this.name && !this.name.isEmpty()) {
            if (null == this.getCurrentScale() || "0x" == this.getCurrentScale().getUnit()) {
                this.tableLabel.setText(this.getName());
            } else {
                this.tableLabel.setText(this.getName() + " (" + this.getCurrentScale().getUnit() + ")");
            }
        }
    }

    public void colorCells() {
        this.calcCellRanges();
        this.drawTable();
    }

    public void refreshCompare() {
        this.populateCompareValues(this.getCompareTable());
    }

    public boolean isStaticDataTable() {
        return this.staticDataTable;
    }

    public void setStaticDataTable(boolean staticDataTable) {
        this.staticDataTable = staticDataTable;
    }
}

