/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.maps.DataCell;
import com.romraider.maps.Table;
import com.romraider.maps.Table2D;
import com.romraider.maps.Table3D;
import com.romraider.maps.TableWithData;
import java.awt.Component;
import javax.swing.JLabel;

public class Table1D
extends TableWithData {
    public static final String TYPE_1D = "1D";
    public static final String TYPE_X_AXIS = "X Axis";
    public static final String TYPE_Y_AXIS = "Y Axis";
    private static final long serialVersionUID = -8747180767803835631L;
    private Table axisParent = null;
    boolean ec = false;

    public void setAxisParent(Table axisParent) {
        this.axisParent = axisParent;
    }

    public Table getAxisParent() {
        return this.axisParent;
    }

    public void addStaticDataCell(DataCell input) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != null) continue;
            this.data[i] = input;
            this.data[i].setY(i);
            break;
        }
    }

    @Override
    public void populateTable(byte[] input, int romRamOffset) {
        this.centerLayout.setRows(1);
        this.centerLayout.setColumns(this.getDataSize());
        super.populateTable(input, romRamOffset);
        for (int i = 0; i < this.getDataSize(); ++i) {
            this.centerPanel.add(this.getDataCell(i));
        }
        if (null != this.name && !this.name.isEmpty()) {
            if (null == this.getCurrentScale() || "0x" == this.getCurrentScale().getUnit()) {
                this.tableLabel = new JLabel(this.getName(), 0);
                this.add((Component)this.tableLabel, "North");
            } else {
                this.tableLabel = new JLabel(this.getName() + " (" + this.getCurrentScale().getUnit() + ")", 0);
                this.add((Component)this.tableLabel, "North");
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + " (1D)";
    }

    @Override
    public void cursorUp() {
        if (this.type == 5) {
            if (this.highlightY > 0 && this.data[this.highlightY].isSelected().booleanValue()) {
                this.selectCellAt(this.highlightY - 1);
            }
        } else if (this.type == 4 || this.type == 1) {
            // empty if block
        }
    }

    @Override
    public void cursorDown() {
        if (this.type == 5) {
            if (this.getAxisParent().getType() == 3) {
                if (this.highlightY < this.getDataSize() - 1 && this.data[this.highlightY].isSelected().booleanValue()) {
                    this.selectCellAt(this.highlightY + 1);
                }
            } else if (this.getAxisParent().getType() == 2) {
                Table2D axisParent = (Table2D)this.getAxisParent();
                if (this.data[this.highlightY].isSelected().booleanValue()) {
                    axisParent.selectCellAt(this.highlightY);
                }
            }
        } else if (this.type == 4 && this.data[this.highlightY].isSelected().booleanValue()) {
            ((Table3D)this.getAxisParent()).selectCellAt(this.highlightY, this);
        } else if (this.type == 1) {
            // empty if block
        }
    }

    @Override
    public void cursorLeft() {
        if (this.type == 5) {
            if (this.getAxisParent().getType() == 2 && this.data[this.highlightY].isSelected().booleanValue()) {
                this.selectCellAt(this.highlightY - 1);
            }
        } else if (this.type == 4 && this.data[this.highlightY].isSelected().booleanValue()) {
            if (this.highlightY > 0) {
                this.selectCellAt(this.highlightY - 1);
            }
        } else if (this.type == 1 && this.data[this.highlightY].isSelected().booleanValue() && this.highlightY > 0) {
            this.selectCellAt(this.highlightY - 1);
        }
    }

    @Override
    public void cursorRight() {
        if (this.type == 5 && this.data[this.highlightY].isSelected().booleanValue()) {
            if (this.getAxisParent().getType() == 3) {
                ((Table3D)this.getAxisParent()).selectCellAt(this.highlightY, this);
            } else if (this.getAxisParent().getType() == 2) {
                this.selectCellAt(this.highlightY + 1);
            }
        } else if (this.type == 4 && this.data[this.highlightY].isSelected().booleanValue()) {
            if (this.highlightY < this.getDataSize() - 1) {
                this.selectCellAt(this.highlightY + 1);
            }
        } else if (this.type == 1 && this.data[this.highlightY].isSelected().booleanValue() && this.highlightY < this.getDataSize() - 1) {
            this.selectCellAt(this.highlightY + 1);
        }
    }

    @Override
    public void clearSelection() {
        this.getAxisParent().clearSelection();
    }

    @Override
    public void startHighlight(int x, int y) {
        Table axisParent = this.getAxisParent();
        axisParent.clearSelectedData();
        if (axisParent instanceof Table3D) {
            Table3D table3D = (Table3D)axisParent;
            if (this.getType() == 4) {
                table3D.getYAxis().clearSelectedData();
            } else if (this.getType() == 5) {
                table3D.getXAxis().clearSelectedData();
            }
        } else if (axisParent instanceof Table2D) {
            ((Table2D)axisParent).getAxis().clearSelectedData();
        }
        super.startHighlight(x, y);
    }

    @Override
    public String getCellAsString(int index) {
        return this.data[index].getText();
    }

    @Override
    public void highlightLiveData(String liveVal) {
        if (this.getOverlayLog()) {
            double liveValue = 0.0;
            try {
                liveValue = Double.parseDouble(liveVal);
            }
            catch (NumberFormatException nex) {
                return;
            }
            int startIdx = this.data.length;
            for (int i = 0; i < this.data.length; ++i) {
                double currentValue = 0.0;
                if (this.isStaticDataTable() && null != this.data[i].getStaticText()) {
                    try {
                        currentValue = Double.parseDouble(this.data[i].getStaticText());
                    }
                    catch (NumberFormatException nex) {
                        return;
                    }
                } else {
                    currentValue = this.data[i].getRealValue();
                }
                if (liveValue == currentValue) {
                    startIdx = i;
                    break;
                }
                if (!(liveValue < currentValue)) continue;
                startIdx = i - 1;
                break;
            }
            this.setLiveDataIndex(startIdx);
            DataCell cell = this.data[this.getLiveDataIndex()];
            cell.setLiveDataTrace(true);
            cell.setLiveDataTraceValue(liveVal);
            this.getToolbar().setLiveDataValue(liveVal);
        }
        this.getAxisParent().updateLiveDataHighlight();
    }

    @Override
    public boolean isLiveDataSupported() {
        return false;
    }

    @Override
    public boolean isButtonSelected() {
        return true;
    }

    public boolean isAxis() {
        return this.getType() == 4 || this.getType() == 5 || this.isStaticDataTable();
    }

    @Override
    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Table1D)) {
            return false;
        }
        Table1D otherTable = (Table1D)other;
        if (this.isAxis() != otherTable.isAxis()) {
            return false;
        }
        if (this.data.length != otherTable.data.length) {
            return false;
        }
        if (this.data.equals(otherTable.data)) {
            return true;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].equals(otherTable.data[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearLiveDataTrace() {
        super.clearLiveDataTrace();
        if (!this.ec) {
            this.ec = true;
            this.getAxisParent().clearLiveDataTrace();
            this.ec = false;
        }
    }

    @Override
    public void updateTableLabel() {
        this.getAxisParent().updateTableLabel();
    }

    @Override
    public StringBuffer getTableAsString() {
        if (this.isStaticDataTable()) {
            StringBuffer output = new StringBuffer("");
            for (int i = 0; i < this.data.length; ++i) {
                output.append(this.data[i].getStaticText());
                if (i >= this.data.length - 1) continue;
                output.append("\t");
            }
            return output;
        }
        return super.getTableAsString();
    }
}

