/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.Settings;
import com.romraider.maps.CopySelection2DWorker;
import com.romraider.maps.CopyTable2DWorker;
import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.Table1D;
import com.romraider.maps.TableWithData;
import com.romraider.util.ParamChecker;
import com.romraider.util.SettingsManager;
import com.rusefi.Launcher;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.naming.NameNotFoundException;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class Table2D
extends TableWithData {
    public static final String TYPE_2D = "2D";
    private static final long serialVersionUID = -7684570967109324784L;
    private Table1D axis = new Table1D();
    private JLabel axisLabel;
    private CopySelection2DWorker copySelection2DWorker;

    public Table2D() {
        this.verticalOverhead += 18;
    }

    public Table1D getAxis() {
        return this.axis;
    }

    public void setAxis(Table1D axis) {
        this.axis = axis;
        axis.setAxisParent(this);
    }

    @Override
    public String toString() {
        return super.toString() + " (2D)";
    }

    @Override
    public void populateCompareValues(Table otherTable) {
        if (null == otherTable || !(otherTable instanceof Table2D)) {
            return;
        }
        Table2D compareTable2D = (Table2D)otherTable;
        if (this.data.length != compareTable2D.data.length || this.axis.data.length != compareTable2D.axis.data.length) {
            return;
        }
        super.populateCompareValues(otherTable);
        this.axis.populateCompareValues(compareTable2D.getAxis());
    }

    @Override
    public void refreshCompare() {
        this.populateCompareValues(this.getCompareTable());
        this.axis.refreshCompare();
    }

    @Override
    public StringBuffer getTableAsString() {
        StringBuffer output = new StringBuffer("");
        output.append(this.axis.getTableAsString());
        output.append(Settings.NEW_LINE);
        output.append(super.getTableAsString());
        return output;
    }

    @Override
    public Dimension getFrameSize() {
        int minWidth;
        int height = this.verticalOverhead + this.cellHeight * 2;
        int width = this.horizontalOverhead + this.data.length * this.cellWidth;
        if (height < this.minHeight) {
            height = this.minHeight;
        }
        int n = minWidth = this.isLiveDataSupported() ? this.minWidthOverlay : this.minWidthNoOverlay;
        if (width < minWidth) {
            width = minWidth;
        }
        return new Dimension(width, height);
    }

    @Override
    public void populateTable(byte[] input, int romRamOffset) throws IndexOutOfBoundsException {
        int i;
        this.centerLayout.setRows(2);
        this.centerLayout.setColumns(this.getDataSize());
        this.axis.populateTable(input, romRamOffset);
        super.populateTable(input, romRamOffset);
        for (i = 0; i < this.getDataSize(); ++i) {
            this.centerPanel.add(this.axis.getDataCell(i));
        }
        if (this.flip) {
            for (i = this.getDataSize() - 1; i >= 0; --i) {
                this.centerPanel.add(this.getDataCell(i));
            }
        } else {
            for (i = 0; i < this.getDataSize(); ++i) {
                this.centerPanel.add(this.getDataCell(i));
            }
        }
        if (null != this.axis.getName() && !this.axis.getName().isEmpty() && "" != this.axis.getName()) {
            if (null == this.axis.getCurrentScale() || "0x" == this.axis.getCurrentScale().getUnit()) {
                this.axisLabel = new JLabel(this.axis.getName(), 0);
                this.add((Component)this.axisLabel, "North");
            } else {
                this.axisLabel = new JLabel(this.axis.getName() + " (" + this.axis.getCurrentScale().getUnit() + ")", 0);
                this.add((Component)this.axisLabel, "North");
            }
        }
        this.tableLabel = new JLabel(this.getCurrentScale().getUnit(), 0);
        this.add((Component)this.tableLabel, "South");
        this.repaint();
    }

    @Override
    public void updateTableLabel() {
        if (null != this.axis.getName() && this.axis.getName().length() >= 1 && "" != this.axis.getName()) {
            if (null == this.axis.getCurrentScale() || "0x" == this.axis.getCurrentScale().getUnit()) {
                this.axisLabel.setText(this.axis.getName());
            } else {
                this.axisLabel.setText(this.axis.getName() + " (" + this.axis.getCurrentScale().getUnit() + ")");
            }
        }
        this.tableLabel.setText(this.getCurrentScale().getUnit());
    }

    @Override
    public void clearSelection() {
        this.axis.clearSelectedData();
        this.clearSelectedData();
    }

    @Override
    public void setRevertPoint() {
        super.setRevertPoint();
        this.axis.setRevertPoint();
    }

    @Override
    public void undoAll() {
        super.undoAll();
        this.axis.undoAll();
    }

    @Override
    public byte[] saveFile(byte[] binData) {
        binData = super.saveFile(binData);
        binData = this.axis.saveFile(binData);
        return binData;
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        super.addKeyListener(listener);
        this.axis.addKeyListener(listener);
    }

    @Override
    public void cursorUp() {
        if (this.data[this.highlightY].isSelected().booleanValue()) {
            this.axis.selectCellAt(this.highlightY);
        }
    }

    @Override
    public void drawTable() {
        super.drawTable();
        this.axis.drawTable();
    }

    @Override
    public void cursorDown() {
        this.axis.cursorDown();
    }

    @Override
    public void cursorLeft() {
        if (this.highlightY > 0 && this.data[this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightY - 1);
        } else {
            this.axis.cursorLeft();
        }
    }

    @Override
    public void cursorRight() {
        if (this.highlightY < this.data.length - 1 && this.data[this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightY + 1);
        } else {
            this.axis.cursorRight();
        }
    }

    @Override
    public void startHighlight(int x, int y) {
        this.axis.clearSelectedData();
        super.startHighlight(x, y);
    }

    @Override
    public void copySelection() {
        Window ancestorWindow = SwingUtilities.getWindowAncestor(this);
        if (null != ancestorWindow) {
            ancestorWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        Launcher.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.setCursor(Cursor.getPredefinedCursor(3));
        super.copySelection();
        this.copySelection2DWorker = new CopySelection2DWorker(this);
        this.copySelection2DWorker.execute();
    }

    @Override
    public void copyTable() {
        Window ancestorWindow = SwingUtilities.getWindowAncestor(this);
        if (null != ancestorWindow) {
            ancestorWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        Launcher.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.setCursor(Cursor.getPredefinedCursor(3));
        CopyTable2DWorker copyTable2DWorker = new CopyTable2DWorker(this);
        copyTable2DWorker.execute();
    }

    @Override
    public void paste() {
        StringTokenizer st = new StringTokenizer("");
        String input = "";
        try {
            input = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            st = new StringTokenizer(input);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        String pasteType = st.nextToken();
        if (pasteType.equalsIgnoreCase("[Table2D]")) {
            String axisValues = "[Table1D]" + Settings.NEW_LINE + st.nextToken(Settings.NEW_LINE);
            String dataValues = "[Table1D]" + Settings.NEW_LINE + st.nextToken(Settings.NEW_LINE);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(axisValues), null);
            this.axis.paste();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(dataValues), null);
            super.paste();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(input), null);
        } else if (pasteType.equalsIgnoreCase("[Selection1D]")) {
            if (this.data[this.highlightY].isSelected().booleanValue()) {
                super.paste();
            } else {
                this.axis.paste();
            }
        }
    }

    @Override
    public void interpolate() {
        super.interpolate();
        this.getAxis().interpolate();
    }

    @Override
    public void verticalInterpolate() {
        super.verticalInterpolate();
        this.getAxis().verticalInterpolate();
    }

    @Override
    public void horizontalInterpolate() {
        super.horizontalInterpolate();
        this.getAxis().horizontalInterpolate();
    }

    @Override
    public boolean isLiveDataSupported() {
        return !ParamChecker.isNullOrEmpty(this.axis.getLogParam());
    }

    @Override
    public boolean isButtonSelected() {
        return true;
    }

    @Override
    public void clearLiveDataTrace() {
        super.clearLiveDataTrace();
        this.axis.clearLiveDataTrace();
    }

    @Override
    public void updateLiveDataHighlight() {
        if (this.getOverlayLog()) {
            this.data[this.axis.getLiveDataIndex()].setLiveDataTrace(true);
        }
    }

    @Override
    public String getLogParamString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.axis.getLogParamString() + ", ");
        sb.append(this.getName() + ":" + this.getLogParam());
        return sb.toString();
    }

    @Override
    public void setOverlayLog(boolean overlayLog) {
        super.setOverlayLog(overlayLog);
        this.axis.setOverlayLog(overlayLog);
        if (overlayLog) {
            this.axis.clearLiveDataTrace();
        }
    }

    @Override
    public void setCompareDisplay(int compareDisplay) {
        super.setCompareDisplay(compareDisplay);
        this.axis.setCompareDisplay(compareDisplay);
    }

    @Override
    public void setCompareValueType(int compareValueType) {
        super.setCompareValueType(compareValueType);
        this.axis.setCompareValueType(compareValueType);
    }

    @Override
    public void setCurrentScale(Scale curScale) {
        if (SettingsManager.getSettings().isScaleHeadersAndData() && !this.axis.isStaticDataTable()) {
            try {
                this.axis.setScaleByName(curScale.getName());
            }
            catch (NameNotFoundException e) {
                try {
                    this.axis.setScaleByName(SettingsManager.getSettings().getDefaultScale());
                }
                catch (NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
        }
        this.curScale = curScale;
        this.updateTableLabel();
        this.drawTable();
    }

    @Override
    public boolean equals(Object other) {
        try {
            if (null == other) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof Table2D)) {
                return false;
            }
            Table2D otherTable = (Table2D)other;
            if (!(null == this.getName() && null == otherTable.getName() || this.getName().isEmpty() && otherTable.getName().isEmpty() || this.getName().equalsIgnoreCase(otherTable.getName()))) {
                return false;
            }
            if (!this.axis.equals(otherTable.axis)) {
                return false;
            }
            if (this.data.length != otherTable.data.length) {
                return false;
            }
            if (this.data.equals(otherTable.data)) {
                return true;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i].equals(otherTable.data[i])) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        if (null != this.axis) {
            this.axis.repaint();
        }
    }
}

