/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.Settings;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.logger.ecu.ui.swing.vertical.VerticalLabelUI;
import com.romraider.maps.CopySelection3DWorker;
import com.romraider.maps.CopyTable3DWorker;
import com.romraider.maps.DataCell;
import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.Table1D;
import com.romraider.util.ParamChecker;
import com.romraider.util.SettingsManager;
import com.romraider.xml.RomAttributeParser;
import com.rusefi.Launcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.naming.NameNotFoundException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Table3D
extends Table {
    public static final String TYPE_3D = "3D";
    private static final long serialVersionUID = 3103448753263606599L;
    private Table1D xAxis = new Table1D();
    private Table1D yAxis = new Table1D();
    private JLabel xAxisLabel;
    private JLabel yAxisLabel;
    DataCell[][] data = new DataCell[1][1];
    private boolean swapXY = false;
    private boolean flipX = false;
    private boolean flipY = false;
    CopyTable3DWorker copyTable3DWorker;
    CopySelection3DWorker copySelection3DWorker;

    public Table3D() {
        this.verticalOverhead += 39;
        this.horizontalOverhead += 10;
    }

    public Table1D getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(Table1D xAxis) {
        this.xAxis = xAxis;
        xAxis.setAxisParent(this);
    }

    public Table1D getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(Table1D yAxis) {
        this.yAxis = yAxis;
        yAxis.setAxisParent(this);
    }

    public boolean getSwapXY() {
        return this.swapXY;
    }

    public void setSwapXY(boolean swapXY) {
        this.swapXY = swapXY;
    }

    public boolean getFlipX() {
        return this.flipX;
    }

    public void setFlipX(boolean flipX) {
        this.flipX = flipX;
    }

    public boolean getFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public void setSizeX(int size) {
        this.data = new DataCell[size][this.data[0].length];
        this.centerLayout.setColumns(size + 1);
    }

    public int getSizeX() {
        return this.data.length;
    }

    public void setSizeY(int size) {
        this.data = new DataCell[this.data.length][size];
        this.centerLayout.setRows(size + 1);
    }

    public int getSizeY() {
        return this.data[0].length;
    }

    @Override
    public void drawTable() {
        DataCell[][] dataCellArray = this.data;
        int n = dataCellArray.length;
        for (int i = 0; i < n; ++i) {
            DataCell[] column;
            for (DataCell cell : column = dataCellArray[i]) {
                if (null == cell) continue;
                cell.drawCell();
            }
        }
        this.xAxis.drawTable();
        this.yAxis.drawTable();
    }

    @Override
    public void populateTable(byte[] input, int romRamOffset) throws NullPointerException, ArrayIndexOutOfBoundsException, IndexOutOfBoundsException {
        this.centerPanel.add(new JLabel());
        if (!this.beforeRam) {
            this.ramOffset = romRamOffset;
        }
        boolean tempLock = this.locked;
        this.locked = false;
        this.xAxis.populateTable(input, romRamOffset);
        this.yAxis.populateTable(input, romRamOffset);
        for (int x = 0; x < this.xAxis.getDataSize(); ++x) {
            this.centerPanel.add(this.xAxis.getDataCell(x));
        }
        int offset = 0;
        int iMax = this.swapXY ? this.xAxis.getDataSize() : this.yAxis.getDataSize();
        int jMax = this.swapXY ? this.yAxis.getDataSize() : this.xAxis.getDataSize();
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                double cellBinValue;
                int y;
                int x = this.flipY ? jMax - j - 1 : j;
                int n = y = this.flipX ? iMax - i - 1 : i;
                if (this.swapXY) {
                    int z = x;
                    x = y;
                    y = z;
                }
                if (this.storageType == 99) {
                    byte[] byteValue = new byte[]{input[this.getStorageAddress() + offset * 4 - this.ramOffset], input[this.getStorageAddress() + offset * 4 - this.ramOffset + 1], input[this.getStorageAddress() + offset * 4 - this.ramOffset + 2], input[this.getStorageAddress() + offset * 4 - this.ramOffset + 3]};
                    cellBinValue = RomAttributeParser.byteToFloat(byteValue, this.endian);
                } else {
                    cellBinValue = RomAttributeParser.parseByteValue(input, this.endian, this.getStorageAddress() + offset * this.storageType - this.ramOffset, this.storageType, this.signed);
                }
                if (tempLock) {
                    this.data[x][y].setForeground(Color.GRAY);
                }
                this.data[x][y] = new DataCell(this, cellBinValue, x, y);
                ++offset;
            }
        }
        for (int y = 0; y < this.yAxis.getDataSize(); ++y) {
            this.centerPanel.add(this.yAxis.getDataCell(y));
            for (int x = 0; x < this.xAxis.getDataSize(); ++x) {
                this.centerPanel.add(this.data[x][y]);
            }
        }
        this.locked = tempLock;
        GridLayout topLayout = new GridLayout(2, 1);
        JPanel topPanel = new JPanel(topLayout);
        this.add((Component)topPanel, "North");
        topPanel.add((Component)new JLabel(this.getName(), 0), "North");
        if (null != this.xAxis.getName() && this.xAxis.getName().length() >= 1 && "" != this.xAxis.getName()) {
            if (null == this.xAxis.getCurrentScale() || "0x" == this.xAxis.getCurrentScale().getUnit()) {
                this.xAxisLabel = new JLabel(this.xAxis.getName(), 0);
                topPanel.add((Component)this.xAxisLabel, "North");
            } else {
                this.xAxisLabel = new JLabel(this.xAxis.getName() + " (" + this.xAxis.getCurrentScale().getUnit() + ")", 0);
                topPanel.add((Component)this.xAxisLabel, "North");
            }
        }
        this.yAxisLabel = null;
        if (null != this.yAxis.getName() && this.yAxis.getName().length() >= 1 && "" != this.yAxis.getName()) {
            this.yAxisLabel = null == this.yAxis.getCurrentScale() || "0x" == this.yAxis.getCurrentScale().getUnit() ? new JLabel(this.yAxis.getName()) : new JLabel(this.yAxis.getName() + " (" + this.yAxis.getCurrentScale().getUnit() + ")");
        }
        this.yAxisLabel.setUI(new VerticalLabelUI(false));
        this.add((Component)this.yAxisLabel, "West");
        this.tableLabel = new JLabel(this.getCurrentScale().getUnit(), 0);
        this.add((Component)this.tableLabel, "South");
        this.calcCellRanges();
    }

    @Override
    public void updateTableLabel() {
        if (null != this.xAxis.getName() && this.xAxis.getName().length() >= 1 && "" != this.xAxis.getName()) {
            if (null == this.xAxis.getCurrentScale() || "0x" == this.xAxis.getCurrentScale().getUnit()) {
                this.xAxisLabel.setText(this.xAxis.getName());
            } else {
                this.xAxisLabel.setText(this.xAxis.getName() + " (" + this.xAxis.getCurrentScale().getUnit() + ")");
            }
        }
        if (null != this.yAxis.getName() && this.yAxis.getName().length() >= 1 && "" != this.yAxis.getName()) {
            if (null == this.yAxis.getCurrentScale() || "0x" == this.yAxis.getCurrentScale().getUnit()) {
                this.yAxisLabel.setText(this.yAxis.getName());
            } else {
                this.yAxisLabel.setText(this.yAxis.getName() + " (" + this.yAxis.getCurrentScale().getUnit() + ")");
            }
        }
        this.tableLabel.setText(this.getCurrentScale().getUnit());
    }

    @Override
    public void calcCellRanges() {
        double binMax = this.data[0][0].getBinValue();
        double binMin = this.data[0][0].getBinValue();
        double compareMax = this.data[0][0].getCompareValue();
        double compareMin = this.data[0][0].getCompareValue();
        DataCell[][] dataCellArray = this.data;
        int n = dataCellArray.length;
        for (int i = 0; i < n; ++i) {
            DataCell[] column;
            for (DataCell cell : column = dataCellArray[i]) {
                double compareValue;
                if (binMax < cell.getBinValue()) {
                    binMax = cell.getBinValue();
                }
                if (binMin > cell.getBinValue()) {
                    binMin = cell.getBinValue();
                }
                if (compareMax < (compareValue = cell.getCompareValue())) {
                    compareMax = compareValue;
                }
                if (!(compareMin > compareValue)) continue;
                compareMin = compareValue;
            }
        }
        this.setMaxBin(binMax);
        this.setMinBin(binMin);
        this.setMaxCompare(compareMax);
        this.setMinCompare(compareMin);
    }

    @Override
    public StringBuffer getTableAsString() {
        StringBuffer output = new StringBuffer("");
        output.append(this.xAxis.getTableAsString());
        output.append(Settings.NEW_LINE);
        for (int y = 0; y < this.getSizeY(); ++y) {
            output.append(this.yAxis.data[y].getRealValue());
            output.append("\t");
            for (int x = 0; x < this.getSizeX(); ++x) {
                output.append(this.data[x][y].getRealValue());
                if (x >= this.getSizeX() - 1) continue;
                output.append("\t");
            }
            if (y >= this.getSizeY() - 1) continue;
            output.append(Settings.NEW_LINE);
        }
        return output;
    }

    @Override
    public void populateCompareValues(Table otherTable) {
        if (null == otherTable || !(otherTable instanceof Table3D)) {
            return;
        }
        Table3D compareTable3D = (Table3D)otherTable;
        if (this.data.length != compareTable3D.data.length || this.data[0].length != compareTable3D.data[0].length || this.xAxis.getDataSize() != compareTable3D.xAxis.getDataSize() || this.yAxis.getDataSize() != compareTable3D.yAxis.getDataSize()) {
            return;
        }
        this.clearLiveDataTrace();
        int x = 0;
        for (DataCell[] column : this.data) {
            int y = 0;
            for (DataCell cell : column) {
                cell.setCompareValue(compareTable3D.data[x][y]);
                ++y;
            }
            ++x;
        }
        this.xAxis.populateCompareValues(compareTable3D.getXAxis());
        this.yAxis.populateCompareValues(compareTable3D.getYAxis());
        this.calcCellRanges();
        this.drawTable();
    }

    @Override
    public void refreshCompare() {
        this.populateCompareValues(this.getCompareTable());
        this.xAxis.refreshCompare();
        this.yAxis.refreshCompare();
    }

    public Dimension getFrameSize() {
        int minWidth;
        int height = this.verticalOverhead + this.cellHeight * this.data[0].length;
        int width = this.horizontalOverhead + this.data.length * this.cellWidth;
        if (height < this.minHeight) {
            height = this.minHeight;
        }
        int n = minWidth = this.isLiveDataSupported() ? this.minWidthOverlay : this.minWidthNoOverlay;
        if (width < minWidth) {
            width = minWidth;
        }
        return new Dimension(width, height);
    }

    @Override
    public String toString() {
        return super.toString() + " (3D)";
    }

    @Override
    public void increment(double increment) {
        if (!this.locked) {
            for (int x = 0; x < this.getSizeX(); ++x) {
                for (int y = 0; y < this.getSizeY(); ++y) {
                    if (!this.data[x][y].isSelected().booleanValue()) continue;
                    this.data[x][y].increment(increment);
                }
            }
        }
    }

    @Override
    public void multiply(double factor) {
        if (!this.locked) {
            for (int x = 0; x < this.getSizeX(); ++x) {
                for (int y = 0; y < this.getSizeY(); ++y) {
                    if (!this.data[x][y].isSelected().booleanValue()) continue;
                    this.data[x][y].multiply(factor);
                }
            }
        }
    }

    @Override
    public void clearSelection() {
        this.xAxis.clearSelectedData();
        this.yAxis.clearSelectedData();
        this.clearSelectedData();
    }

    @Override
    public void clearSelectedData() {
        for (int x = 0; x < this.getSizeX(); ++x) {
            for (int y = 0; y < this.getSizeY(); ++y) {
                this.data[x][y].setSelected(false);
            }
        }
    }

    @Override
    public void highlight(int xCoord, int yCoord) {
        if (this.highlight) {
            for (int x = 0; x < this.getSizeX(); ++x) {
                for (int y = 0; y < this.getSizeY(); ++y) {
                    if ((y >= this.highlightY && y <= yCoord || y <= this.highlightY && y >= yCoord) && (x >= this.highlightX && x <= xCoord || x <= this.highlightX && x >= xCoord)) {
                        this.data[x][y].setHighlighted(true);
                        continue;
                    }
                    this.data[x][y].setHighlighted(false);
                }
            }
        }
    }

    @Override
    public void stopHighlight() {
        this.highlight = false;
        for (int x = 0; x < this.getSizeX(); ++x) {
            for (int y = 0; y < this.getSizeY(); ++y) {
                if (!this.data[x][y].isHighlighted()) continue;
                this.data[x][y].setSelected(true);
                this.data[x][y].setHighlighted(false);
            }
        }
    }

    @Override
    public void setRevertPoint() {
        for (int x = 0; x < this.getSizeX(); ++x) {
            for (int y = 0; y < this.getSizeY(); ++y) {
                this.data[x][y].setRevertPoint();
            }
        }
        this.yAxis.setRevertPoint();
        this.xAxis.setRevertPoint();
    }

    @Override
    public void undoAll() {
        this.clearLiveDataTrace();
        for (int x = 0; x < this.getSizeX(); ++x) {
            for (int y = 0; y < this.getSizeY(); ++y) {
                this.data[x][y].undo();
            }
        }
        this.yAxis.undoAll();
        this.xAxis.undoAll();
    }

    @Override
    public void undoSelected() {
        this.clearLiveDataTrace();
        for (int x = 0; x < this.getSizeX(); ++x) {
            for (int y = 0; y < this.getSizeY(); ++y) {
                if (!this.data[x][y].isSelected().booleanValue()) continue;
                this.data[x][y].undo();
            }
        }
    }

    @Override
    public byte[] saveFile(byte[] binData) {
        if (this.userLevel <= this.getSettings().getUserLevel() && (this.userLevel < 5 || this.getSettings().isSaveDebugTables())) {
            binData = this.xAxis.saveFile(binData);
            binData = this.yAxis.saveFile(binData);
            int offset = 0;
            int iMax = this.swapXY ? this.xAxis.getDataSize() : this.yAxis.getDataSize();
            int jMax = this.swapXY ? this.yAxis.getDataSize() : this.xAxis.getDataSize();
            for (int i = 0; i < iMax; ++i) {
                for (int j = 0; j < jMax; ++j) {
                    int z;
                    byte[] output;
                    int y;
                    int x = this.flipY ? jMax - j - 1 : j;
                    int n = y = this.flipX ? iMax - i - 1 : i;
                    if (this.swapXY) {
                        int z2 = x;
                        x = y;
                        y = z2;
                    }
                    if (this.storageType != 99) {
                        output = RomAttributeParser.parseIntegerValue((int)this.data[x][y].getBinValue(), this.endian, this.storageType);
                        for (z = 0; z < this.storageType; ++z) {
                            binData[offset * this.storageType + z + this.getStorageAddress() - this.ramOffset] = output[z];
                        }
                    } else {
                        output = RomAttributeParser.floatToByte((float)this.data[x][y].getBinValue(), this.endian);
                        for (z = 0; z < 4; ++z) {
                            binData[offset * 4 + z + this.getStorageAddress() - this.ramOffset] = output[z];
                        }
                    }
                    ++offset;
                }
            }
        }
        return binData;
    }

    @Override
    public void setRealValue(String realValue) {
        if (!this.locked && this.userLevel <= this.getSettings().getUserLevel()) {
            DataCell[][] dataCellArray = this.data;
            int n = dataCellArray.length;
            for (int i = 0; i < n; ++i) {
                DataCell[] column;
                for (DataCell cell : column = dataCellArray[i]) {
                    if (!cell.isSelected().booleanValue()) continue;
                    cell.setRealValue(realValue);
                }
            }
        } else if (this.userLevel > this.getSettings().getUserLevel()) {
            JOptionPane.showMessageDialog(this, "This table can only be modified by users with a userlevel of \n" + this.userLevel + " or greater. Click View->User Level to change your userlevel.", "Table cannot be modified", 1);
        }
        this.xAxis.setRealValue(realValue);
        this.yAxis.setRealValue(realValue);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.xAxis.addKeyListener(listener);
        this.yAxis.addKeyListener(listener);
        for (int x = 0; x < this.getSizeX(); ++x) {
            for (int y = 0; y < this.getSizeY(); ++y) {
                this.data[x][y].addKeyListener(listener);
            }
        }
    }

    public void selectCellAt(int y, Table1D axisType) {
        if (axisType.getType() == 5) {
            this.selectCellAt(0, y);
        } else {
            this.selectCellAt(y, 0);
        }
        ECUEditorManager.getECUEditor().getTableToolBar().updateTableToolBar(this);
    }

    public void deSelectCellAt(int x, int y) {
        this.clearSelection();
        this.data[x][y].setSelected(false);
        this.highlightX = x;
        this.highlightY = y;
    }

    public void selectCellAt(int x, int y) {
        this.clearSelection();
        this.data[x][y].setSelected(true);
        this.highlightX = x;
        this.highlightY = y;
    }

    public void selectCellAtWithoutClear(int x, int y) {
        this.data[x][y].setSelected(true);
        this.highlightX = x;
        this.highlightY = y;
    }

    @Override
    public void cursorUp() {
        if (this.highlightY > 0 && this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightX, this.highlightY - 1);
        } else if (this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.xAxis.selectCellAt(this.highlightX);
        } else {
            this.xAxis.cursorUp();
            this.yAxis.cursorUp();
        }
    }

    @Override
    public void cursorDown() {
        if (this.highlightY < this.getSizeY() - 1 && this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightX, this.highlightY + 1);
        } else {
            this.xAxis.cursorDown();
            this.yAxis.cursorDown();
        }
    }

    @Override
    public void cursorLeft() {
        if (this.highlightX > 0 && this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightX - 1, this.highlightY);
        } else if (this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.yAxis.selectCellAt(this.highlightY);
        } else {
            this.xAxis.cursorLeft();
            this.yAxis.cursorLeft();
        }
    }

    @Override
    public void cursorRight() {
        if (this.highlightX < this.getSizeX() - 1 && this.data[this.highlightX][this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightX + 1, this.highlightY);
        } else {
            this.xAxis.cursorRight();
            this.yAxis.cursorRight();
        }
    }

    @Override
    public void startHighlight(int x, int y) {
        this.xAxis.clearSelectedData();
        this.yAxis.clearSelectedData();
        super.startHighlight(x, y);
    }

    @Override
    public void copySelection() {
        Window ancestorWindow = SwingUtilities.getWindowAncestor(this);
        if (null != ancestorWindow) {
            ancestorWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        Launcher.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.copySelection3DWorker = new CopySelection3DWorker(this);
        this.copySelection3DWorker.execute();
    }

    @Override
    public void copyTable() {
        Window ancestorWindow = SwingUtilities.getWindowAncestor(this);
        if (null != ancestorWindow) {
            ancestorWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        Launcher.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.copyTable3DWorker = new CopyTable3DWorker(this);
        this.copyTable3DWorker.execute();
    }

    @Override
    public void paste() {
        StringTokenizer st = new StringTokenizer("");
        String input = "";
        try {
            input = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            st = new StringTokenizer(input);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String pasteType = st.nextToken();
        if ("[Table3D]".equalsIgnoreCase(pasteType)) {
            String newline = System.getProperty("line.separator");
            String xAxisValues = "[Table1D]" + newline + st.nextToken(newline);
            StringBuffer yAxisValues = new StringBuffer("[Table1D]" + newline + st.nextToken("\t"));
            StringBuffer dataValues = new StringBuffer("[Table3D]" + newline + st.nextToken("\t") + st.nextToken(newline));
            while (st.hasMoreTokens()) {
                yAxisValues.append("\t").append(st.nextToken("\t"));
                dataValues.append(newline).append(st.nextToken("\t")).append(st.nextToken(newline));
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(xAxisValues), null);
            this.xAxis.paste();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(String.valueOf(yAxisValues)), null);
            this.yAxis.paste();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(String.valueOf(dataValues)), null);
            this.pasteValues();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(input), null);
        } else if ("[Selection3D]".equalsIgnoreCase(pasteType)) {
            this.pasteValues();
        } else if ("[Selection1D]".equalsIgnoreCase(pasteType)) {
            this.xAxis.paste();
            this.yAxis.paste();
        }
    }

    public void pasteValues() {
        StringTokenizer st = new StringTokenizer("");
        String newline = System.getProperty("line.separator");
        try {
            String input = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            st = new StringTokenizer(input);
        }
        catch (UnsupportedFlavorException input) {
        }
        catch (IOException input) {
            // empty catch block
        }
        String pasteType = st.nextToken();
        int startX = 0;
        int startY = 0;
        if ("[Selection3D]".equalsIgnoreCase(pasteType)) {
            startX = this.highlightX;
            startY = this.highlightY;
        }
        for (int y = startY; y < this.getSizeY(); ++y) {
            if (!st.hasMoreTokens()) continue;
            StringTokenizer currentLine = new StringTokenizer(st.nextToken(newline));
            for (int x = startX; x < this.getSizeX(); ++x) {
                if (!currentLine.hasMoreTokens()) continue;
                String currentToken = currentLine.nextToken();
                try {
                    if (this.data[x][y].getText().equalsIgnoreCase(currentToken)) continue;
                    this.data[x][y].setRealValue(currentToken);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void verticalInterpolate() {
        int y;
        int x;
        int[] coords = new int[]{this.getSizeX(), this.getSizeY(), 0, 0};
        DataCell[][] tableData = this.get3dData();
        for (x = 0; x < this.getSizeX(); ++x) {
            for (y = 0; y < this.getSizeY(); ++y) {
                if (!tableData[x][y].isSelected().booleanValue()) continue;
                if (x < coords[0]) {
                    coords[0] = x;
                }
                if (x > coords[2]) {
                    coords[2] = x;
                }
                if (y < coords[1]) {
                    coords[1] = y;
                }
                if (y <= coords[3]) continue;
                coords[3] = y;
            }
        }
        if (coords[3] - coords[1] > 1) {
            for (y = coords[0]; y <= coords[2]; ++y) {
                double diff = (tableData[y][coords[1]].getRealValue() - tableData[y][coords[3]].getRealValue()) / (double)(coords[3] - coords[1]);
                if (!(Math.abs(diff) > 0.0)) continue;
                for (x = coords[1] + 1; x < coords[3]; ++x) {
                    tableData[y][x].setRealValue(String.valueOf(tableData[y][x - 1].getRealValue() - diff));
                }
            }
        }
        this.getYAxis().verticalInterpolate();
    }

    @Override
    public void horizontalInterpolate() {
        int y;
        int x;
        int[] coords = new int[]{this.getSizeX(), this.getSizeY(), 0, 0};
        DataCell[][] tableData = this.get3dData();
        for (x = 0; x < this.getSizeX(); ++x) {
            for (y = 0; y < this.getSizeY(); ++y) {
                if (!tableData[x][y].isSelected().booleanValue()) continue;
                if (x < coords[0]) {
                    coords[0] = x;
                }
                if (x > coords[2]) {
                    coords[2] = x;
                }
                if (y < coords[1]) {
                    coords[1] = y;
                }
                if (y <= coords[3]) continue;
                coords[3] = y;
            }
        }
        if (coords[2] - coords[0] > 1) {
            for (x = coords[1]; x <= coords[3]; ++x) {
                double diff = (tableData[coords[0]][x].getRealValue() - tableData[coords[2]][x].getRealValue()) / (double)(coords[2] - coords[0]);
                if (!(Math.abs(diff) > 0.0)) continue;
                for (y = coords[0] + 1; y < coords[2]; ++y) {
                    tableData[y][x].setRealValue(String.valueOf(tableData[y - 1][x].getRealValue() - diff));
                }
            }
        }
        this.getXAxis().horizontalInterpolate();
    }

    @Override
    public void interpolate() {
        this.verticalInterpolate();
        this.horizontalInterpolate();
    }

    @Override
    public boolean isLiveDataSupported() {
        return !ParamChecker.isNullOrEmpty(this.xAxis.getLogParam()) && !ParamChecker.isNullOrEmpty(this.yAxis.getLogParam());
    }

    @Override
    public boolean isButtonSelected() {
        return true;
    }

    @Override
    public void highlightLiveData(String liveValue) {
        if (this.getOverlayLog()) {
            int x = this.xAxis.getLiveDataIndex();
            int y = this.yAxis.getLiveDataIndex();
            DataCell cell = this.data[x][y];
            cell.setLiveDataTrace(true);
            cell.setLiveDataTraceValue(liveValue);
            this.getToolbar().setLiveDataValue(liveValue);
        }
    }

    @Override
    public void updateLiveDataHighlight() {
        if (this.getOverlayLog()) {
            int x = this.xAxis.getLiveDataIndex();
            int y = this.yAxis.getLiveDataIndex();
            this.data[x][y].setLiveDataTrace(true);
        }
    }

    @Override
    public void clearLiveDataTrace() {
        this.xAxis.clearLiveDataTrace();
        this.yAxis.clearLiveDataTrace();
        for (int x = 0; x < this.getSizeX(); ++x) {
            for (int y = 0; y < this.getSizeY(); ++y) {
                this.data[x][y].setLiveDataTrace(false);
            }
        }
    }

    public DataCell[][] get3dData() {
        return this.data;
    }

    @Override
    public void setCompareDisplay(int compareDisplay) {
        super.setCompareDisplay(compareDisplay);
        this.xAxis.setCompareDisplay(compareDisplay);
        this.yAxis.setCompareDisplay(compareDisplay);
    }

    @Override
    public void setCompareValueType(int compareValueType) {
        super.setCompareValueType(compareValueType);
        this.xAxis.setCompareValueType(compareValueType);
        this.yAxis.setCompareValueType(compareValueType);
    }

    @Override
    public void setCurrentScale(Scale curScale) {
        if (SettingsManager.getSettings().isScaleHeadersAndData()) {
            if (!this.xAxis.isStaticDataTable()) {
                try {
                    this.xAxis.setScaleByName(curScale.getName());
                }
                catch (NameNotFoundException e) {
                    try {
                        this.xAxis.setScaleByName(SettingsManager.getSettings().getDefaultScale());
                    }
                    catch (NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (!this.yAxis.isStaticDataTable()) {
                try {
                    this.yAxis.setScaleByName(curScale.getName());
                }
                catch (NameNotFoundException e) {
                    try {
                        this.yAxis.setScaleByName(SettingsManager.getSettings().getDefaultScale());
                    }
                    catch (NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        this.curScale = curScale;
        this.updateTableLabel();
        this.drawTable();
    }

    @Override
    public String getLogParamString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.xAxis.getLogParamString() + ", ");
        sb.append(this.yAxis.getLogParamString() + ", ");
        sb.append(this.getName() + ":" + this.getLogParam());
        return sb.toString();
    }

    @Override
    public void setOverlayLog(boolean overlayLog) {
        super.setOverlayLog(overlayLog);
        this.xAxis.setOverlayLog(overlayLog);
        this.yAxis.setOverlayLog(overlayLog);
        if (overlayLog) {
            this.xAxis.clearLiveDataTrace();
            this.yAxis.clearLiveDataTrace();
        }
    }

    @Override
    public boolean equals(Object other) {
        try {
            if (null == other) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof Table3D)) {
                return false;
            }
            Table3D otherTable = (Table3D)other;
            if (!(null == this.getName() && null == otherTable.getName() || this.getName().isEmpty() && otherTable.getName().isEmpty() || this.getName().equalsIgnoreCase(otherTable.getName()))) {
                return false;
            }
            if (!this.xAxis.equals(otherTable.xAxis)) {
                return false;
            }
            if (!this.yAxis.equals(otherTable.yAxis)) {
                return false;
            }
            if (this.data.length != otherTable.data.length || this.data[0].length != otherTable.data[0].length) {
                return false;
            }
            if (this.data.equals(otherTable.data)) {
                return true;
            }
            for (int i = 0; i < this.data.length; ++i) {
                for (int j = 0; j < this.data[i].length; ++j) {
                    if (this.data[i][j].equals(otherTable.data[i][j])) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        if (null != this.xAxis) {
            this.xAxis.repaint();
        }
        if (null != this.yAxis) {
            this.yAxis.repaint();
        }
    }
}

