/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.util.ByteUtil;
import com.romraider.util.HexUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class TableSwitch
extends Table {
    public static final String TYPE_SWITCH = "Switch";
    private static final long serialVersionUID = -4887718305447362308L;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final Map<String, byte[]> switchStates = new HashMap<String, byte[]>();
    private int dataSize = 0;

    public TableSwitch() {
        this.storageType = 1;
        this.type = 6;
        this.locked = true;
        this.removeAll();
        this.setLayout(new BorderLayout());
    }

    @Override
    public void horizontalInterpolate() {
    }

    @Override
    public void increment(double increment) {
    }

    @Override
    public void multiply(double factor) {
    }

    @Override
    public void setDataSize(int size) {
        if (this.dataSize == 0) {
            this.dataSize = size;
        }
    }

    @Override
    public int getDataSize() {
        return this.dataSize;
    }

    @Override
    public void populateTable(byte[] input, int romRamOffset) {
        JPanel radioPanel = new JPanel(new GridLayout(0, 1));
        radioPanel.add(new JLabel("  " + this.getName()));
        for (String string : this.switchStates.keySet()) {
            JRadioButton button = new JRadioButton(string);
            this.buttonGroup.add(button);
            radioPanel.add(button);
        }
        this.add((Component)radioPanel, "Center");
        if (!this.beforeRam) {
            this.ramOffset = romRamOffset;
        }
        HashMap<String, Integer> sourceStatus = new HashMap<String, Integer>();
        for (String stateName : this.switchStates.keySet()) {
            byte[] sourceData = new byte[this.dataSize];
            System.arraycopy(input, this.storageAddress - this.ramOffset, sourceData, 0, this.dataSize);
            int compareResult = ByteUtil.indexOfBytes(sourceData, this.getValues(stateName));
            if (compareResult == -1) {
                TableSwitch.getButtonByText(this.buttonGroup, stateName).setSelected(false);
            } else {
                TableSwitch.getButtonByText(this.buttonGroup, stateName).setSelected(true);
            }
            sourceStatus.put(stateName, compareResult);
        }
        for (String source : sourceStatus.keySet()) {
            if ((Integer)sourceStatus.get(source) == -1) continue;
            this.locked = false;
            break;
        }
        if (this.locked) {
            String string = String.format("Table: %s%nTable editing has been disabled.%nDefinition file or ROM image may be corrupt.", super.getName());
            JOptionPane.showMessageDialog(this, string, "ERROR - Data Mismatch", 0);
            TableSwitch.setButtonsUnselected(this.buttonGroup);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
        JTextArea descriptionArea = new JTextArea(description);
        descriptionArea.setOpaque(false);
        descriptionArea.setEditable(false);
        descriptionArea.setWrapStyleWord(true);
        descriptionArea.setLineWrap(true);
        descriptionArea.setMargin(new Insets(0, 5, 5, 5));
        this.add((Component)descriptionArea, "South");
    }

    @Override
    public byte[] saveFile(byte[] input) {
        if (!this.locked) {
            JRadioButton selectedButton = TableSwitch.getSelectedButton(this.buttonGroup);
            System.arraycopy(this.switchStates.get(selectedButton.getText()), 0, input, this.getStorageAddress() - this.ramOffset, this.dataSize);
        }
        return input;
    }

    public void setValues(String name, String input) {
        this.switchStates.put(name, HexUtil.asBytes(input));
    }

    public byte[] getValues(String key) {
        return this.switchStates.get(key);
    }

    public Dimension getFrameSize() {
        int minWidth;
        int height = this.verticalOverhead + 75;
        int width = this.horizontalOverhead;
        if (height < this.minHeight) {
            height = this.minHeight;
        }
        int n = minWidth = this.isLiveDataSupported() ? this.minWidthOverlay : this.minWidthNoOverlay;
        if (width < minWidth) {
            width = minWidth;
        }
        return new Dimension(width, height);
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public Map<String, byte[]> getSwitchStates() {
        return this.switchStates;
    }

    @Override
    public void cursorUp() {
    }

    @Override
    public void cursorDown() {
    }

    @Override
    public void cursorLeft() {
    }

    @Override
    public void cursorRight() {
    }

    @Override
    public boolean isLiveDataSupported() {
        return false;
    }

    @Override
    public boolean isButtonSelected() {
        return this.buttonGroup.getSelection() != null;
    }

    @Override
    public boolean equals(Object other) {
        try {
            HashSet<byte[]> otherValues;
            if (null == other) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof TableSwitch)) {
                return false;
            }
            TableSwitch otherTable = (TableSwitch)other;
            if (!(null == this.getName() && null == otherTable.getName() || this.getName().isEmpty() && otherTable.getName().isEmpty() || this.getName().equalsIgnoreCase(otherTable.getName()))) {
                return false;
            }
            if (this.getDataSize() != otherTable.getDataSize()) {
                return false;
            }
            if (this.getSwitchStates() == otherTable.getSwitchStates()) {
                return true;
            }
            HashSet<String> keys = new HashSet<String>(this.getSwitchStates().keySet());
            HashSet<String> otherKeys = new HashSet<String>(otherTable.getSwitchStates().keySet());
            if (keys.size() != otherKeys.size()) {
                return false;
            }
            if (!keys.containsAll(otherKeys)) {
                return false;
            }
            HashSet<byte[]> values = new HashSet<byte[]>(this.getSwitchStates().values());
            if (values.equals(otherValues = new HashSet<byte[]>(otherTable.getSwitchStates().values()))) {
                return true;
            }
            for (String key : keys) {
                JRadioButton button = TableSwitch.getButtonByText(this.getButtonGroup(), key);
                JRadioButton otherButton = TableSwitch.getButtonByText(otherTable.getButtonGroup(), key);
                if (button.isSelected() == otherButton.isSelected()) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void populateCompareValues(Table compareTable) {
    }

    @Override
    public void calcCellRanges() {
    }

    @Override
    public void drawTable() {
    }

    @Override
    public void updateTableLabel() {
    }

    @Override
    public void setCurrentScale(Scale curScale) {
    }

    private static JRadioButton getSelectedButton(ButtonGroup group) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (b.getModel() != group.getSelection()) continue;
            return b;
        }
        return null;
    }

    private static void setButtonsUnselected(ButtonGroup group) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            b.setSelected(false);
            b.setEnabled(false);
        }
    }

    private static JRadioButton getButtonByText(ButtonGroup group, String text) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (!b.getText().equalsIgnoreCase(text)) continue;
            return b;
        }
        return null;
    }
}

