/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.maps.DataCell;
import com.romraider.maps.Table;
import com.romraider.xml.RomAttributeParser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import javax.swing.JOptionPane;

public abstract class TableWithData
extends Table {
    public void setData(DataCell[] data) {
        this.data = data;
    }

    public DataCell getDataCell(int location) {
        return this.data[location];
    }

    @Override
    public void horizontalInterpolate() {
        double diff;
        int y;
        int[] coords = new int[]{this.getDataSize(), 0};
        DataCell[] tableData = this.getData();
        for (y = 0; y < this.getDataSize(); ++y) {
            if (!tableData[y].isSelected().booleanValue()) continue;
            if (y < coords[0]) {
                coords[0] = y;
            }
            if (y <= coords[1]) continue;
            coords[1] = y;
        }
        if (coords[1] - coords[0] > 1 && Math.abs(diff = (tableData[coords[0]].getRealValue() - tableData[coords[1]].getRealValue()) / (double)(coords[1] - coords[0])) > 0.0) {
            for (y = coords[0] + 1; y < coords[1]; ++y) {
                this.data[y].setRealValue(String.valueOf(tableData[y - 1].getRealValue() - diff));
            }
        }
    }

    public void selectCellAt(int y) {
        if (y >= 0 && y < this.data.length) {
            this.clearSelection();
            this.data[y].setSelected(true);
            this.highlightY = y;
            ECUEditorManager.getECUEditor().getTableToolBar().updateTableToolBar(this);
        }
    }

    public Dimension getFrameSize() {
        int minWidth;
        int height = this.verticalOverhead + this.cellHeight;
        int width = this.horizontalOverhead + this.data.length * this.cellWidth;
        if (height < this.minHeight) {
            height = this.minHeight;
        }
        int n = minWidth = this.isLiveDataSupported() ? this.minWidthOverlay : this.minWidthNoOverlay;
        if (width < minWidth) {
            width = minWidth;
        }
        return new Dimension(width, height);
    }

    @Override
    public void increment(double increment) {
        if (!this.locked && this.userLevel <= this.getSettings().getUserLevel()) {
            for (DataCell cell : this.data) {
                if (!cell.isSelected().booleanValue()) continue;
                cell.increment(increment);
            }
        } else if (this.userLevel > this.getSettings().getUserLevel()) {
            JOptionPane.showMessageDialog(this, "This table can only be modified by users with a userlevel of \n" + this.userLevel + " or greater. Click View->User Level to change your userlevel.", "Table cannot be modified", 1);
        }
    }

    @Override
    public void multiply(double factor) {
        if (!this.locked && this.userLevel <= this.getSettings().getUserLevel()) {
            for (DataCell cell : this.data) {
                if (!cell.isSelected().booleanValue()) continue;
                cell.multiply(factor);
            }
        } else if (this.userLevel > this.getSettings().getUserLevel()) {
            JOptionPane.showMessageDialog(this, "This table can only be modified by users with a userlevel of \n" + this.userLevel + " or greater. Click View->User Level to change your userlevel.", "Table cannot be modified", 1);
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        super.addKeyListener(listener);
        for (DataCell cell : this.data) {
            for (int z = 0; z < this.storageType; ++z) {
                cell.addKeyListener(listener);
            }
        }
    }

    @Override
    public void drawTable() {
        for (DataCell cell : this.data) {
            if (null == cell) continue;
            cell.drawCell();
        }
    }

    @Override
    public byte[] saveFile(byte[] binData) {
        if (this.userLevel <= this.getSettings().getUserLevel() && (this.userLevel < 5 || this.getSettings().isSaveDebugTables())) {
            for (int i = 0; i < this.data.length; ++i) {
                int z;
                byte[] output;
                if (this.storageType != 99) {
                    output = RomAttributeParser.parseIntegerValue((int)this.data[i].getBinValue(), this.endian, this.storageType);
                    for (z = 0; z < this.storageType; ++z) {
                        binData[i * this.storageType + z + this.getStorageAddress() - this.ramOffset] = output[z];
                    }
                    continue;
                }
                output = RomAttributeParser.floatToByte((float)this.data[i].getBinValue(), this.endian);
                for (z = 0; z < 4; ++z) {
                    binData[i * 4 + z + this.getStorageAddress() - this.ramOffset] = output[z];
                }
            }
        }
        return binData;
    }

    @Override
    public void populateTable(byte[] input, int romRamOffset) {
        boolean tempLock = this.locked;
        this.locked = false;
        if (!this.beforeRam) {
            this.ramOffset = romRamOffset;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != null) continue;
            double dataValue = 0.0;
            if (this.storageType == 99) {
                byte[] byteValue = new byte[]{input[this.getStorageAddress() + i * 4 - this.ramOffset], input[this.getStorageAddress() + i * 4 - this.ramOffset + 1], input[this.getStorageAddress() + i * 4 - this.ramOffset + 2], input[this.getStorageAddress() + i * 4 - this.ramOffset + 3]};
                dataValue = RomAttributeParser.byteToFloat(byteValue, this.endian);
            } else {
                dataValue = RomAttributeParser.parseByteValue(input, this.endian, this.getStorageAddress() + i * this.storageType - this.ramOffset, this.storageType, this.signed);
            }
            this.data[i] = new DataCell(this, dataValue, 0, i);
            this.data[i].setPreferredSize(new Dimension(this.cellWidth, this.cellHeight));
            this.centerPanel.add(this.data[i]);
            if (!tempLock) continue;
            this.data[i].setForeground(Color.GRAY);
        }
        this.locked = tempLock;
        this.calcCellRanges();
    }
}

