/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.net;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.log4j.Logger;

public class BrowserControl {
    private static final Logger LOGGER = Logger.getLogger(BrowserControl.class);
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    private BrowserControl() {
        throw new UnsupportedOperationException();
    }

    public static void displayURL(String url) {
        try {
            Class<?> display = Class.forName("java.awt.Desktop");
            Object getDesktopMethod = display.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            Method browseMethod = display.getDeclaredMethod("browse", URI.class);
            browseMethod.invoke(getDesktopMethod, new URI(url));
        }
        catch (Exception e) {
            LOGGER.debug("Failed to display URL via java.awt.Desktop. Calling by OS depended method.", e);
            BrowserControl.displayURLtraditional(url);
        }
    }

    private static void displayURLtraditional(String url) {
        block6: {
            boolean windows = BrowserControl.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Runtime.getRuntime().exec(cmd);
                    break block6;
                }
                cmd = "netscape -remote openURL(" + url + ")";
                Process p = Runtime.getRuntime().exec(cmd);
                try {
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        cmd = "netscape " + url;
                        Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (InterruptedException x) {
                    LOGGER.error("Error bringing up browser, command=" + cmd, x);
                }
            }
            catch (IOException x) {
                LOGGER.error("Could not invoke browser, command=" + cmd, x);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }
}

