/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.Settings;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.maps.Rom;
import com.romraider.maps.Table;
import com.romraider.swing.TableTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CompareImagesForm
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -8937472127815934398L;
    private final Vector<Rom> roms;
    private final JPanel contentPane;
    private final JComboBox comboBoxImageLeft;
    private final JComboBox comboBoxImageRight;
    private final JButton btnCompare;
    private final JList listChanges;
    private final DefaultListModel listModelChanges = new DefaultListModel();
    private final ChangeListCellRenderer changeRenderer = new ChangeListCellRenderer();
    private final JScrollPane scrollPaneResults;
    private final JLabel lblImageResultString;

    public CompareImagesForm(Vector<Rom> roms, Image parentImage) {
        this.setIconImage(parentImage);
        this.setResizable(false);
        this.roms = roms;
        this.setTitle("Compare Images");
        this.setBounds(100, 100, 600, 450);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        JLabel lblSelectImages = new JLabel("Selected Images");
        lblSelectImages.setBounds(10, 11, 79, 14);
        this.contentPane.setLayout(null);
        JPanel panelImageSelector = new JPanel();
        panelImageSelector.setBounds(10, 36, 574, 94);
        panelImageSelector.setBorder(new EtchedBorder(1, null, null));
        panelImageSelector.setLayout(null);
        this.comboBoxImageLeft = new JComboBox();
        this.comboBoxImageLeft.setBounds(10, 7, 554, 20);
        this.comboBoxImageLeft.setToolTipText("Select an image to compare.");
        this.comboBoxImageLeft.setRenderer(new ComboBoxRenderer());
        panelImageSelector.add(this.comboBoxImageLeft);
        this.comboBoxImageRight = new JComboBox();
        this.comboBoxImageRight.setBounds(10, 32, 554, 20);
        this.comboBoxImageRight.setToolTipText("Select an image to compare.");
        this.comboBoxImageRight.setRenderer(new ComboBoxRenderer());
        panelImageSelector.add(this.comboBoxImageRight);
        this.btnCompare = new JButton("Compare");
        this.btnCompare.addActionListener(this);
        this.btnCompare.setBounds(10, 64, 89, 23);
        panelImageSelector.add(this.btnCompare);
        this.contentPane.add(panelImageSelector);
        this.contentPane.add(lblSelectImages);
        JLabel lblResults = new JLabel("Results:");
        lblResults.setBounds(10, 141, 46, 14);
        this.contentPane.add(lblResults);
        this.lblImageResultString = new JLabel("Compare images...");
        this.lblImageResultString.setBounds(66, 141, 518, 14);
        this.contentPane.add(this.lblImageResultString);
        this.scrollPaneResults = new JScrollPane();
        this.scrollPaneResults.setBounds(10, 166, 574, 245);
        this.contentPane.add(this.scrollPaneResults);
        this.listChanges = new JList(this.listModelChanges);
        this.scrollPaneResults.setViewportView(this.listChanges);
        this.listChanges.setCellRenderer(this.changeRenderer);
        this.listChanges.setSelectionMode(2);
        this.listChanges.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting()) {
                    ListItem selectedTableName = (ListItem)CompareImagesForm.this.listChanges.getSelectedValue();
                    String tableName = selectedTableName.getValue();
                    Rom leftRom = (Rom)CompareImagesForm.this.comboBoxImageLeft.getSelectedItem();
                    Rom rightRom = (Rom)CompareImagesForm.this.comboBoxImageRight.getSelectedItem();
                    TableTreeNode leftNode = CompareImagesForm.this.findAndShowTable(leftRom, tableName);
                    TableTreeNode rightNode = CompareImagesForm.this.findAndShowTable(rightRom, tableName);
                    if (leftNode != null && rightNode != null) {
                        leftNode.getFrame().compareByTable(rightNode.getTable());
                        for (int i = 0; i < leftNode.getFrame().getTableMenuBar().getSimilarOpenTables().getItemCount(); ++i) {
                            JMenuItem leftItem = leftNode.getFrame().getTableMenuBar().getSimilarOpenTables().getItem(i);
                            String romFileName = leftItem.getText();
                            if (!rightRom.getFileName().equalsIgnoreCase(romFileName)) continue;
                            leftItem.setSelected(true);
                            break;
                        }
                    }
                }
            }
        });
        this.populateComboBoxes();
    }

    private TableTreeNode findAndShowTable(Rom rom, String tableName) {
        for (TableTreeNode node : rom.getTableNodes()) {
            if (node == null || !node.getTable().getName().equals(tableName)) continue;
            ECUEditorManager.getECUEditor().displayTable(node.getFrame());
            return node;
        }
        return null;
    }

    public void populateComboBoxes() {
        for (int i = 0; i < this.roms.size(); ++i) {
            Rom curRom = this.roms.get(i);
            this.comboBoxImageLeft.addItem(curRom);
            this.comboBoxImageRight.addItem(curRom);
        }
        if (this.comboBoxImageRight.getItemCount() > 1) {
            this.comboBoxImageRight.setSelectedIndex(1);
        }
    }

    public void compareTables(Rom left, Rom right) {
        Boolean found;
        this.listModelChanges.clear();
        int equal = 0;
        int different = 0;
        int missing = 0;
        for (TableTreeNode leftNode : left.getTableNodes()) {
            found = false;
            Table leftTable = leftNode.getTable();
            for (TableTreeNode rightNode : right.getTableNodes()) {
                Table rightTable = rightNode.getTable();
                if (!leftTable.getName().equalsIgnoreCase(rightTable.getName())) continue;
                if (leftTable.equals(rightTable)) {
                    ++equal;
                    this.listModelChanges.addElement(new ListItem(1, leftTable.getName()));
                } else {
                    ++different;
                    this.listModelChanges.addElement(new ListItem(2, leftTable.getName()));
                }
                found = true;
                break;
            }
            if (found.booleanValue()) continue;
            ++missing;
            this.listModelChanges.addElement(new ListItem(3, leftTable.getName()));
        }
        for (TableTreeNode rightFrame : right.getTableNodes()) {
            found = false;
            for (TableTreeNode leftFrame : left.getTableNodes()) {
                if (!leftFrame.getTable().getName().equalsIgnoreCase(rightFrame.getTable().getName())) continue;
                found = true;
                break;
            }
            if (found.booleanValue()) continue;
            ++missing;
            this.listModelChanges.addElement(new ListItem(3, rightFrame.getTable().getName()));
        }
        if (equal > 0 && different == 0 && missing == 0) {
            this.lblImageResultString.setText("Images are equal.");
            this.lblImageResultString.setForeground(Settings.TABLE_EQUAL_COLOR);
        } else if (different > 0) {
            this.lblImageResultString.setText("Images are NOT equal.  Equal Tables: " + equal + ", Changed Tables: " + different + ", Missing Tables: " + missing);
            this.lblImageResultString.setForeground(Settings.TABLE_DIFFERENT_COLOR);
        } else {
            this.lblImageResultString.setText("Images are NOT equal.  Equal Tables: " + equal + ", Changed Tables: " + different + ", Missing Tables: " + missing);
            this.lblImageResultString.setForeground(Settings.TABLE_MISSING_COLOR);
        }
        if (this.listModelChanges.size() < 1) {
            this.listModelChanges.addElement(new ListItem(0, "No tables are equal, different, or missing."));
            this.lblImageResultString.setText("Unable to compare images.");
            this.lblImageResultString.setForeground(Color.RED);
            return;
        }
        if (equal == 0) {
            this.listModelChanges.addElement(new ListItem(1, "No Equal Tables."));
        }
        if (different == 0) {
            this.listModelChanges.addElement(new ListItem(2, "No Changed Tables."));
        }
        if (missing == 0) {
            this.listModelChanges.addElement(new ListItem(3, "No Missing Tables."));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (e.getSource() == this.btnCompare && this.comboBoxImageLeft.getItemCount() > 0 && this.comboBoxImageRight.getItemCount() > 0) {
            Rom leftRom = (Rom)this.comboBoxImageLeft.getSelectedItem();
            Rom rightRom = (Rom)this.comboBoxImageRight.getSelectedItem();
            if (leftRom != null && rightRom != null) {
                this.compareTables(leftRom, rightRom);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    class ListItem {
        private int type;
        private String value;

        public ListItem(int type, String value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class ChangeListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -3645192077787635239L;

        public ChangeListCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList paramList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(paramList.getSelectionBackground());
            } else {
                this.setBackground(paramList.getBackground());
            }
            ListItem item = (ListItem)value;
            switch (item.getType()) {
                case 1: {
                    this.setForeground(Settings.TABLE_EQUAL_COLOR);
                    break;
                }
                case 2: {
                    this.setForeground(Settings.TABLE_DIFFERENT_COLOR);
                    break;
                }
                case 3: {
                    this.setForeground(Settings.TABLE_MISSING_COLOR);
                    break;
                }
                default: {
                    this.setForeground(paramList.getForeground());
                }
            }
            this.setText(item.getValue());
            return this;
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 831689602429105854L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null) {
                Rom rom = (Rom)value;
                this.setText(rom.getFileName());
                this.setFont(list.getFont());
            }
            return this;
        }
    }
}

