/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.swing.XMLFilter;
import com.romraider.util.SettingsManager;
import com.rusefi.Launcher;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;

public class DefinitionManager
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -3920843496218196737L;
    public static int MOVE_UP = 0;
    public static int MOVE_DOWN = 1;
    Vector<String> fileNames;
    private JButton btnAddDefinition;
    private JButton btnApply;
    private JButton btnCancel;
    private JButton btnMoveDown;
    private JButton btnMoveUp;
    private JButton btnRemoveDefinition;
    private JButton btnSave;
    private JButton btnUndo;
    private JLabel defLabel;
    private JList definitionList;
    private JScrollPane jScrollPane1;

    public DefinitionManager() {
        this.setIconImage(Launcher.getFrame().getIconImage());
        this.initComponents();
        this.initSettings();
        this.definitionList.setFont(new Font("Tahoma", 0, 11));
        this.definitionList.setSelectionMode(0);
        this.btnCancel.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.btnAddDefinition.addActionListener(this);
        this.btnRemoveDefinition.addActionListener(this);
        this.btnMoveUp.addActionListener(this);
        this.btnMoveDown.addActionListener(this);
        this.btnApply.addActionListener(this);
        this.btnUndo.addActionListener(this);
    }

    private void initSettings() {
        Vector<File> definitionFiles = SettingsManager.getSettings().getEcuDefinitionFiles();
        this.fileNames = new Vector();
        for (File definitionFile : definitionFiles) {
            this.fileNames.add(definitionFile.getAbsolutePath());
        }
        this.updateListModel();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.definitionList = new JList();
        this.defLabel = new JLabel();
        this.btnMoveUp = new JButton();
        this.btnMoveDown = new JButton();
        this.btnAddDefinition = new JButton();
        this.btnRemoveDefinition = new JButton();
        this.btnSave = new JButton();
        this.btnCancel = new JButton();
        this.btnApply = new JButton();
        this.btnUndo = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Definition File Manager");
        this.jScrollPane1.setViewportView(this.definitionList);
        this.defLabel.setText("ECU Definition File Priority");
        this.btnMoveUp.setText("Move Up");
        this.btnMoveDown.setText("Move Down");
        this.btnAddDefinition.setText("Add...");
        this.btnRemoveDefinition.setText("Remove");
        this.btnSave.setText("Save");
        this.btnCancel.setText("Cancel");
        this.btnApply.setText("Apply");
        this.btnUndo.setText("Undo");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jScrollPane1, -1, 448, Short.MAX_VALUE).add(2, layout.createSequentialGroup().add(layout.createParallelGroup(2).add(layout.createSequentialGroup().add(this.btnSave).addPreferredGap(0).add(this.btnApply).addPreferredGap(0).add(this.btnUndo).addPreferredGap(0).add(this.btnCancel)).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(this.defLabel).add(layout.createSequentialGroup().add(this.btnMoveDown).addPreferredGap(0).add(this.btnMoveUp))).addPreferredGap(0, 80, Short.MAX_VALUE).add(this.btnAddDefinition))).addPreferredGap(0).add(this.btnRemoveDefinition))).addContainerGap()));
        layout.linkSize(new Component[]{this.btnAddDefinition, this.btnMoveDown, this.btnMoveUp, this.btnRemoveDefinition}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.defLabel).addPreferredGap(0).add(this.jScrollPane1, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.btnMoveUp).add(this.btnMoveDown).add(this.btnRemoveDefinition, -2, 23, -2).add(this.btnAddDefinition)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.btnSave).add(this.btnApply).add(this.btnUndo).add(this.btnCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnCancel) {
            this.dispose();
        } else if (e.getSource() == this.btnSave) {
            this.saveSettings();
            this.dispose();
        } else if (e.getSource() == this.btnApply) {
            this.saveSettings();
        } else if (e.getSource() == this.btnMoveUp) {
            this.moveSelection(MOVE_UP);
        } else if (e.getSource() == this.btnMoveDown) {
            this.moveSelection(MOVE_DOWN);
        } else if (e.getSource() == this.btnAddDefinition) {
            this.addFile();
        } else if (e.getSource() == this.btnRemoveDefinition) {
            this.removeSelection();
        } else if (e.getSource() == this.btnUndo) {
            this.initSettings();
        }
    }

    public void saveSettings() {
        Vector<File> output = new Vector<File>();
        for (int i = 0; i < this.fileNames.size(); ++i) {
            output.add(new File(this.fileNames.get(i)));
        }
        SettingsManager.getSettings().setEcuDefinitionFiles(output);
    }

    public void addFile() {
        JFileChooser fc = new JFileChooser("./");
        fc.setFileFilter(new XMLFilter());
        if (fc.showOpenDialog(this) == 0) {
            this.fileNames.add(fc.getSelectedFile().getAbsolutePath());
            this.updateListModel();
        }
    }

    public void moveSelection(int direction) {
        int selectedIndex = this.definitionList.getSelectedIndex();
        String fileName = this.fileNames.get(selectedIndex);
        if (direction == MOVE_UP && selectedIndex > 0) {
            this.fileNames.remove(selectedIndex);
            this.fileNames.add(--selectedIndex, fileName);
        } else if (direction == MOVE_DOWN && selectedIndex < this.definitionList.getModel().getSize()) {
            this.fileNames.remove(selectedIndex);
            this.fileNames.add(++selectedIndex, fileName);
        }
        this.updateListModel();
        this.definitionList.setSelectedIndex(selectedIndex);
    }

    public void removeSelection() {
        int index = this.definitionList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.fileNames.remove(index);
        this.updateListModel();
    }

    public void updateListModel() {
        this.definitionList.setListData(this.fileNames);
    }
}

