/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.Settings;
import com.romraider.Version;
import com.romraider.editor.ecu.ECUEditor;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.maps.Rom;
import com.romraider.maps.Table;
import com.romraider.swing.CompareImagesForm;
import com.romraider.swing.ECUImageFilter;
import com.romraider.swing.RomPropertyPanel;
import com.romraider.swing.SettingsForm;
import com.romraider.swing.TableTreeNode;
import com.romraider.util.SettingsManager;
import com.rusefi.Launcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class ECUEditorMenuBar
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = -4777040428837855236L;
    private final JMenuItem refreshImage = new JMenuItem("Refresh Image");
    private final JMenu editMenu = new JMenu("Edit");
    private final JMenuItem settings = new JMenuItem("RomRaider Settings...");
    private final JMenuItem compareImages = new JMenuItem("Compare Images...");
    private final JMenu convertRom = new JMenu("Convert Image");
    private final JMenuItem convertIncrease = new JMenuItem("160KB --> 192KB...");
    private final JMenuItem convertDecrease = new JMenuItem("192KB --> 160KB...");
    private final ButtonGroup convertGroup = new ButtonGroup();
    private final JMenu viewMenu = new JMenu("View");
    private final JMenuItem romProperties = new JMenuItem("ECU Image Properties");
    private final ButtonGroup levelGroup = new ButtonGroup();
    private final JMenu levelMenu = new JMenu("User Level");
    private final JRadioButtonMenuItem level1 = new JRadioButtonMenuItem("1 Beginner");
    private final JRadioButtonMenuItem level2 = new JRadioButtonMenuItem("2 Intermediate");
    private final JRadioButtonMenuItem level3 = new JRadioButtonMenuItem("3 Advanced");
    private final JRadioButtonMenuItem level4 = new JRadioButtonMenuItem("4 Highest");
    private final JRadioButtonMenuItem level5 = new JRadioButtonMenuItem("5 Debug Mode");
    private final JMenuItem launchRamTuneTestApp = new JMenuItem("Launch Test App...");
    private final JMenu helpMenu = new JMenu("Help");
    private final JMenuItem about = new JMenuItem("About RomRaider");

    public ECUEditorMenuBar() {
        this.add(this.editMenu);
        this.editMenu.setMnemonic('E');
        this.editMenu.add(this.settings);
        this.settings.addActionListener(this);
        this.settings.setMnemonic('S');
        this.editMenu.add(this.compareImages);
        this.compareImages.addActionListener(this);
        this.compareImages.setMnemonic('C');
        this.editMenu.add(this.convertRom);
        this.convertRom.setMnemonic('O');
        this.convertRom.add(this.convertIncrease);
        this.convertIncrease.addActionListener(this);
        this.convertIncrease.setMnemonic('I');
        this.convertRom.add(this.convertDecrease);
        this.convertDecrease.addActionListener(this);
        this.convertDecrease.setMnemonic('D');
        this.convertGroup.add(this.convertIncrease);
        this.convertGroup.add(this.convertDecrease);
        this.add(this.viewMenu);
        this.viewMenu.setMnemonic('V');
        this.viewMenu.add(this.romProperties);
        this.romProperties.addActionListener(this);
        this.romProperties.setMnemonic('P');
        this.viewMenu.add(this.levelMenu);
        this.levelMenu.setMnemonic('U');
        this.levelMenu.add(this.level1);
        this.level1.addActionListener(this);
        this.level1.setMnemonic('1');
        this.levelMenu.add(this.level2);
        this.level2.addActionListener(this);
        this.level2.setMnemonic('2');
        this.levelMenu.add(this.level3);
        this.level3.addActionListener(this);
        this.level3.setMnemonic('3');
        this.levelMenu.add(this.level4);
        this.level4.addActionListener(this);
        this.level4.setMnemonic('4');
        this.levelMenu.add(this.level5);
        this.level5.addActionListener(this);
        this.level5.setMnemonic('5');
        this.levelGroup.add(this.level1);
        this.levelGroup.add(this.level2);
        this.levelGroup.add(this.level3);
        this.levelGroup.add(this.level4);
        this.levelGroup.add(this.level5);
        if (this.getSettings().getUserLevel() == 1) {
            this.level1.setSelected(true);
        } else if (this.getSettings().getUserLevel() == 2) {
            this.level2.setSelected(true);
        } else if (this.getSettings().getUserLevel() == 3) {
            this.level3.setSelected(true);
        } else if (this.getSettings().getUserLevel() == 4) {
            this.level4.setSelected(true);
        } else if (this.getSettings().getUserLevel() == 5) {
            this.level5.setSelected(true);
        }
        this.launchRamTuneTestApp.addActionListener(this);
        this.launchRamTuneTestApp.setMnemonic('L');
        this.add(this.helpMenu);
        this.helpMenu.setMnemonic('H');
        this.helpMenu.add(this.about);
        this.about.addActionListener(this);
        this.about.setMnemonic('A');
        this.updateMenu();
    }

    public void updateMenu() {
        String file = this.getLastSelectedRomFileName();
        if ("".equals(file)) {
            this.romProperties.setEnabled(false);
            this.compareImages.setEnabled(false);
            this.convertRom.setEnabled(false);
        } else {
            this.romProperties.setEnabled(true);
            this.compareImages.setEnabled(true);
            this.convertRom.setEnabled(true);
        }
        this.refreshImage.setText("Refresh " + file);
        this.romProperties.setText(file + "Properties");
        int lastSelectedRomSize = 0;
        Rom lastSelectedRom = ECUEditorManager.getECUEditor().getLastSelectedRom();
        if (null != lastSelectedRom) {
            lastSelectedRomSize = lastSelectedRom.getRealFileSize();
        }
        if (163840 == lastSelectedRomSize) {
            this.convertIncrease.setEnabled(true);
            this.convertDecrease.setEnabled(false);
        } else if (196608 == lastSelectedRomSize) {
            this.convertIncrease.setEnabled(false);
            this.convertDecrease.setEnabled(true);
        } else {
            this.convertIncrease.setEnabled(false);
            this.convertDecrease.setEnabled(false);
        }
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ECUEditor parent = ECUEditorManager.getECUEditor();
        if (e.getSource() == this.romProperties) {
            JOptionPane.showMessageDialog(Launcher.getFrame(), new RomPropertyPanel(parent.getLastSelectedRom()), parent.getLastSelectedRom().getRomIDString() + " Properties", 1);
        } else if (e.getSource() == this.settings) {
            SettingsForm form = new SettingsForm();
            form.setLocationRelativeTo(Launcher.getFrame());
            form.setVisible(true);
        } else if (e.getSource() == this.compareImages) {
            CompareImagesForm form = new CompareImagesForm(parent.getImages(), Launcher.getFrame().getIconImage());
            form.setLocationRelativeTo(Launcher.getFrame());
            form.setVisible(true);
        } else if (e.getSource() == this.level1) {
            parent.setUserLevel(1);
        } else if (e.getSource() == this.level2) {
            parent.setUserLevel(2);
        } else if (e.getSource() == this.level3) {
            parent.setUserLevel(3);
        } else if (e.getSource() == this.level4) {
            parent.setUserLevel(4);
        } else if (e.getSource() == this.level5) {
            parent.setUserLevel(5);
        } else if (e.getSource() == this.about) {
            String message = "RomRaider - ECU Editor\nVersion: 0.5.8 RC 1 for rusEfi\nBuild #: 635\nhttp://www.rusefi.com";
            String title = "About RomRaider";
            JOptionPane.showMessageDialog(Launcher.getFrame(), message, title, 1, Version.ABOUT_ICON);
        }
    }

    public void saveImage() throws Exception {
        File selectedFile;
        Rom lastSelectedRom = ECUEditorManager.getECUEditor().getLastSelectedRom();
        if (lastSelectedRom != null && null != (selectedFile = this.getImageOutputFile())) {
            byte[] output = lastSelectedRom.saveFile();
            this.writeImage(output, selectedFile);
        }
    }

    private File getImageOutputFile() throws Exception {
        ECUEditor parent = ECUEditorManager.getECUEditor();
        JFileChooser fc = new JFileChooser(SettingsManager.getSettings().getLastImageDir());
        fc.setFileFilter(new ECUImageFilter());
        if (fc.showSaveDialog(Launcher.getFrame()) == 0) {
            int option;
            File selectedFile = fc.getSelectedFile();
            if (selectedFile.exists() && ((option = JOptionPane.showConfirmDialog(Launcher.getFrame(), selectedFile.getName() + " already exists! Overwrite?")) == 2 || option == 1)) {
                return null;
            }
            return selectedFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImage(byte[] output, File selectedFile) throws Exception {
        ECUEditor parent = ECUEditorManager.getECUEditor();
        try (FileOutputStream fos = new FileOutputStream(selectedFile);){
            fos.write(output);
        }
        parent.getLastSelectedRom().setFullFileName(selectedFile.getAbsoluteFile().getName());
        parent.setLastSelectedRom(parent.getLastSelectedRom());
        SettingsManager.getSettings().setLastImageDir(selectedFile.getParentFile());
    }

    private File getRepositoryOutputDir() {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(this.getSettings().getLastRepositoryDir());
        fc.setDialogTitle("Select Repository Directory");
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showSaveDialog(Launcher.getFrame()) == 0) {
            int option;
            File selectedDir = fc.getSelectedFile();
            if (selectedDir.exists() && ((option = JOptionPane.showConfirmDialog(Launcher.getFrame(), selectedDir.getName() + " already exists! Overwrite?")) == 2 || option == 1)) {
                return null;
            }
            return selectedDir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsRepository() throws Exception {
        File selectedDir = this.getRepositoryOutputDir();
        String separator = System.getProperty("file.separator");
        if (null != selectedDir) {
            for (TableTreeNode treeNode : ECUEditorManager.getECUEditor().getLastSelectedRom().getTableNodes()) {
                Table table = treeNode.getTable();
                String category = table.getCategory();
                String tableName = table.getName();
                String tableDirString = selectedDir.getAbsolutePath() + separator + category;
                File tableDir = new File(tableDirString.replace('/', '-'));
                tableDir.mkdirs();
                String tableFileString = tableDir.getAbsolutePath() + separator + tableName + ".txt";
                File tableFile = new File(tableFileString.replace('/', '-'));
                if (tableFile.exists()) {
                    tableFile.delete();
                }
                tableFile.createNewFile();
                StringBuffer tableData = table.getTableAsString();
                BufferedWriter out = new BufferedWriter(new FileWriter(tableFile));
                try {
                    out.write(tableData.toString());
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.getSettings().setLastRepositoryDir(selectedDir);
        }
    }

    private void increaseRomSize() throws Exception {
        File selectedFile;
        Rom lastSelectedRom = ECUEditorManager.getECUEditor().getLastSelectedRom();
        if (lastSelectedRom != null && null != (selectedFile = this.getImageOutputFile())) {
            if (lastSelectedRom.getRealFileSize() != 163840) {
                JOptionPane.showMessageDialog(Launcher.getFrame(), "Error converting image.  Image size is invalid.");
            } else {
                byte[] output = lastSelectedRom.saveFile();
                byte[] incOutput = new byte[196608];
                System.arraycopy(output, 0, incOutput, 0, 131072);
                System.arraycopy(output, 131072, incOutput, 163840, 32768);
                for (int i = 131072; i < 163840; ++i) {
                    incOutput[i] = 0;
                }
                this.writeImage(incOutput, selectedFile);
            }
        }
    }

    private void decreaseRomSize() throws Exception {
        File selectedFile;
        Rom lastSelectedRom = ECUEditorManager.getECUEditor().getLastSelectedRom();
        if (lastSelectedRom != null && null != (selectedFile = this.getImageOutputFile())) {
            if (lastSelectedRom.getRealFileSize() != 196608) {
                JOptionPane.showMessageDialog(Launcher.getFrame(), "Error converting image.  Image size is invalid.");
            } else {
                byte[] output = lastSelectedRom.saveFile();
                byte[] decOutput = new byte[163840];
                System.arraycopy(output, 0, decOutput, 0, 131072);
                System.arraycopy(output, 163840, decOutput, 131072, 32768);
                this.writeImage(decOutput, selectedFile);
            }
        }
    }

    private String getLastSelectedRomFileName() {
        Rom lastSelectedRom = ECUEditorManager.getECUEditor().getLastSelectedRom();
        return lastSelectedRom == null ? "" : lastSelectedRom.getFileName() + " ";
    }

    private Settings getSettings() {
        return SettingsManager.getSettings();
    }
}

