/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.Settings;
import com.romraider.editor.ecu.ECUEditor;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.maps.Rom;
import com.romraider.util.SettingsManager;
import com.rusefi.ConfigurationImage;
import com.rusefi.binaryprotocol.BinaryProtocolCmd;
import com.rusefi.io.CommandQueue;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class ECUEditorToolBar
extends JToolBar {
    private static final long serialVersionUID = 7778170684606193919L;
    private final JButton uploadImage = new JButton();
    private final JButton downloadImage = new JButton();
    private final JButton burnImage = new JButton();

    public ECUEditorToolBar(String name) {
        super(name);
        this.setFloatable(true);
        this.setRollover(true);
        FlowLayout toolBarLayout = new FlowLayout(0, 0, 0);
        this.setLayout(toolBarLayout);
        this.updateIcons();
        this.add(this.downloadImage);
        this.add(this.uploadImage);
        this.add(this.burnImage);
        this.uploadImage.setToolTipText("Send changes to controller");
        this.downloadImage.setToolTipText("Read configuration from controller");
        this.downloadImage.setMaximumSize(new Dimension(50, 50));
        this.downloadImage.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), BorderFactory.createLineBorder(new Color(150, 150, 150), 0)));
        this.uploadImage.setMaximumSize(new Dimension(50, 50));
        this.uploadImage.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 0));
        this.updateButtons();
        this.uploadImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rom lastSelectedRom = ECUEditorManager.getECUEditor().getLastSelectedRom();
                byte[] newVersion = ConfigurationImage.extractContent(lastSelectedRom.saveFile());
                System.out.println("new version size: " + newVersion.length);
                BinaryProtocolCmd.scheduleUpload(new ConfigurationImage(newVersion));
            }
        });
        this.downloadImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.burnImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandQueue.getInstance().write("writeconfig");
            }
        });
    }

    public void updateIcons() {
        int iconScale = this.getSettings().getEditorIconScale();
        this.uploadImage.setIcon(this.rescaleImageIcon(new ImageIcon(this.getClass().getResource("/com/rusefi/upload48.jpg")), iconScale));
        this.downloadImage.setIcon(this.rescaleImageIcon(new ImageIcon(this.getClass().getResource("/com/rusefi/download48.jpg")), iconScale));
        this.burnImage.setIcon(this.rescaleImageIcon(new ImageIcon(this.getClass().getResource("/com/rusefi/writeconfig48.jpg")), iconScale));
        this.repaint();
    }

    private ImageIcon rescaleImageIcon(ImageIcon imageIcon, int percentOfOriginal) {
        int newHeight = (int)((double)imageIcon.getImage().getHeight(this) * ((double)percentOfOriginal * 0.01));
        int newWidth = (int)((double)imageIcon.getImage().getWidth(this) * ((double)percentOfOriginal * 0.01));
        if (newHeight > 0 && newWidth > 0) {
            imageIcon.setImage(imageIcon.getImage().getScaledInstance(newWidth, newHeight, 4));
        }
        return imageIcon;
    }

    public void updateButtons() {
        this.revalidate();
    }

    private Settings getSettings() {
        return SettingsManager.getSettings();
    }

    private ECUEditor getEditor() {
        return ECUEditorManager.getECUEditor();
    }
}

