/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.maps.Rom;
import com.romraider.maps.Table;
import com.romraider.swing.TableChooserTreeNode;
import com.romraider.swing.TableTreeNode;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class JTableChooser
extends JOptionPane
implements MouseListener {
    private static final long serialVersionUID = 5611729002131147882L;
    JPanel displayPanel = new JPanel();
    DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Open Images");
    JTree displayTree = new JTree(this.rootNode);
    JScrollPane displayScrollPane;

    public Table showChooser(Table targetTable) {
        Vector<Rom> roms = ECUEditorManager.getECUEditor().getImages();
        int nameLength = 0;
        for (int i = 0; i < roms.size(); ++i) {
            Rom rom = roms.get(i);
            DefaultMutableTreeNode romNode = new DefaultMutableTreeNode(rom.getFileName());
            this.rootNode.add(romNode);
            for (TableTreeNode tableTreeNode : rom.getTableNodes()) {
                Table table = tableTreeNode.getTable();
                if (table.getName().length() > nameLength) {
                    nameLength = table.getName().length();
                }
                TableChooserTreeNode tableNode = new TableChooserTreeNode(table.getName(), table);
                boolean categoryExists = false;
                for (int k = 0; k < romNode.getChildCount(); ++k) {
                    if (!romNode.getChildAt(k).toString().equalsIgnoreCase(table.getCategory())) continue;
                    ((DefaultMutableTreeNode)romNode.getChildAt(k)).add(tableNode);
                    categoryExists = true;
                    break;
                }
                if (categoryExists) continue;
                DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(table.getCategory());
                romNode.add(categoryNode);
                categoryNode.add(tableNode);
            }
        }
        this.displayTree.setPreferredSize(new Dimension(nameLength * 7, 400));
        this.displayTree.setMinimumSize(new Dimension(nameLength * 7, 400));
        this.displayTree.expandPath(new TreePath(this.rootNode.getPath()));
        this.displayTree.setRootVisible(false);
        this.displayTree.addMouseListener(this);
        this.displayScrollPane = new JScrollPane(this.displayTree);
        this.displayScrollPane.setVerticalScrollBarPolicy(22);
        this.displayPanel.add(this.displayScrollPane);
        Object[] values = new Object[]{"Compare", "Cancel"};
        if (JTableChooser.showOptionDialog(SwingUtilities.windowForComponent(targetTable), this.displayPanel, "Select a Map", -1, -1, null, values, values[0]) == 0 && this.displayTree.getLastSelectedPathComponent() instanceof TableChooserTreeNode) {
            return ((TableChooserTreeNode)this.displayTree.getLastSelectedPathComponent()).getTable();
        }
        return null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.displayTree.setPreferredSize(new Dimension(this.displayTree.getWidth(), this.displayTree.getRowCount() * this.displayTree.getRowHeight()));
        this.displayTree.revalidate();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

