/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.util.Platform;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public final class LookAndFeelManager {
    private static final Logger LOGGER = Logger.getLogger(LookAndFeelManager.class);

    private LookAndFeelManager() {
        throw new UnsupportedOperationException();
    }

    public static void initLookAndFeel() {
        try {
            if (Platform.isPlatform("Mac OS X")) {
                System.setProperty("apple.awt.rendering", "true");
                System.setProperty("apple.awt.brushMetalLook", "true");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("apple.awt.window.position.forceSafeCreation", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "RomRaider");
            }
            UIManager.setLookAndFeel(LookAndFeelManager.getLookAndFeel());
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        catch (Exception ex) {
            LOGGER.error("Error loading system look and feel.", ex);
        }
    }

    private static String getLookAndFeel() {
        if (Platform.isPlatform("Linux")) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        return UIManager.getSystemLookAndFeelClassName();
    }
}

