/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.Settings;
import com.romraider.editor.ecu.ECUEditor;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.swing.MDIDesktopManager;
import com.romraider.swing.TableFrame;
import com.romraider.util.SettingsManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class MDIDesktopPane
extends JDesktopPane {
    private static final long serialVersionUID = -1839360490978587035L;
    private final MDIDesktopManager manager = new MDIDesktopManager(this);

    public MDIDesktopPane() {
        this.setDesktopManager(this.manager);
        this.setDragMode(1);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.checkDesktopSize();
    }

    public Component add(JInternalFrame frame) {
        Point p;
        if (SettingsManager.getSettings().isAlwaysOpenTableAtZero()) {
            p = new Point(0, 0);
        } else if (this.getAllFrames().length > 0) {
            JInternalFrame selectedFrame = this.getSelectedFrame();
            p = null == selectedFrame || !selectedFrame.isVisible() ? this.getAllFrames()[0].getLocation() : selectedFrame.getLocation();
            p.x += Settings.FRAME_OFFSET;
            p.y += Settings.FRAME_OFFSET;
        } else {
            p = new Point(0, 0);
        }
        Component retval = super.add(frame);
        frame.setLocation(p.x, p.y);
        this.checkDesktopSize();
        if (frame.isResizable()) {
            int w = this.getWidth() - this.getWidth() / 3;
            int h = this.getHeight() - this.getHeight() / 3;
            if ((double)w < frame.getMinimumSize().getWidth()) {
                w = (int)frame.getMinimumSize().getWidth();
            }
            if ((double)h < frame.getMinimumSize().getHeight()) {
                h = (int)frame.getMinimumSize().getHeight();
            }
            frame.setSize(w, h);
        }
        this.moveToFront(frame);
        frame.setVisible(true);
        if (frame instanceof TableFrame) {
            this.getEditor().getTableToolBar().updateTableToolBar();
            ((TableFrame)frame).RegisterTable();
        }
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            frame.toBack();
        }
        return retval;
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        this.getEditor().getTableToolBar().updateTableToolBar();
        this.checkDesktopSize();
    }

    public ECUEditor getEditor() {
        return ECUEditorManager.getECUEditor();
    }

    public void cascadeFrames() {
        int x = 0;
        int y = 0;
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height - 5 - allFrames.length * Settings.FRAME_OFFSET;
        int frameWidth = this.getBounds().width - 5 - allFrames.length * Settings.FRAME_OFFSET;
        for (int i = allFrames.length - 1; i >= 0; --i) {
            allFrames[i].setSize(frameWidth, frameHeight);
            allFrames[i].setLocation(x, y);
            x += Settings.FRAME_OFFSET;
            y += Settings.FRAME_OFFSET;
        }
    }

    public void tileFrames() {
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height / allFrames.length;
        int y = 0;
        for (int i = 0; i < allFrames.length; ++i) {
            allFrames[i].setSize(this.getBounds().width, frameHeight);
            allFrames[i].setLocation(0, y);
            y += frameHeight;
        }
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }
}

