/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.maps.Rom;
import com.romraider.maps.Table;
import com.romraider.swing.TableFrame;
import com.romraider.swing.TableTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class RomCellRenderer
implements TreeCellRenderer {
    JLabel fileName;
    JLabel carInfo;
    DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

    public RomCellRenderer() {
        this.fileName = new JLabel(" ");
        this.fileName.setFont(new Font("Tahoma", 1, 11));
        this.fileName.setHorizontalAlignment(0);
        this.carInfo = new JLabel(" ");
        this.carInfo.setFont(new Font("Tahoma", 0, 10));
        this.carInfo.setHorizontalAlignment(0);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component returnValue = null;
        if (value != null && value instanceof Rom) {
            Rom rom = (Rom)value;
            if (expanded) {
                this.fileName.setText("- " + rom.getFileName());
            } else {
                this.fileName.setText("+ " + rom.getFileName());
            }
            this.carInfo.setText(rom.getRomIDString());
            JPanel renderer = new JPanel(new GridLayout(2, 1));
            renderer.add(this.fileName);
            renderer.add(this.carInfo);
            if (selected) {
                renderer.setBackground(new Color(220, 220, 255));
                renderer.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 225)));
            } else {
                renderer.setBorder(BorderFactory.createLineBorder(new Color(220, 0, 0)));
                renderer.setBackground(new Color(255, 210, 210));
            }
            renderer.setPreferredSize(new Dimension(tree.getParent().getWidth(), 30));
            renderer.setMaximumSize(new Dimension(tree.getParent().getWidth(), 30));
            renderer.setEnabled(tree.isEnabled());
            returnValue = renderer;
        } else if (value != null && value instanceof TableTreeNode) {
            Table table = ((TableFrame)((DefaultMutableTreeNode)value).getUserObject()).getTable();
            JPanel renderer = new JPanel(new GridLayout(1, 1));
            renderer.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            JLabel tableName = new JLabel("");
            renderer.setBackground(Color.WHITE);
            if (table.getType() == 1) {
                tableName = new JLabel(table.getName() + " ", new ImageIcon(this.getClass().getResource("/graphics/1d.gif")), 2);
            } else if (table.getType() == 2) {
                tableName = new JLabel(table.getName() + " ", new ImageIcon(this.getClass().getResource("/graphics/2d.gif")), 2);
            } else if (table.getType() == 3) {
                tableName = new JLabel(table.getName() + " ", new ImageIcon(this.getClass().getResource("/graphics/3d.gif")), 2);
            } else if (table.getType() == 6) {
                tableName = new JLabel(table.getName() + " ", new ImageIcon(this.getClass().getResource("/graphics/switch.gif")), 2);
            }
            renderer.add(tableName);
            tableName.setFont(new Font("Tahoma", 0, 11));
            if (selected) {
                renderer.setBackground(new Color(220, 220, 255));
                renderer.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 225)));
            }
            if (table.getUserLevel() == 5) {
                tableName.setForeground(new Color(255, 150, 150));
                tableName.setFont(new Font("Tahoma", 2, 11));
            } else if (table.getUserLevel() > table.getSettings().getUserLevel()) {
                tableName.setFont(new Font("Tahoma", 2, 11));
            }
            returnValue = renderer;
        }
        if (returnValue == null) {
            returnValue = this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        return returnValue;
    }
}

