/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.editor.ecu.ECUEditor;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.maps.Rom;
import com.romraider.swing.CategoryTreeNode;
import com.romraider.swing.RomCellRenderer;
import com.romraider.swing.TableTreeNode;
import com.romraider.util.SettingsManager;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class RomTree
extends JTree
implements MouseListener {
    private static final long serialVersionUID = 1630446543383498886L;

    public RomTree(DefaultMutableTreeNode input) {
        super(input);
        this.setRootVisible(false);
        this.setRowHeight(0);
        this.addMouseListener(this);
        this.setCellRenderer(new RomCellRenderer());
        this.setFont(new Font("Tahoma", 0, 11));
        AbstractAction tableSelectAction = new AbstractAction(){
            private static final long serialVersionUID = -6008026264821746092L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object selectedRow = RomTree.this.getSelectionPath().getLastPathComponent();
                    RomTree.this.showTable(selectedRow);
                    RomTree.this.setLastSelectedRom(selectedRow);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        };
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "space");
        this.getActionMap().put("enter", tableSelectAction);
        this.getActionMap().put("space", tableSelectAction);
    }

    public ECUEditor getEditor() {
        return ECUEditorManager.getECUEditor();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath treePath = this.getPathForLocation(e.getX(), e.getY());
        if (treePath == null) {
            return;
        }
        Object selectedRow = treePath.getLastPathComponent();
        if (selectedRow instanceof Rom) {
            return;
        }
        try {
            if (selectedRow instanceof TableTreeNode) {
                if (e.getClickCount() >= SettingsManager.getSettings().getTableClickCount()) {
                    this.showTable(selectedRow);
                }
            } else if ((selectedRow instanceof Rom || selectedRow instanceof CategoryTreeNode) && e.getClickCount() >= SettingsManager.getSettings().getTableClickCount()) {
                if (this.isCollapsed(this.getRowForLocation(e.getX(), e.getY()))) {
                    this.expandRow(this.getRowForLocation(e.getX(), e.getY()));
                } else {
                    this.collapseRow(this.getRowForLocation(e.getX(), e.getY()));
                }
            }
            this.setLastSelectedRom(selectedRow);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void showTable(Object selectedRow) {
        try {
            TableTreeNode node;
            if (selectedRow instanceof TableTreeNode && null != (node = (TableTreeNode)selectedRow)) {
                this.getEditor().displayTable(node.getFrame());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void setLastSelectedRom(Object selectedNode) {
        Rom node;
        Object lastSelectedPathComponent;
        if ((selectedNode instanceof TableTreeNode || selectedNode instanceof CategoryTreeNode || selectedNode instanceof Rom) && (lastSelectedPathComponent = this.getLastSelectedPathComponent()) instanceof Rom && null != (node = (Rom)lastSelectedPathComponent)) {
            this.getEditor().setLastSelectedRom(node);
        }
        this.getEditor().refreshUI();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

