/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.maps.Scale;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public final class ScalesTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -5967359776053559125L;
    private static final String[] colNames = new String[]{"Name", "Expression", "Byte Expression", "Unit", "Format", "Coarse", "Fine", "Min", "Max"};
    private Vector<Scale> scales;

    @Override
    public final int getColumnCount() {
        return colNames.length;
    }

    @Override
    public final String getColumnName(int column) {
        return colNames[column].toString();
    }

    @Override
    public final Object getValueAt(int row, int column) {
        if (null != this.scales) {
            Scale scale = this.scales.get(row);
            switch (column) {
                case 0: {
                    return scale.getName();
                }
                case 1: {
                    return scale.getExpression();
                }
                case 2: {
                    return scale.getByteExpression();
                }
                case 3: {
                    return scale.getUnit();
                }
                case 4: {
                    return scale.getFormat();
                }
                case 5: {
                    return scale.getCoarseIncrement();
                }
                case 6: {
                    return scale.getFineIncrement();
                }
                case 7: {
                    return scale.getMin();
                }
                case 8: {
                    return scale.getMax();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public final int getRowCount() {
        return null != this.scales ? this.scales.size() : 0;
    }

    public final Class<? extends Object> getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    @Override
    public final boolean isCellEditable(int row, int column) {
        return false;
    }

    public final void setScalesList(Vector<Scale> scales) {
        this.scales = scales;
    }
}

