/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import ZoeloeSoft.projects.JFontChooser.JFontChooser;
import com.romraider.Settings;
import com.romraider.editor.ecu.ECUEditor;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.swing.TableFrame;
import com.romraider.util.SettingsManager;
import com.rusefi.Launcher;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class SettingsForm
extends JFrame
implements MouseListener {
    private static final long serialVersionUID = 3910602424260147767L;
    private JLabel axisColor;
    private JButton btnAddAssocs;
    private JButton btnApply;
    private JButton btnCancel;
    private JButton btnChooseFont;
    private JButton btnOk;
    private JButton btnRemoveAssocs;
    private JCheckBox calcConflictWarning;
    private JTextField cellHeight;
    private JTextField cellWidth;
    private JCheckBox debug;
    private JLabel decreaseColor;
    private JCheckBox displayHighTables;
    private JCheckBox extensionBin;
    private JCheckBox extensionHex;
    private JLabel highlightColor;
    private JLabel selectColor;
    private JLabel increaseColor;
    private JLabel labelTableClick;
    private JLabel lblClickBehavior;
    private JTabbedPane settingsTabbedPane;
    private JPanel jPanelDefault;
    private JPanel jPanelClipboard;
    private JPanel jPanelTableDisplay;
    private JPanel jPanelIcons;
    private JPanel jPanelScale;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel lblAxis;
    private JLabel lblCellHeight;
    private JLabel lblCellWidth;
    private JLabel lblDecrease;
    private JLabel lblFont;
    private JLabel lblHighlight;
    private JLabel lblSelect;
    private JLabel lblIncrease;
    private JLabel lblMax;
    private JLabel lblMin;
    private JLabel lblWarning;
    private JLabel maxColor;
    private JLabel minColor;
    private JCheckBox obsoleteWarning;
    private JButton reset;
    private JCheckBox saveDebugTables;
    private JComboBox tableClickCount;
    private JCheckBox valueLimitWarning;
    private JCheckBox chckbxColorAxis;
    private JLabel warningColor;
    private ButtonGroup clipboardButtonGroup;
    private JRadioButton rdbtnDefault;
    private JRadioButton rdbtnAirboys;
    private JRadioButton rdbtnCustom;
    private JPanel editorIconsPanel;
    private JPanel tableIconsPanel;
    private JTextField textFieldTableIconScale;
    private JTextField textFieldEditorIconScale;
    private JCheckBox chckbxShowTableToolbar;
    private JCheckBox chckbxOpenRomNode;
    private JPanel panelTreeSettings;
    private JComboBox tableClickBehavior;
    private JCheckBox chckbxOpenTablesAt;
    private JTextField defaultScale;
    private JComboBox comboBoxDefaultScale;
    private JCheckBox cbScaleHeaderAndData;

    public SettingsForm() {
        this.setIconImage(Launcher.getFrame().getIconImage());
        this.initComponents();
        this.initSettings();
        this.maxColor.addMouseListener(this);
        this.minColor.addMouseListener(this);
        this.highlightColor.addMouseListener(this);
        this.selectColor.addMouseListener(this);
        this.axisColor.addMouseListener(this);
        this.increaseColor.addMouseListener(this);
        this.decreaseColor.addMouseListener(this);
        this.warningColor.addMouseListener(this);
        this.btnOk.addMouseListener(this);
        this.btnApply.addMouseListener(this);
        this.btnCancel.addMouseListener(this);
        this.btnChooseFont.addMouseListener(this);
        this.reset.addMouseListener(this);
        this.btnAddAssocs.addMouseListener(this);
        this.btnRemoveAssocs.addMouseListener(this);
        this.tableClickCount.setBackground(Color.WHITE);
        this.tableClickBehavior.setBackground(Color.WHITE);
        StringTokenizer osName = new StringTokenizer(System.getProperties().getProperty("os.name"));
        if (!osName.nextToken().equalsIgnoreCase("windows")) {
            this.btnAddAssocs.setEnabled(false);
            this.btnRemoveAssocs.setEnabled(false);
            this.extensionHex.setEnabled(false);
            this.extensionBin.setEnabled(false);
        }
    }

    private void initSettings() {
        Settings settings = this.getSettings();
        this.obsoleteWarning.setSelected(settings.isObsoleteWarning());
        this.calcConflictWarning.setSelected(settings.isCalcConflictWarning());
        this.displayHighTables.setSelected(settings.isDisplayHighTables());
        this.saveDebugTables.setSelected(settings.isSaveDebugTables());
        this.debug.setSelected(settings.isDebug());
        this.maxColor.setBackground(settings.getMaxColor());
        this.minColor.setBackground(settings.getMinColor());
        this.highlightColor.setBackground(settings.getHighlightColor());
        this.selectColor.setBackground(settings.getSelectColor());
        this.axisColor.setBackground(settings.getAxisColor());
        this.increaseColor.setBackground(settings.getIncreaseBorder());
        this.decreaseColor.setBackground(settings.getDecreaseBorder());
        this.cellWidth.setText((int)settings.getCellSize().getWidth() + "");
        this.cellHeight.setText((int)settings.getCellSize().getHeight() + "");
        this.btnChooseFont.setFont(settings.getTableFont());
        this.btnChooseFont.setText(settings.getTableFont().getFontName());
        if (settings.getTableClickCount() == 1) {
            this.tableClickCount.setSelectedIndex(0);
        } else {
            this.tableClickCount.setSelectedIndex(1);
        }
        if (1 == settings.getTableClickBehavior()) {
            this.tableClickBehavior.setSelectedIndex(1);
        } else {
            this.tableClickBehavior.setSelectedIndex(0);
        }
        this.valueLimitWarning.setSelected(settings.isValueLimitWarning());
        this.warningColor.setBackground(settings.getWarningColor());
        this.chckbxColorAxis.setSelected(settings.isColorAxis());
        this.defaultScale.setText(settings.getDefaultScale());
        if (settings.getTableClipboardFormat().equalsIgnoreCase("Airboys")) {
            this.rdbtnAirboys.setSelected(true);
        } else if (settings.getTableClipboardFormat().equalsIgnoreCase("Custom")) {
            this.rdbtnCustom.setSelected(true);
        } else {
            this.rdbtnDefault.setSelected(true);
        }
        this.textFieldEditorIconScale.setText(String.valueOf(settings.getEditorIconScale()));
        this.textFieldTableIconScale.setText(String.valueOf(settings.getTableIconScale()));
        this.chckbxShowTableToolbar.setSelected(settings.isShowTableToolbarBorder());
        this.chckbxOpenRomNode.setSelected(settings.isOpenExpanded());
        this.chckbxOpenTablesAt.setSelected(settings.isAlwaysOpenTableAtZero());
        if (settings.getDefaultScale().equalsIgnoreCase(Settings.DEFAULT_SCALE)) {
            this.comboBoxDefaultScale.setSelectedItem(Settings.DEFAULT_SCALE);
        } else if (settings.getDefaultScale().equalsIgnoreCase(Settings.METRIC_SCALE)) {
            this.comboBoxDefaultScale.setSelectedItem(Settings.METRIC_SCALE);
        } else if (settings.getDefaultScale().equalsIgnoreCase(Settings.STANDARD_SCALE)) {
            this.comboBoxDefaultScale.setSelectedItem(Settings.STANDARD_SCALE);
        } else {
            this.comboBoxDefaultScale.setSelectedIndex(0);
        }
        this.cbScaleHeaderAndData.setSelected(settings.isScaleHeadersAndData());
    }

    private void initComponents() {
        this.obsoleteWarning = new JCheckBox();
        this.calcConflictWarning = new JCheckBox();
        this.debug = new JCheckBox();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.btnApply = new JButton();
        this.reset = new JButton();
        this.settingsTabbedPane = new JTabbedPane();
        this.jPanelClipboard = new JPanel();
        this.jPanelDefault = new JPanel();
        this.jPanelTableDisplay = new JPanel();
        this.jPanelIcons = new JPanel();
        this.jPanelScale = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblAxis = new JLabel();
        this.lblHighlight = new JLabel();
        this.lblSelect = new JLabel();
        this.lblMin = new JLabel();
        this.lblMax = new JLabel();
        this.maxColor = new JLabel();
        this.minColor = new JLabel();
        this.highlightColor = new JLabel();
        this.selectColor = new JLabel();
        this.axisColor = new JLabel();
        this.warningColor = new JLabel();
        this.lblWarning = new JLabel();
        this.jPanel3 = new JPanel();
        this.lblIncrease = new JLabel();
        this.increaseColor = new JLabel();
        this.decreaseColor = new JLabel();
        this.lblDecrease = new JLabel();
        this.lblCellHeight = new JLabel();
        this.cellHeight = new JTextField();
        this.cellWidth = new JTextField();
        this.lblCellWidth = new JLabel();
        this.lblFont = new JLabel();
        this.btnChooseFont = new JButton();
        this.saveDebugTables = new JCheckBox();
        this.displayHighTables = new JCheckBox();
        this.valueLimitWarning = new JCheckBox();
        this.chckbxColorAxis = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.extensionHex = new JCheckBox();
        this.extensionBin = new JCheckBox();
        this.btnAddAssocs = new JButton();
        this.btnRemoveAssocs = new JButton();
        this.editorIconsPanel = new JPanel();
        this.tableIconsPanel = new JPanel();
        this.tableClickBehavior = new JComboBox();
        this.labelTableClick = new JLabel();
        this.tableClickCount = new JComboBox();
        this.defaultScale = new JTextField();
        this.comboBoxDefaultScale = new JComboBox();
        this.cbScaleHeaderAndData = new JCheckBox();
        this.clipboardButtonGroup = new ButtonGroup();
        this.rdbtnDefault = new JRadioButton("RomRaider Default");
        this.rdbtnAirboys = new JRadioButton("Airboys Spreadsheet");
        this.rdbtnCustom = new JRadioButton("Custom (manually specify formats in settings.xml)");
        this.clipboardButtonGroup.add(this.rdbtnDefault);
        this.clipboardButtonGroup.add(this.rdbtnAirboys);
        this.clipboardButtonGroup.add(this.rdbtnCustom);
        this.setDefaultCloseOperation(2);
        this.setTitle("RomRaider Settings");
        this.setCursor(new Cursor(0));
        this.setFont(new Font("Tahoma", 0, 12));
        this.obsoleteWarning.setText("Warn me when opening out of date ECU image revision");
        this.obsoleteWarning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.obsoleteWarning.setMargin(new Insets(0, 0, 0, 0));
        this.calcConflictWarning.setText("Warn me when real and byte value calculations conflict");
        this.calcConflictWarning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.calcConflictWarning.setMargin(new Insets(0, 0, 0, 0));
        this.debug.setText("Debug mode");
        this.debug.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.debug.setEnabled(false);
        this.debug.setMargin(new Insets(0, 0, 0, 0));
        this.btnCancel.setMnemonic('C');
        this.btnCancel.setText("Cancel");
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("OK");
        this.btnApply.setMnemonic('A');
        this.btnApply.setText("Apply");
        this.reset.setText("Restore Defaults");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Background"));
        this.lblAxis.setText("Axis Cell:");
        this.lblHighlight.setText("Highlighted Cell:");
        this.lblSelect.setText("Selected Cell:");
        this.lblMin.setText("Minimum Value:");
        this.lblMax.setText("Maximum Value:");
        this.maxColor.setBackground(new Color(255, 0, 0));
        this.maxColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.maxColor.setOpaque(true);
        this.minColor.setBackground(new Color(255, 0, 0));
        this.minColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.minColor.setOpaque(true);
        this.highlightColor.setBackground(new Color(255, 0, 0));
        this.highlightColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.highlightColor.setOpaque(true);
        this.selectColor.setBackground(new Color(255, 0, 0));
        this.selectColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.selectColor.setOpaque(true);
        this.axisColor.setBackground(new Color(255, 0, 0));
        this.axisColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.axisColor.setOpaque(true);
        this.warningColor.setBackground(new Color(255, 0, 0));
        this.warningColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.warningColor.setOpaque(true);
        this.lblWarning.setText("Warning:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblWarning).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(4).addComponent(this.lblMin)).addComponent(this.lblMax))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.maxColor, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 139, Short.MAX_VALUE).addComponent(this.lblHighlight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highlightColor, -2, 50, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.minColor, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 172, Short.MAX_VALUE).addComponent(this.lblAxis)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.warningColor, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 151, Short.MAX_VALUE).addComponent(this.lblSelect))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectColor, -1, -1, Short.MAX_VALUE).addComponent(this.axisColor, -2, 50, -2)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMax).addComponent(this.maxColor, -2, 15, -2).addComponent(this.highlightColor, -2, 15, -2).addComponent(this.lblHighlight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMin).addComponent(this.minColor, -2, 15, -2).addComponent(this.axisColor, -2, 15, -2).addComponent(this.lblAxis)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.warningColor, -2, 15, -2).addComponent(this.lblWarning)).addComponent(this.selectColor, -1, 20, Short.MAX_VALUE).addComponent(this.lblSelect)).addContainerGap()));
        this.jPanel2.setLayout(jPanel2Layout);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Cell Borders"));
        this.lblIncrease.setText("Increased:");
        this.increaseColor.setBackground(new Color(255, 0, 0));
        this.increaseColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.increaseColor.setOpaque(true);
        this.decreaseColor.setBackground(new Color(255, 0, 0));
        this.decreaseColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.decreaseColor.setOpaque(true);
        this.lblDecrease.setText("Decreased:");
        this.lblCellHeight.setText("Cell Height:");
        this.lblCellWidth.setText("Cell Width:");
        this.lblFont.setText("Font:");
        this.btnChooseFont.setText("Choose");
        this.saveDebugTables.setText("Save changes made on tables in debug mode");
        this.saveDebugTables.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveDebugTables.setMargin(new Insets(0, 0, 0, 0));
        this.displayHighTables.setText("List tables that are above my userlevel");
        this.displayHighTables.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.displayHighTables.setMargin(new Insets(0, 0, 0, 0));
        this.valueLimitWarning.setText("Warn when values exceed limits");
        this.valueLimitWarning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.valueLimitWarning.setMargin(new Insets(0, 0, 0, 0));
        this.chckbxColorAxis.setText("Color Axis");
        this.chckbxColorAxis.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chckbxColorAxis.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("File Associations"));
        this.extensionHex.setText("HEX");
        this.extensionHex.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.extensionHex.setMargin(new Insets(0, 0, 0, 0));
        this.extensionBin.setText("BIN");
        this.extensionBin.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.extensionBin.setMargin(new Insets(0, 0, 0, 0));
        this.btnAddAssocs.setText("Add Associations");
        this.btnRemoveAssocs.setText("Remove Associations");
        this.initTabs();
        this.settingsTabbedPane.addTab("General", this.jPanelDefault);
        this.settingsTabbedPane.addTab("Table Display", this.jPanelTableDisplay);
        this.settingsTabbedPane.addTab("Clipboard", this.jPanelClipboard);
        this.settingsTabbedPane.addTab("Icons", this.jPanelIcons);
        this.settingsTabbedPane.addTab("Scale", this.jPanelScale);
        this.cbScaleHeaderAndData = new JCheckBox("Scale Headers and Data.");
        this.cbScaleHeaderAndData.setToolTipText("If checked, the header scale will change when the data scale is selected.  Otherwise click on a header row or column to select the scale.");
        JLabel lblDefaultScale = new JLabel("Default Scale:");
        this.comboBoxDefaultScale.setModel(new DefaultComboBoxModel<String>(new String[]{Settings.DEFAULT_SCALE, Settings.METRIC_SCALE, Settings.STANDARD_SCALE}));
        GroupLayout gl_jPanelScale = new GroupLayout(this.jPanelScale);
        gl_jPanelScale.setHorizontalGroup(gl_jPanelScale.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_jPanelScale.createSequentialGroup().addContainerGap().addGroup(gl_jPanelScale.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbScaleHeaderAndData).addGroup(gl_jPanelScale.createSequentialGroup().addComponent(lblDefaultScale).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxDefaultScale, -2, -1, -2))).addContainerGap(277, Short.MAX_VALUE)));
        gl_jPanelScale.setVerticalGroup(gl_jPanelScale.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_jPanelScale.createSequentialGroup().addContainerGap().addGroup(gl_jPanelScale.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblDefaultScale).addComponent(this.comboBoxDefaultScale, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbScaleHeaderAndData).addContainerGap(453, Short.MAX_VALUE)));
        this.jPanelScale.setLayout(gl_jPanelScale);
        this.editorIconsPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.getContentPane());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsTabbedPane, GroupLayout.Alignment.TRAILING, -2, 432, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.reset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 136, Short.MAX_VALUE).addComponent(this.btnApply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.settingsTabbedPane, -2, 542, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk).addComponent(this.btnApply).addComponent(this.reset)).addContainerGap()));
        this.getContentPane().setLayout(layout);
        this.pack();
    }

    private void initTabs() {
        JPanel panelUISettings = new JPanel();
        panelUISettings.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "UI Settings", 4, 2, null, null));
        GroupLayout jPanelDefaultLayout = new GroupLayout(this.jPanelDefault);
        jPanelDefaultLayout.setHorizontalGroup(jPanelDefaultLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDefaultLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDefaultLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(panelUISettings, -1, 407, Short.MAX_VALUE).addComponent(this.obsoleteWarning).addComponent(this.calcConflictWarning).addComponent(this.debug)).addContainerGap()));
        jPanelDefaultLayout.setVerticalGroup(jPanelDefaultLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDefaultLayout.createSequentialGroup().addContainerGap().addComponent(this.obsoleteWarning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calcConflictWarning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(panelUISettings, -2, 173, -2).addContainerGap(267, Short.MAX_VALUE)));
        this.chckbxOpenRomNode = new JCheckBox("Open rom node expanded");
        this.chckbxShowTableToolbar = new JCheckBox("Show table toolbar border");
        this.panelTreeSettings = new JPanel();
        this.panelTreeSettings.setBorder(new TitledBorder(null, "Rom Tree Settings", 4, 2, null, null));
        this.chckbxOpenTablesAt = new JCheckBox("Always open tables at [0,0]");
        GroupLayout gl_panelUISettings = new GroupLayout(panelUISettings);
        gl_panelUISettings.setHorizontalGroup(gl_panelUISettings.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelUISettings.createSequentialGroup().addGroup(gl_panelUISettings.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chckbxOpenRomNode).addComponent(this.chckbxShowTableToolbar)).addContainerGap(244, Short.MAX_VALUE)).addComponent(this.panelTreeSettings, -1, 395, Short.MAX_VALUE).addGroup(gl_panelUISettings.createSequentialGroup().addComponent(this.chckbxOpenTablesAt).addContainerGap()));
        gl_panelUISettings.setVerticalGroup(gl_panelUISettings.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelUISettings.createSequentialGroup().addComponent(this.chckbxOpenRomNode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chckbxShowTableToolbar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chckbxOpenTablesAt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addComponent(this.panelTreeSettings, -2, 69, -2)));
        this.labelTableClick.setText("Click to open tables");
        this.tableClickCount.setModel(new DefaultComboBoxModel<String>(new String[]{"Single", "Double"}));
        this.tableClickBehavior.setModel(new DefaultComboBoxModel<String>(new String[]{"open/close", "open/focus"}));
        this.lblClickBehavior = new JLabel("Table click behavior");
        GroupLayout gl_panelTreeSettings = new GroupLayout(this.panelTreeSettings);
        gl_panelTreeSettings.setHorizontalGroup(gl_panelTreeSettings.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelTreeSettings.createSequentialGroup().addGroup(gl_panelTreeSettings.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableClickCount, 0, 72, Short.MAX_VALUE).addComponent(this.tableClickBehavior, 0, 86, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panelTreeSettings.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelTableClick).addComponent(this.lblClickBehavior)).addGap(200)));
        gl_panelTreeSettings.setVerticalGroup(gl_panelTreeSettings.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelTreeSettings.createSequentialGroup().addGroup(gl_panelTreeSettings.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTableClick).addComponent(this.tableClickCount, -2, 18, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panelTreeSettings.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblClickBehavior).addComponent(this.tableClickBehavior, -2, -1, -2)).addContainerGap(23, Short.MAX_VALUE)));
        this.panelTreeSettings.setLayout(gl_panelTreeSettings);
        panelUISettings.setLayout(gl_panelUISettings);
        this.jPanelDefault.setLayout(jPanelDefaultLayout);
        GroupLayout jPanelTableDisplayLayout = new GroupLayout(this.jPanelTableDisplay);
        jPanelTableDisplayLayout.setHorizontalGroup(jPanelTableDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTableDisplayLayout.createSequentialGroup().addContainerGap().addGroup(jPanelTableDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCellHeight).addComponent(this.lblFont)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTableDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnChooseFont).addGroup(jPanelTableDisplayLayout.createSequentialGroup().addComponent(this.cellHeight, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 155, Short.MAX_VALUE).addComponent(this.lblCellWidth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cellWidth, -2, 50, -2))).addGap(47)).addGroup(jPanelTableDisplayLayout.createSequentialGroup().addComponent(this.jPanel4, -1, 417, Short.MAX_VALUE).addContainerGap()).addGroup(jPanelTableDisplayLayout.createSequentialGroup().addComponent(this.jPanel3, -1, 417, Short.MAX_VALUE).addContainerGap()).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(jPanelTableDisplayLayout.createSequentialGroup().addContainerGap().addComponent(this.saveDebugTables).addContainerGap(184, Short.MAX_VALUE)).addGroup(jPanelTableDisplayLayout.createSequentialGroup().addContainerGap().addComponent(this.displayHighTables).addContainerGap(214, Short.MAX_VALUE)).addGroup(jPanelTableDisplayLayout.createSequentialGroup().addContainerGap().addComponent(this.valueLimitWarning).addContainerGap(246, Short.MAX_VALUE)).addGroup(jPanelTableDisplayLayout.createSequentialGroup().addContainerGap().addComponent(this.chckbxColorAxis).addContainerGap(324, Short.MAX_VALUE)));
        jPanelTableDisplayLayout.setVerticalGroup(jPanelTableDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTableDisplayLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveDebugTables).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayHighTables).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueLimitWarning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chckbxColorAxis).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTableDisplayLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCellWidth).addComponent(this.cellWidth, -2, -1, -2).addComponent(this.lblCellHeight).addComponent(this.cellHeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTableDisplayLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFont).addComponent(this.btnChooseFont, -2, 18, -2)).addContainerGap()));
        this.jPanelTableDisplay.setLayout(jPanelTableDisplayLayout);
        GroupLayout jPanelClipboardLayout = new GroupLayout(this.jPanelClipboard);
        jPanelClipboardLayout.setHorizontalGroup(jPanelClipboardLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelClipboardLayout.createSequentialGroup().addContainerGap().addGroup(jPanelClipboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelClipboardLayout.createSequentialGroup().addGap(17).addGroup(jPanelClipboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rdbtnAirboys).addComponent(this.rdbtnDefault).addComponent(this.rdbtnCustom)))).addGap(157)));
        jPanelClipboardLayout.setVerticalGroup(jPanelClipboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelClipboardLayout.createSequentialGroup().addContainerGap().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdbtnDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdbtnAirboys).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdbtnCustom).addGap(435)));
        this.jPanelClipboard.setLayout(jPanelClipboardLayout);
        this.editorIconsPanel.setBorder(new TitledBorder(null, "Editor Toolbar Icons", 4, 2, null, null));
        this.tableIconsPanel.setBorder(new TitledBorder(null, "Table Toolbar Icons", 4, 2, null, null));
        GroupLayout jPanelIconsLayout = new GroupLayout(this.jPanelIcons);
        jPanelIconsLayout.setHorizontalGroup(jPanelIconsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelIconsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelIconsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editorIconsPanel, -1, 407, Short.MAX_VALUE).addComponent(this.tableIconsPanel, -1, 407, Short.MAX_VALUE)).addContainerGap()));
        jPanelIconsLayout.setVerticalGroup(jPanelIconsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelIconsLayout.createSequentialGroup().addContainerGap().addComponent(this.editorIconsPanel, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableIconsPanel, -2, 64, -2).addContainerGap(367, Short.MAX_VALUE)));
        JLabel lblTableIconScale = new JLabel("Scale:");
        this.textFieldTableIconScale = new JTextField();
        this.textFieldTableIconScale.setToolTipText("The percentage of the icons original size.");
        this.textFieldTableIconScale.setColumns(10);
        JLabel labelTableScalePercent = new JLabel("%");
        GroupLayout tableIconsPanelLayout = new GroupLayout(this.tableIconsPanel);
        tableIconsPanelLayout.setHorizontalGroup(tableIconsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tableIconsPanelLayout.createSequentialGroup().addContainerGap().addComponent(lblTableIconScale).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldTableIconScale, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(labelTableScalePercent).addContainerGap(216, Short.MAX_VALUE)));
        tableIconsPanelLayout.setVerticalGroup(tableIconsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tableIconsPanelLayout.createSequentialGroup().addContainerGap().addGroup(tableIconsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblTableIconScale).addComponent(this.textFieldTableIconScale, -2, -1, -2).addComponent(labelTableScalePercent)).addContainerGap(116, Short.MAX_VALUE)));
        this.tableIconsPanel.setLayout(tableIconsPanelLayout);
        JLabel lblEditorIconScale = new JLabel("Scale:");
        this.textFieldEditorIconScale = new JTextField();
        this.textFieldEditorIconScale.setToolTipText("The percentage of the icons original size.");
        this.textFieldEditorIconScale.setColumns(10);
        JLabel labelEditorScalePercent = new JLabel("%");
        GroupLayout editorIconsPanelLayout = new GroupLayout(this.editorIconsPanel);
        editorIconsPanelLayout.setHorizontalGroup(editorIconsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editorIconsPanelLayout.createSequentialGroup().addContainerGap().addComponent(lblEditorIconScale).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldEditorIconScale, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(labelEditorScalePercent).addContainerGap(216, Short.MAX_VALUE)));
        editorIconsPanelLayout.setVerticalGroup(editorIconsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editorIconsPanelLayout.createSequentialGroup().addContainerGap().addGroup(editorIconsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblEditorIconScale).addComponent(this.textFieldEditorIconScale, -2, -1, -2).addComponent(labelEditorScalePercent)).addContainerGap(95, Short.MAX_VALUE)));
        this.editorIconsPanel.setLayout(editorIconsPanelLayout);
        this.jPanelIcons.setLayout(jPanelIconsLayout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        Settings settings = this.getSettings();
        if (e.getSource() == this.maxColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", settings.getMaxColor());
            if (color == null) return;
            this.maxColor.setBackground(color);
            return;
        } else if (e.getSource() == this.minColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", settings.getMinColor());
            if (color == null) return;
            this.minColor.setBackground(color);
            return;
        } else if (e.getSource() == this.highlightColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", settings.getHighlightColor());
            if (color == null) return;
            this.highlightColor.setBackground(color);
            return;
        } else if (e.getSource() == this.selectColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", settings.getSelectColor());
            if (color == null) return;
            this.selectColor.setBackground(color);
            return;
        } else if (e.getSource() == this.axisColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", settings.getAxisColor());
            if (color == null) return;
            this.axisColor.setBackground(color);
            return;
        } else if (e.getSource() == this.increaseColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", settings.getIncreaseBorder());
            if (color == null) return;
            this.increaseColor.setBackground(color);
            return;
        } else if (e.getSource() == this.decreaseColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", settings.getDecreaseBorder());
            if (color == null) return;
            this.decreaseColor.setBackground(color);
            return;
        } else if (e.getSource() == this.warningColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Warning Color", settings.getWarningColor());
            if (color == null) return;
            this.warningColor.setBackground(color);
            return;
        } else if (e.getSource() == this.btnApply) {
            this.applySettings();
            return;
        } else if (e.getSource() == this.btnOk) {
            this.applySettings();
            this.saveSettings();
            this.dispose();
            return;
        } else if (e.getSource() == this.btnCancel) {
            this.dispose();
            return;
        } else if (e.getSource() == this.btnChooseFont) {
            JFontChooser fc = new JFontChooser(this);
            fc.setLocationRelativeTo(this);
            if (fc.showDialog(settings.getTableFont()) != JFontChooser.OK_OPTION) return;
            this.btnChooseFont.setFont(fc.getFont());
            this.btnChooseFont.setText(fc.getFont().getFontName());
            return;
        } else if (e.getSource() == this.reset) {
            Settings newSettings = new Settings();
            Settings curSettings = this.getSettings();
            newSettings.setEcuDefinitionFiles(curSettings.getEcuDefinitionFiles());
            newSettings.setLastImageDir(curSettings.getLastImageDir());
            newSettings.setLastRepositoryDir(curSettings.getLastRepositoryDir());
            newSettings.setUserLevel(curSettings.getUserLevel());
            newSettings.setLoggerDefinitionFilePath(curSettings.getLoggerDefinitionFilePath());
            newSettings.setLoggerDebuggingLevel(curSettings.getLoggerDebuggingLevel());
            newSettings.setLoggerProfileFilePath(curSettings.getLoggerProfileFilePath());
            newSettings.setLoggerOutputDirPath(curSettings.getLoggerOutputDirPath());
            SettingsManager.save(newSettings);
            this.initSettings();
            return;
        } else if (e.getSource() == this.btnAddAssocs) {
            boolean added = false;
            try {
                if (this.extensionHex.isSelected()) {
                    added = true;
                }
                if (!this.extensionBin.isSelected()) return;
                added = true;
                return;
            }
            catch (Exception ex) {
                added = false;
                return;
            }
            finally {
                if (added) {
                    JOptionPane.showMessageDialog(null, "Association(s) added.", "Add Association Success", 1);
                } else {
                    JOptionPane.showMessageDialog(null, "Failed to add association(s).", "Add Association Failure", 0);
                }
            }
        } else {
            if (e.getSource() != this.btnRemoveAssocs) return;
            boolean removed = false;
            if (this.extensionHex.isSelected()) {
                // empty if block
            }
            if (this.extensionBin.isSelected()) {
                // empty if block
            }
            if (removed) {
                JOptionPane.showMessageDialog(null, "Association removed.", "Remove Association Success", 1);
                return;
            } else {
                JOptionPane.showMessageDialog(null, "Failed to remove association.", "Remove Association Failure", 0);
            }
        }
    }

    public void applySettings() {
        try {
            Integer.parseInt(this.cellHeight.getText());
        }
        catch (NumberFormatException ex) {
            this.cellHeight.setText((int)this.getSettings().getCellSize().getHeight() + "");
        }
        try {
            Integer.parseInt(this.cellWidth.getText());
        }
        catch (NumberFormatException ex) {
            this.cellWidth.setText((int)this.getSettings().getCellSize().getWidth() + "");
        }
        this.getSettings().setObsoleteWarning(this.obsoleteWarning.isSelected());
        this.getSettings().setCalcConflictWarning(this.calcConflictWarning.isSelected());
        this.getSettings().setDisplayHighTables(this.displayHighTables.isSelected());
        this.getSettings().setSaveDebugTables(this.saveDebugTables.isSelected());
        this.getSettings().setDebug(this.debug.isSelected());
        this.getSettings().setOpenExpanded(this.chckbxOpenRomNode.isSelected());
        this.getSettings().setAlwaysOpenTableAtZero(this.chckbxOpenTablesAt.isSelected());
        this.getSettings().setShowTableToolbarBorder(this.chckbxShowTableToolbar.isSelected());
        this.getSettings().setMaxColor(this.maxColor.getBackground());
        this.getSettings().setMinColor(this.minColor.getBackground());
        this.getSettings().setHighlightColor(this.highlightColor.getBackground());
        this.getSettings().setSelectColor(this.selectColor.getBackground());
        this.getSettings().setAxisColor(this.axisColor.getBackground());
        this.getSettings().setIncreaseBorder(this.increaseColor.getBackground());
        this.getSettings().setDecreaseBorder(this.decreaseColor.getBackground());
        this.getSettings().setScaleHeadersAndData(this.cbScaleHeaderAndData.isSelected());
        this.getSettings().setCellSize(new Dimension(Integer.parseInt(this.cellWidth.getText()), Integer.parseInt(this.cellHeight.getText())));
        this.getSettings().setTableFont(this.btnChooseFont.getFont());
        if (this.tableClickCount.getSelectedIndex() == 0) {
            this.getSettings().setTableClickCount(1);
        } else {
            this.getSettings().setTableClickCount(2);
        }
        if (1 == this.tableClickBehavior.getSelectedIndex()) {
            this.getSettings().setTableClickBehavior(1);
        } else {
            this.getSettings().setTableClickBehavior(0);
        }
        this.getSettings().setValueLimitWarning(this.valueLimitWarning.isSelected());
        this.getSettings().setWarningColor(this.warningColor.getBackground());
        this.getSettings().setColorAxis(this.chckbxColorAxis.isSelected());
        this.getSettings().setDefaultScale(this.defaultScale.getText());
        if (this.rdbtnAirboys.isSelected()) {
            this.getSettings().setAirboysFormat();
        } else if (this.rdbtnCustom.isSelected()) {
            this.getSettings().setTableClipboardFormat("Custom");
        } else {
            this.getSettings().setDefaultFormat();
        }
        try {
            this.getSettings().setEditorIconScale(Integer.parseInt(this.textFieldEditorIconScale.getText()));
            this.getEditor().getToolBar().updateIcons();
        }
        catch (NumberFormatException ex) {
            this.textFieldEditorIconScale.setText(String.valueOf(this.getSettings().getEditorIconScale()));
        }
        try {
            this.getSettings().setTableIconScale(Integer.parseInt(this.textFieldTableIconScale.getText()));
            this.getEditor().getTableToolBar().updateIcons();
        }
        catch (NumberFormatException ex) {
            this.textFieldTableIconScale.setText(String.valueOf(this.getSettings().getTableIconScale()));
        }
        this.getSettings().setDefaultScale(this.comboBoxDefaultScale.getSelectedItem().toString());
    }

    private Settings getSettings() {
        return SettingsManager.getSettings();
    }

    private ECUEditor getEditor() {
        return ECUEditorManager.getECUEditor();
    }

    public void saveSettings() {
        this.saveSettings(this.getSettings());
    }

    public void saveSettings(Settings newSettings) {
        SettingsManager.save(newSettings);
        this.drawVisibleTables();
        this.getEditor().refreshUI();
    }

    private void drawVisibleTables() {
        for (JInternalFrame frame : this.getEditor().getRightPanel().getAllFrames()) {
            if (!(frame instanceof TableFrame) || !frame.isVisible()) continue;
            TableFrame tableFrame = (TableFrame)frame;
            tableFrame.getTable().drawTable();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

