/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.util.HexUtil;
import java.util.Map;
import javax.swing.table.DefaultTableModel;

public final class SwitchStateTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -6053559125596735977L;
    private static final String[] colNames = new String[]{"Switch State", "State Data"};
    private Map<String, byte[]> switchStates;

    @Override
    public final int getColumnCount() {
        return colNames.length;
    }

    @Override
    public final String getColumnName(int column) {
        return colNames[column];
    }

    @Override
    public final Object getValueAt(int row, int column) {
        if (null != this.switchStates) {
            String key = (String)this.switchStates.keySet().toArray()[row];
            byte[] value = this.switchStates.get(key);
            switch (column) {
                case 0: {
                    return key;
                }
                case 1: {
                    return HexUtil.asHex(value);
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public final int getRowCount() {
        return null != this.switchStates ? this.switchStates.size() : 0;
    }

    public final Class<? extends Object> getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    @Override
    public final boolean isCellEditable(int row, int column) {
        return false;
    }

    public final void setScalesList(Map<String, byte[]> switchStates) {
        this.switchStates = switchStates;
    }
}

