/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.editor.ecu.ECUEditor;
import com.romraider.editor.ecu.ECUEditorManager;
import com.romraider.logger.ecu.ui.handler.table.TableUpdateHandler;
import com.romraider.maps.Rom;
import com.romraider.maps.Table;
import com.romraider.swing.JTableChooser;
import com.romraider.swing.TableMenuBar;
import com.romraider.swing.TableMenuItem;
import com.romraider.swing.TablePropertyPanel;
import com.romraider.swing.TableTreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class TableFrame
extends JInternalFrame
implements InternalFrameListener,
ActionListener {
    private static final long serialVersionUID = -2651279694660392351L;
    private final Table table;
    private TableMenuBar tableMenuBar = null;

    public TableFrame(String title, Table table) {
        super(title, true, true);
        this.table = table;
        this.add(table);
        this.setFrameIcon(null);
        this.setBorder(BorderFactory.createBevelBorder(0));
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            this.putClientProperty("JInternalFrame.isPalette", true);
        }
        this.setVisible(false);
        this.tableMenuBar = new TableMenuBar(this);
        this.setJMenuBar(this.tableMenuBar);
        this.setDefaultCloseOperation(2);
        this.addInternalFrameListener(this);
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        ECUEditor parent = this.getEditor();
        parent.getTableToolBar().updateTableToolBar();
        parent.getToolBar().updateButtons();
        parent.getEditorMenuBar().updateMenu();
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
        this.RegisterTable();
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        TableUpdateHandler.getInstance().deregisterTable(this.getTable());
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        this.getEditor().getTableToolBar().updateTableToolBar();
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        this.getEditor().getTableToolBar().updateTableToolBar();
    }

    public void RegisterTable() {
        TableUpdateHandler.getInstance().registerTable(this.getTable());
    }

    public Table getTable() {
        return this.table;
    }

    public ECUEditor getEditor() {
        return ECUEditorManager.getECUEditor();
    }

    public TableMenuBar getTableMenuBar() {
        return this.tableMenuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TableMenuBar menu = this.getTableMenuBar();
        if (e.getSource() == menu.getUndoAll()) {
            this.getTable().undoAll();
        } else if (e.getSource() == menu.getRevert()) {
            this.getTable().setRevertPoint();
        } else if (e.getSource() == menu.getUndoSel()) {
            this.getTable().undoSelected();
        } else if (e.getSource() == menu.getClose()) {
            ECUEditorManager.getECUEditor().removeDisplayTable(this);
        } else if (e.getSource() == menu.getTableProperties()) {
            JOptionPane.showMessageDialog(this.getTable(), new TablePropertyPanel(this.getTable()), this.getTable().getName() + " Table Properties", 1);
        } else if (e.getSource() == menu.getCopySel()) {
            this.getTable().copySelection();
        } else if (e.getSource() == menu.getCopyTable()) {
            this.getTable().copyTable();
        } else if (e.getSource() == menu.getPaste()) {
            this.getTable().paste();
        } else if (e.getSource() == menu.getCompareOff()) {
            this.getTable().setCompareTable(null);
            this.getTable().setCompareValueType(1);
            this.getTableMenuBar().getCompareToBin().setSelected(true);
        } else if (e.getSource() == menu.getCompareAbsolute()) {
            this.getTable().setCompareDisplay(2);
        } else if (e.getSource() == menu.getComparePercent()) {
            this.getTable().setCompareDisplay(1);
        } else if (e.getSource() == menu.getCompareOriginal()) {
            this.getTable().setCompareValueType(0);
            this.getTableMenuBar().getCompareToOriginal().setSelected(true);
            this.compareByTable(this.getTable());
        } else if (e.getSource() == menu.getCompareMap()) {
            JTableChooser chooser = new JTableChooser();
            Table selectedTable = chooser.showChooser(this.getTable());
            if (null != selectedTable) {
                this.compareByTable(selectedTable);
            }
        } else if (e.getSource() instanceof TableMenuItem) {
            Table selectedTable = this.findSimilarTable((TableMenuItem)e.getSource());
            if (null != e.getSource()) {
                this.compareByTable(selectedTable);
            }
        } else if (e.getSource() == menu.getCompareToOriginal()) {
            this.getTable().setCompareValueType(0);
            this.getTable().refreshCompare();
        } else if (e.getSource() == menu.getCompareToBin()) {
            this.getTable().setCompareValueType(1);
            this.getTable().refreshCompare();
        } else if (e.getSource() == menu.getInterp()) {
            this.getTable().interpolate();
        } else if (e.getSource() == menu.getVertInterp()) {
            this.getTable().verticalInterpolate();
        } else if (e.getSource() == menu.getHorizInterp()) {
            this.getTable().horizontalInterpolate();
        }
    }

    public void compareByTable(Table selectedTable) {
        if (null == selectedTable) {
            return;
        }
        this.getTable().setCompareTable(selectedTable);
        ECUEditorManager.getECUEditor().getTableToolBar().updateTableToolBar(this.getTable());
        this.getTable().populateCompareValues(selectedTable);
    }

    public void refreshSimilarOpenTables() {
        JMenu similarTables = this.getTableMenuBar().getSimilarOpenTables();
        similarTables.removeAll();
        block0: for (Rom rom : ECUEditorManager.getECUEditor().getImages()) {
            for (TableTreeNode tableNode : rom.getTableNodes()) {
                if (!tableNode.getTable().getName().equalsIgnoreCase(this.getTable().getName())) continue;
                TableMenuItem similarTable = new TableMenuItem(rom.getFileName());
                similarTable.setToolTipText(tableNode.getFrame().getTable().getName());
                similarTable.addActionListener(this);
                similarTables.add(similarTable);
                continue block0;
            }
        }
        this.getTableMenuBar().initCompareGroup();
        this.getTableMenuBar().repaint();
    }

    private Table findSimilarTable(TableMenuItem menuItem) {
        for (Rom rom : ECUEditorManager.getECUEditor().getImages()) {
            if (!menuItem.getText().equalsIgnoreCase(rom.getFileName())) continue;
            for (TableTreeNode treeNode : rom.getTableNodes()) {
                if (!menuItem.getToolTipText().equalsIgnoreCase(treeNode.getFrame().getTable().getName())) continue;
                return treeNode.getFrame().getTable();
            }
        }
        return null;
    }
}

