/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.maps.Table3D;
import com.romraider.swing.TableFrame;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class TableMenuBar
extends JMenuBar {
    private static final long serialVersionUID = -695692646459410510L;
    private JMenu fileMenu;
    private JMenuItem graph;
    private JMenu compareMenu;
    private JRadioButtonMenuItem compareOriginal;
    private JRadioButtonMenuItem compareMap;
    private JMenu similarOpenTables;
    private JRadioButtonMenuItem compareOff;
    private JMenu compareDisplay;
    private JRadioButtonMenuItem comparePercent;
    private JRadioButtonMenuItem compareAbsolute;
    private JMenu compareToValue;
    private JRadioButtonMenuItem compareToOriginal;
    private JRadioButtonMenuItem compareToBin;
    private JMenuItem close;
    private JMenu editMenu;
    private JMenuItem undoSel;
    private JMenuItem undoAll;
    private JMenuItem revert;
    private JMenuItem copySel;
    private JMenuItem copyTable;
    private JMenuItem paste;
    private JMenuItem interp;
    private JMenuItem vertInterp;
    private JMenuItem horizInterp;
    private JMenu viewMenu;
    private JMenuItem tableProperties;
    private ButtonGroup compareGroup;
    private ButtonGroup compareDisplayGroup;
    private ButtonGroup compareToGroup;

    public TableMenuBar(TableFrame frame) {
        this.initFileMenu(frame);
        this.initEditMenu(frame);
        this.initViewMenu(frame);
        this.applyTableTypeRules(frame);
    }

    private void initFileMenu(TableFrame frame) {
        this.fileMenu = new JMenu("Table");
        this.graph = new JMenuItem("View Graph");
        this.compareMenu = new JMenu("Compare");
        this.setClose(new JMenuItem("Close Table"));
        this.initCompareMenu(frame);
        this.getClose().setText("Close " + frame.getTable().getName());
        this.graph.addActionListener(frame);
        this.getClose().addActionListener(frame);
        this.graph.setMnemonic('G');
        this.getClose().setMnemonic('X');
        this.graph.setEnabled(false);
        this.fileMenu.add(this.graph);
        this.fileMenu.add(this.compareMenu);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.getClose());
        this.add(this.fileMenu);
    }

    private void initEditMenu(TableFrame frame) {
        this.editMenu = new JMenu("Edit");
        this.setUndoSel(new JMenuItem("Undo Selected Changes"));
        this.setUndoAll(new JMenuItem("Undo All Changes"));
        this.setRevert(new JMenuItem("Set Revert Point"));
        this.setCopySel(new JMenuItem("Copy Selection"));
        this.setCopyTable(new JMenuItem("Copy Table"));
        this.setPaste(new JMenuItem("Paste"));
        this.setVertInterp(new JMenuItem("Vertical Interpolate"));
        this.setHorizInterp(new JMenuItem("Horizontal Interpolate"));
        this.setInterp(new JMenuItem("Interpolate"));
        this.editMenu.add(this.getUndoSel());
        this.editMenu.add(this.getUndoAll());
        this.editMenu.add(this.getRevert());
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.getCopySel());
        this.editMenu.add(this.getCopyTable());
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.getPaste());
        this.editMenu.add(new JSeparator());
        if (frame.getTable() instanceof Table3D) {
            this.editMenu.add(this.getVertInterp());
            this.editMenu.add(this.getHorizInterp());
        }
        this.editMenu.add(this.getInterp());
        this.editMenu.setMnemonic('E');
        this.getUndoSel().setMnemonic('U');
        this.getUndoAll().setMnemonic('A');
        this.getRevert().setMnemonic('R');
        this.getCopySel().setMnemonic('C');
        this.getCopyTable().setMnemonic('T');
        this.getPaste().setMnemonic('P');
        this.getInterp().setMnemonic('I');
        this.getVertInterp().setMnemonic('V');
        this.getHorizInterp().setMnemonic('H');
        this.getUndoSel().addActionListener(frame);
        this.getUndoAll().addActionListener(frame);
        this.getRevert().addActionListener(frame);
        this.getCopySel().addActionListener(frame);
        this.getCopyTable().addActionListener(frame);
        this.getPaste().addActionListener(frame);
        this.getInterp().addActionListener(frame);
        this.getVertInterp().addActionListener(frame);
        this.getHorizInterp().addActionListener(frame);
        this.add(this.editMenu);
    }

    private void initViewMenu(TableFrame frame) {
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic('V');
        this.setTableProperties(new JMenuItem("Table Properties"));
        this.getTableProperties().setToolTipText("Select to view the table properties.");
        this.getTableProperties().setMnemonic('P');
        this.getTableProperties().addActionListener(frame);
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setMnemonic('T');
        this.viewMenu.add(this.getTableProperties());
        this.add(this.viewMenu);
    }

    private void initCompareMenu(TableFrame frame) {
        this.setCompareOriginal(new JRadioButtonMenuItem("Show Changes"));
        this.getCompareOriginal().setToolTipText("Compares the current values to the original or revert point values.");
        this.setCompareMap(new JRadioButtonMenuItem("Compare to Another Map"));
        this.getCompareMap().setToolTipText("Compares this table and a selected table.");
        this.setSimilarOpenTables(new JMenu("Compare to Table"));
        this.getSimilarOpenTables().setToolTipText("Compares this table to a similar table.");
        this.setCompareOff(new JRadioButtonMenuItem("Off"));
        this.setComparePercent(new JRadioButtonMenuItem("Percent Difference"));
        this.setCompareAbsolute(new JRadioButtonMenuItem("Absolute Difference"));
        this.compareDisplayGroup = new ButtonGroup();
        this.compareDisplayGroup.add(this.getComparePercent());
        this.compareDisplayGroup.add(this.getCompareAbsolute());
        this.compareDisplay = new JMenu("Display");
        this.compareDisplay.add(this.getComparePercent());
        this.compareDisplay.add(this.getCompareAbsolute());
        this.setCompareToOriginal(new JRadioButtonMenuItem("Compare to Original Value"));
        this.getCompareToOriginal().setToolTipText("Compares this table to the selected table's original or revert point values.");
        this.setCompareToBin(new JRadioButtonMenuItem("Compare to Bin Value"));
        this.getCompareToBin().setToolTipText("Compares this table to the selected table's current values.");
        this.compareToGroup = new ButtonGroup();
        this.compareToGroup.add(this.getCompareToOriginal());
        this.compareToGroup.add(this.getCompareToBin());
        this.compareToValue = new JMenu("Compare to");
        this.compareToValue.add(this.getCompareToOriginal());
        this.compareToValue.add(this.getCompareToBin());
        this.compareMenu.add(this.getCompareOriginal());
        this.compareMenu.add(this.getCompareMap());
        this.compareMenu.add(this.getSimilarOpenTables());
        this.compareMenu.add(this.getCompareOff());
        this.compareMenu.add(new JSeparator());
        this.compareMenu.add(this.compareDisplay);
        this.compareMenu.add(new JSeparator());
        this.compareMenu.add(this.compareToValue);
        this.compareMenu.setMnemonic('C');
        this.getCompareOriginal().setMnemonic('C');
        this.getCompareMap().setMnemonic('M');
        this.getCompareOff().setMnemonic('O');
        this.compareDisplay.setMnemonic('D');
        this.getComparePercent().setMnemonic('P');
        this.getCompareAbsolute().setMnemonic('A');
        this.getSimilarOpenTables().setMnemonic('S');
        this.compareToValue.setMnemonic('T');
        this.getCompareToOriginal().setMnemonic('R');
        this.getCompareToOriginal().setMnemonic('B');
        this.getCompareOff().setSelected(true);
        this.getCompareAbsolute().setSelected(true);
        this.getCompareToOriginal().setSelected(true);
        this.initCompareGroup();
        this.getCompareOriginal().addActionListener(frame);
        this.getCompareMap().addActionListener(frame);
        this.getCompareOff().addActionListener(frame);
        this.getComparePercent().addActionListener(frame);
        this.getCompareAbsolute().addActionListener(frame);
        this.getCompareToOriginal().addActionListener(frame);
        this.getCompareToBin().addActionListener(frame);
    }

    public void initCompareGroup() {
        this.compareGroup = new ButtonGroup();
        this.compareGroup.add(this.getCompareOriginal());
        this.compareGroup.add(this.getCompareMap());
        this.compareGroup.add(this.getCompareOff());
        for (int i = 0; i < this.getSimilarOpenTables().getItemCount(); ++i) {
            this.compareGroup.add(this.getSimilarOpenTables().getItem(i));
        }
    }

    private void applyTableTypeRules(TableFrame frame) {
        if (frame.getTable().getType() == 6) {
            this.editMenu.setEnabled(false);
            this.getCompareOriginal().setEnabled(false);
            this.getComparePercent().setEnabled(false);
            this.getCompareAbsolute().setEnabled(false);
            this.getCompareToOriginal().setEnabled(false);
            this.getCompareToBin().setEnabled(false);
        }
    }

    public JMenuItem getUndoAll() {
        return this.undoAll;
    }

    public void setUndoAll(JMenuItem undoAll) {
        this.undoAll = undoAll;
    }

    public JMenuItem getRevert() {
        return this.revert;
    }

    public void setRevert(JMenuItem revert) {
        this.revert = revert;
    }

    public JMenuItem getUndoSel() {
        return this.undoSel;
    }

    public void setUndoSel(JMenuItem undoSel) {
        this.undoSel = undoSel;
    }

    public JMenuItem getClose() {
        return this.close;
    }

    public void setClose(JMenuItem close) {
        this.close = close;
    }

    public JMenuItem getTableProperties() {
        return this.tableProperties;
    }

    public void setTableProperties(JMenuItem tableProperties) {
        this.tableProperties = tableProperties;
    }

    public JMenuItem getCopySel() {
        return this.copySel;
    }

    public void setCopySel(JMenuItem copySel) {
        this.copySel = copySel;
    }

    public JMenuItem getCopyTable() {
        return this.copyTable;
    }

    public void setCopyTable(JMenuItem copyTable) {
        this.copyTable = copyTable;
    }

    public JMenuItem getPaste() {
        return this.paste;
    }

    public void setPaste(JMenuItem paste) {
        this.paste = paste;
    }

    public JRadioButtonMenuItem getCompareOff() {
        return this.compareOff;
    }

    public void setCompareOff(JRadioButtonMenuItem compareOff) {
        this.compareOff = compareOff;
    }

    public JRadioButtonMenuItem getCompareAbsolute() {
        return this.compareAbsolute;
    }

    public void setCompareAbsolute(JRadioButtonMenuItem compareAbsolute) {
        this.compareAbsolute = compareAbsolute;
    }

    public JRadioButtonMenuItem getComparePercent() {
        return this.comparePercent;
    }

    public void setComparePercent(JRadioButtonMenuItem comparePercent) {
        this.comparePercent = comparePercent;
    }

    public JRadioButtonMenuItem getCompareOriginal() {
        return this.compareOriginal;
    }

    public void setCompareOriginal(JRadioButtonMenuItem compareOriginal) {
        this.compareOriginal = compareOriginal;
    }

    public JRadioButtonMenuItem getCompareToOriginal() {
        return this.compareToOriginal;
    }

    public void setCompareToOriginal(JRadioButtonMenuItem compareToOriginal) {
        this.compareToOriginal = compareToOriginal;
    }

    public JRadioButtonMenuItem getCompareMap() {
        return this.compareMap;
    }

    public void setCompareMap(JRadioButtonMenuItem compareMap) {
        this.compareMap = compareMap;
    }

    public JRadioButtonMenuItem getCompareToBin() {
        return this.compareToBin;
    }

    public void setCompareToBin(JRadioButtonMenuItem compareToBin) {
        this.compareToBin = compareToBin;
    }

    public JMenu getSimilarOpenTables() {
        return this.similarOpenTables;
    }

    public void setSimilarOpenTables(JMenu similarOpenTables) {
        this.similarOpenTables = similarOpenTables;
    }

    public JMenuItem getInterp() {
        return this.interp;
    }

    public void setInterp(JMenuItem interp) {
        this.interp = interp;
    }

    public JMenuItem getHorizInterp() {
        return this.horizInterp;
    }

    public void setHorizInterp(JMenuItem horizInterp) {
        this.horizInterp = horizInterp;
    }

    public JMenuItem getVertInterp() {
        return this.vertInterp;
    }

    public void setVertInterp(JMenuItem vertInterp) {
        this.vertInterp = vertInterp;
    }
}

