/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.TableSwitch;
import com.romraider.swing.ParameterIdsTableModel;
import com.romraider.swing.ScalesTableModel;
import com.romraider.swing.SwitchStateTableModel;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;

public class TablePropertyPanel
extends JPanel {
    private static final long serialVersionUID = -5817685772039277602L;
    private JLabel category;
    private JTextArea description;
    private JLabel endian;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JLabel lblCategory;
    private JLabel lblEndian;
    private JLabel lblStorageAddress;
    private JLabel lblStorageSize;
    private JLabel lblTable;
    private JLabel storageAddress;
    private JLabel storageSize;
    private JLabel tableName;
    private JLabel userLevel;
    private JScrollPane scrollPane;
    private JLabel lblLogId;
    private JScrollPane logIDscrollPane;

    public TablePropertyPanel(Table table) {
        int dim;
        this.initComponents();
        this.setVisible(true);
        this.category.setText(table.getCategory());
        if (6 == table.getType()) {
            dim = 1;
            this.storageSize.setText("switch");
            this.scrollPane.setViewportView(this.populateScalesTable(((TableSwitch)table).getSwitchStates()));
        } else {
            if (99 == table.getStorageType()) {
                this.storageSize.setText("float");
            } else {
                String dataType = table.isSignedData() ? "int" : "uint";
                this.storageSize.setText(dataType + table.getStorageType() * 8);
            }
            dim = table.getType();
            this.scrollPane.setViewportView(this.populateScalesTable(table.getScales()));
        }
        this.tableName.setText(String.format("%s (%dD)", table.getName(), dim));
        this.storageAddress.setText("0x" + Integer.toHexString(table.getStorageAddress()));
        if (table.getEndian() == 2) {
            this.endian.setText("big");
        } else {
            this.endian.setText("little");
        }
        this.description.setText(table.getDescription());
        if (table.getUserLevel() == 1) {
            this.userLevel.setText("Beginner");
        } else if (table.getUserLevel() == 2) {
            this.userLevel.setText("Intermediate");
        } else if (table.getUserLevel() == 3) {
            this.userLevel.setText("Advanced");
        } else if (table.getUserLevel() == 4) {
            this.userLevel.setText("All");
        } else if (table.getUserLevel() == 5) {
            this.userLevel.setText("Debug");
        }
        this.logIDscrollPane.setViewportView(this.populateLogParamTable(table.getLogParamString()));
    }

    private void initComponents() {
        this.lblTable = new JLabel();
        this.tableName = new JLabel();
        this.lblCategory = new JLabel();
        this.category = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblStorageAddress = new JLabel();
        this.lblStorageSize = new JLabel();
        this.lblEndian = new JLabel();
        this.endian = new JLabel();
        this.storageSize = new JLabel();
        this.storageAddress = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.description = new JTextArea();
        this.jLabel5 = new JLabel();
        this.userLevel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.logIDscrollPane = new JScrollPane();
        this.setAutoscrolls(true);
        this.setFont(new Font("Tahoma", 0, 12));
        this.setInheritsPopupMenu(true);
        this.lblTable.setText("Table:");
        this.lblTable.setFocusable(false);
        this.tableName.setText("Tablename (3D)");
        this.tableName.setFocusable(false);
        this.lblCategory.setText("Category:");
        this.lblCategory.setFocusable(false);
        this.category.setText("Category");
        this.category.setFocusable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder("Conversions")));
        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(this.jPanel1);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 170, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 75, Short.MAX_VALUE));
        this.jPanel1.setLayout(jPanel1Layout);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Storage"));
        this.lblStorageAddress.setText("Storage Address:");
        this.lblStorageAddress.setFocusable(false);
        this.lblStorageSize.setText("Data Type:");
        this.lblStorageSize.setFocusable(false);
        this.lblEndian.setText("Endian:");
        this.lblEndian.setFocusable(false);
        this.endian.setText("little");
        this.endian.setFocusable(false);
        this.storageSize.setText("unkn");
        this.storageSize.setFocusable(false);
        this.storageAddress.setText("0x00");
        this.storageAddress.setFocusable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(this.lblStorageAddress).add(this.lblStorageSize).add(this.lblEndian)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(1).add(this.endian).add(this.storageSize).add(this.storageAddress)).addContainerGap(28, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(3).add(this.lblStorageSize).add(this.storageSize)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.lblStorageAddress).add(this.storageAddress)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.lblEndian).add(this.endian)).addContainerGap(37, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Description"));
        this.jScrollPane1.setBorder(null);
        this.description.setBackground(new Color(236, 233, 216));
        this.description.setColumns(20);
        this.description.setEditable(false);
        this.description.setFont(new Font("Tahoma", 0, 11));
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setText("Description");
        this.description.setWrapStyleWord(true);
        this.description.setBorder(null);
        this.description.setOpaque(false);
        this.description.setRequestFocusEnabled(false);
        this.jScrollPane1.setViewportView(this.description);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(2, this.jScrollPane1, -1, 360, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(this.jScrollPane1, -1, 102, Short.MAX_VALUE).addContainerGap()));
        this.jLabel5.setText("User Level:");
        this.userLevel.setText("Beginner");
        this.lblLogId = new JLabel("Log Param:");
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCategory).addComponent(this.lblTable).addComponent(this.lblLogId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tableName, GroupLayout.Alignment.LEADING, -1, 370, Short.MAX_VALUE).addComponent(this.category, -1, 370, Short.MAX_VALUE).addComponent(this.logIDscrollPane, GroupLayout.Alignment.LEADING, -1, 300, 300))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userLevel, -1, 366, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, 430, Short.MAX_VALUE).addComponent(this.jPanel2, -1, 430, Short.MAX_VALUE).addComponent(this.jPanel3, -1, 430, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tableName).addComponent(this.lblTable)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCategory).addComponent(this.category)).addGap(6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.userLevel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLogId).addComponent(this.logIDscrollPane, -2, 75, -2)).addGap(8).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 93, -2).addGap(23)));
        this.setLayout(layout);
    }

    private JTable populateScalesTable(Vector<Scale> scales) {
        ScalesTableModel scalesModel = new ScalesTableModel();
        scalesModel.setScalesList(scales);
        return this.createScalesTable(scalesModel);
    }

    private JTable populateScalesTable(Map<String, byte[]> switchStates) {
        SwitchStateTableModel scalesModel = new SwitchStateTableModel();
        scalesModel.setScalesList(switchStates);
        return this.createScalesTable(scalesModel);
    }

    private JTable createScalesTable(DefaultTableModel tableModel) {
        JTable table = new JTable(tableModel);
        table.setAutoCreateRowSorter(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(true);
        table.setFillsViewportHeight(true);
        return table;
    }

    private JTable populateLogParamTable(String logParams) {
        String[] paramEntries;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String entry : paramEntries = logParams.split(", ")) {
            String[] entries = entry.split(":");
            if (paramMap.containsKey(entries[0])) continue;
            paramMap.put(entries[0], entries.length > 1 ? entries[1] : "n/a");
        }
        ParameterIdsTableModel tableModel = new ParameterIdsTableModel();
        tableModel.setParameterList(paramMap);
        JTable table = new JTable(tableModel);
        TableColumn column = null;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(240);
                continue;
            }
            column.setPreferredWidth(80);
        }
        table.setAutoCreateRowSorter(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(true);
        table.setFillsViewportHeight(true);
        return table;
    }
}

